/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static Logger log = LoggerFactory.getLogger(MiniSolrCloudCluster.class);
    private ZkTestServer zkServer;
    private List<JettySolrRunner> jettys;
    private File testDir = Files.createTempDir();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MiniSolrCloudCluster(int numServers, String hostContext, File solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class, String> extraRequestFilters) throws Exception {
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        SolrZkClient zkClient = null;
        FileInputStream is = null;
        try {
            zkClient = new SolrZkClient(this.zkServer.getZkHost(), 10000, 45000, null);
            zkClient.makePath("/solr", false, true);
            is = new FileInputStream(solrXml);
            zkClient.create("/solr/solr.xml", IOUtils.toByteArray((InputStream)is), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, true);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            if (zkClient != null) {
                zkClient.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        if (zkClient != null) {
            zkClient.close();
        }
        System.setProperty("solr.solrxml.location", "zookeeper");
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        this.jettys = new LinkedList<JettySolrRunner>();
        for (int i = 0; i < numServers; ++i) {
            this.startJettySolrRunner(hostContext, extraServlets, extraRequestFilters);
        }
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner startJettySolrRunner(String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class, String> extraRequestFilters) throws Exception {
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettySolrRunner jetty = new JettySolrRunner(this.testDir.getAbsolutePath(), context, 0, null, null, true, extraServlets, null, extraRequestFilters);
        jetty.start();
        this.jettys.add(jetty);
        return jetty;
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            for (int i = this.jettys.size() - 1; i >= 0; --i) {
                this.stopJettySolrRunner(i);
            }
        }
        finally {
            try {
                this.zkServer.shutdown();
            }
            finally {
                System.clearProperty("solr.solrxml.location");
                System.clearProperty("zkHost");
            }
        }
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || "".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }
}

