/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.indexer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;

public class IndexerActionFactory
extends BitFieldActionFactory {
    private static final IndexerAction[] AllActions = IndexerAction.values();
    private static final IndexerAction[] OneBitActions = new IndexerAction[]{IndexerAction.WRITE, IndexerAction.READ};

    public List<? extends BitFieldAction> getActionsByCode(int actionCode) {
        ArrayList actions = Lists.newArrayList();
        for (IndexerAction action : OneBitActions) {
            if ((action.code & actionCode) != action.code) continue;
            actions.add(new IndexerBitFieldAction(action));
        }
        return actions;
    }

    public BitFieldAction getActionByName(String name) {
        BitFieldAction val = null;
        for (IndexerAction action : AllActions) {
            if (!action.name.equalsIgnoreCase(name)) continue;
            return new IndexerBitFieldAction(action);
        }
        return val;
    }

    public static class IndexerBitFieldAction
    extends BitFieldAction {
        public IndexerBitFieldAction(IndexerAction action) {
            super(action.getName(), action.getCode());
        }
    }

    public static enum IndexerAction {
        WRITE("write", 1),
        READ("read", 2),
        ALL("*", 3);

        private String name;
        private int code;

        private IndexerAction(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public int getCode() {
            return this.code;
        }
    }
}

