/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.validation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.validation.Message;
import org.apache.sqoop.validation.Status;
import org.apache.sqoop.validation.validators.AbstractValidator;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ConfigValidationResult {
    Map<String, List<Message>> messages = new HashMap<String, List<Message>>();
    Status status = Status.getDefault();

    public void addValidatorResult(String name, AbstractValidator<String> validator) {
        if (validator.getStatus() == Status.getDefault()) {
            return;
        }
        this.status = Status.getWorstStatus(this.status, validator.getStatus());
        if (this.messages.containsKey(name)) {
            this.messages.get(name).addAll(validator.getMessages());
        } else {
            this.messages.put(name, validator.getMessages());
        }
    }

    public void mergeValidatorResult(ConfigValidationResult result) {
        this.messages.putAll(result.messages);
        this.status = Status.getWorstStatus(this.status, result.status);
    }

    public void addMessages(String name, List<Message> messages) {
        this.messages.put(name, messages);
        for (Message message : messages) {
            this.status = Status.getWorstStatus(this.status, message.getStatus());
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public Map<String, List<Message>> getMessages() {
        return this.messages;
    }
}

