/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.model;

import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.model.Configurable;
import org.apache.sqoop.model.MConfigurableType;
import org.apache.sqoop.model.MDriverConfig;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class MDriver
extends Configurable {
    public static final String DRIVER_NAME = "SqoopDriver";
    private final MDriverConfig driverConfig;
    private String version;
    private static final String uniqueName = "SqoopDriver";

    public MDriver(MDriverConfig driverConfig, String version) {
        this.driverConfig = driverConfig;
        this.version = version;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("driver-");
        sb.append(this.getPersistenceId()).append(":");
        sb.append("version = " + this.version);
        sb.append(", ").append(this.driverConfig.toString());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MDriver)) {
            return false;
        }
        MDriver driver = (MDriver)other;
        return this.version.equals(driver.getVersion()) && this.driverConfig.equals(driver.driverConfig);
    }

    public int hashCode() {
        int result = this.driverConfig.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public MDriverConfig getDriverConfig() {
        return this.driverConfig;
    }

    public MConfigurableType getType() {
        return MConfigurableType.DRIVER;
    }

    public String getUniqueName() {
        return "SqoopDriver";
    }

    @Override
    public MDriver clone(boolean cloneWithValue) {
        cloneWithValue = false;
        MDriver copy = new MDriver(this.driverConfig.clone(cloneWithValue), this.version);
        copy.setPersistenceId(this.getPersistenceId());
        return copy;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

