/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.SchemaSerialization;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.submission.SubmissionStatus;
import org.apache.sqoop.submission.counter.Counter;
import org.apache.sqoop.submission.counter.CounterGroup;
import org.apache.sqoop.submission.counter.Counters;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SubmissionBean
implements JsonBean {
    private static final String SUBMISSION = "submission";
    private static final String JOB = "job";
    private static final String CREATION_USER = "creation-user";
    private static final String CREATION_DATE = "creation-date";
    private static final String LAST_UPDATE_USER = "last-udpate-user";
    private static final String LAST_UPDATE_DATE = "last-update-date";
    private static final String STATUS = "status";
    private static final String EXTERNAL_ID = "external-id";
    private static final String EXTERNAL_LINK = "external-link";
    private static final String ERROR_SUMMARY = "error-summary";
    private static final String ERROR_DETAILS = "error-details";
    private static final String PROGRESS = "progress";
    private static final String COUNTERS = "counters";
    private static final String FROM_SCHEMA = "from-schema";
    private static final String TO_SCHEMA = "to-schema";
    private List<MSubmission> submissions;

    public List<MSubmission> getSubmissions() {
        return this.submissions;
    }

    public SubmissionBean(MSubmission submission) {
        this();
        this.submissions = new ArrayList<MSubmission>();
        this.submissions.add(submission);
    }

    public SubmissionBean(List<MSubmission> submissions) {
        this();
        this.submissions = submissions;
    }

    public SubmissionBean() {
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject submission = new JSONObject();
        submission.put((Object)SUBMISSION, (Object)this.extractSubmission(this.submissions.get(0)));
        return submission;
    }

    protected JSONArray extractSubmissions() {
        JSONArray submissionsArray = new JSONArray();
        for (MSubmission submission : this.submissions) {
            submissionsArray.add((Object)this.extractSubmission(submission));
        }
        return submissionsArray;
    }

    private JSONObject extractSubmission(MSubmission submission) {
        JSONObject object = new JSONObject();
        object.put((Object)JOB, (Object)submission.getJobId());
        object.put((Object)STATUS, (Object)submission.getStatus().name());
        object.put((Object)PROGRESS, (Object)submission.getProgress());
        if (submission.getCreationUser() != null) {
            object.put((Object)CREATION_USER, (Object)submission.getCreationUser());
        }
        if (submission.getCreationDate() != null) {
            object.put((Object)CREATION_DATE, (Object)submission.getCreationDate().getTime());
        }
        if (submission.getLastUpdateUser() != null) {
            object.put((Object)LAST_UPDATE_USER, (Object)submission.getLastUpdateUser());
        }
        if (submission.getLastUpdateDate() != null) {
            object.put((Object)LAST_UPDATE_DATE, (Object)submission.getLastUpdateDate().getTime());
        }
        if (submission.getExternalJobId() != null) {
            object.put((Object)EXTERNAL_ID, (Object)submission.getExternalJobId());
        }
        if (submission.getExternalLink() != null) {
            object.put((Object)EXTERNAL_LINK, (Object)submission.getExternalLink());
        }
        if (submission.getError().getErrorSummary() != null) {
            object.put((Object)ERROR_SUMMARY, (Object)submission.getError().getErrorSummary());
        }
        if (submission.getError().getErrorDetails() != null) {
            object.put((Object)ERROR_DETAILS, (Object)submission.getError().getErrorDetails());
        }
        if (submission.getCounters() != null) {
            object.put((Object)COUNTERS, (Object)this.extractCounters(submission.getCounters()));
        }
        if (submission.getFromSchema() != null) {
            object.put((Object)FROM_SCHEMA, (Object)SchemaSerialization.extractSchema(submission.getFromSchema()));
        }
        if (submission.getToSchema() != null) {
            object.put((Object)TO_SCHEMA, (Object)SchemaSerialization.extractSchema(submission.getToSchema()));
        }
        return object;
    }

    private JSONObject extractCounters(Counters counters) {
        JSONObject counterArray = new JSONObject();
        for (CounterGroup group : counters) {
            JSONObject counterGroup = new JSONObject();
            for (Counter counter : group) {
                counterGroup.put((Object)counter.getName(), (Object)counter.getValue());
            }
            counterArray.put((Object)group.getName(), (Object)counterGroup);
        }
        return counterArray;
    }

    @Override
    public void restore(JSONObject json) {
        this.submissions = new ArrayList<MSubmission>();
        JSONObject obj = (JSONObject)json.get((Object)SUBMISSION);
        this.submissions.add(this.restoreSubmission(obj));
    }

    protected void restoreSubmissions(JSONArray array) {
        this.submissions = new ArrayList<MSubmission>();
        for (Object obj : array) {
            this.submissions.add(this.restoreSubmission(obj));
        }
    }

    private MSubmission restoreSubmission(Object obj) {
        JSONObject object = (JSONObject)obj;
        MSubmission submission = new MSubmission();
        submission.setJobId((Long)object.get((Object)JOB));
        submission.setStatus(SubmissionStatus.valueOf((String)object.get((Object)STATUS)));
        submission.setProgress((Double)object.get((Object)PROGRESS));
        if (object.containsKey((Object)CREATION_USER)) {
            submission.setCreationUser((String)object.get((Object)CREATION_USER));
        }
        if (object.containsKey((Object)CREATION_DATE)) {
            submission.setCreationDate(new Date((Long)object.get((Object)CREATION_DATE)));
        }
        if (object.containsKey((Object)LAST_UPDATE_USER)) {
            submission.setLastUpdateUser((String)object.get((Object)LAST_UPDATE_USER));
        }
        if (object.containsKey((Object)LAST_UPDATE_DATE)) {
            submission.setLastUpdateDate(new Date((Long)object.get((Object)LAST_UPDATE_DATE)));
        }
        if (object.containsKey((Object)EXTERNAL_ID)) {
            submission.setExternalJobId((String)object.get((Object)EXTERNAL_ID));
        }
        if (object.containsKey((Object)EXTERNAL_LINK)) {
            submission.setExternalLink((String)object.get((Object)EXTERNAL_LINK));
        }
        if (object.containsKey((Object)ERROR_SUMMARY)) {
            submission.getError().setErrorSummary((String)object.get((Object)ERROR_SUMMARY));
        }
        if (object.containsKey((Object)ERROR_DETAILS)) {
            submission.getError().setErrorDetails((String)object.get((Object)ERROR_DETAILS));
        }
        if (object.containsKey((Object)COUNTERS)) {
            submission.setCounters(this.restoreCounters((JSONObject)object.get((Object)COUNTERS)));
        }
        if (object.containsKey((Object)FROM_SCHEMA)) {
            submission.setFromSchema(SchemaSerialization.restoreSchema((JSONObject)object.get((Object)FROM_SCHEMA)));
        }
        if (object.containsKey((Object)TO_SCHEMA)) {
            submission.setToSchema(SchemaSerialization.restoreSchema((JSONObject)object.get((Object)TO_SCHEMA)));
        }
        return submission;
    }

    public Counters restoreCounters(JSONObject object) {
        Set groupSet = object.entrySet();
        Counters counters = new Counters();
        for (Map.Entry groupEntry : groupSet) {
            CounterGroup group = new CounterGroup((String)groupEntry.getKey());
            Set counterSet = ((JSONObject)groupEntry.getValue()).entrySet();
            for (Map.Entry counterEntry : counterSet) {
                Counter counter = new Counter((String)counterEntry.getKey(), (Long)counterEntry.getValue());
                group.addCounter(counter);
            }
            counters.addCounterGroup(group);
        }
        return counters;
    }
}

