/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LinkBean
implements JsonBean {
    static final String CONNECTOR_ID = "connector-id";
    static final String LINK_CONFIG_VALUES = "link-config-values";
    static final String LINK = "link";
    private List<MLink> links;
    private Map<Long, ResourceBundle> linkConfigBundles = new HashMap<Long, ResourceBundle>();

    public LinkBean(MLink link) {
        this();
        this.links = new ArrayList<MLink>();
        this.links.add(link);
    }

    public LinkBean(List<MLink> links) {
        this();
        this.links = links;
    }

    public LinkBean() {
    }

    public void addConnectorConfigBundle(Long id, ResourceBundle connectorConfigBundle) {
        this.linkConfigBundles.put(id, connectorConfigBundle);
    }

    public boolean hasConnectorConfigBundle(Long id) {
        return this.linkConfigBundles.containsKey(id);
    }

    public List<MLink> getLinks() {
        return this.links;
    }

    public ResourceBundle getConnectorConfigBundle(Long id) {
        return this.linkConfigBundles.get(id);
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject link = new JSONObject();
        link.put((Object)LINK, (Object)this.extractLink(skipSensitive, this.links.get(0)));
        return link;
    }

    protected JSONArray extractLinks(boolean skipSensitive) {
        JSONArray linkArray = new JSONArray();
        for (MLink link : this.links) {
            linkArray.add((Object)this.extractLink(skipSensitive, link));
        }
        return linkArray;
    }

    private JSONObject extractLink(boolean skipSensitive, MLink link) {
        JSONObject linkJsonObject = new JSONObject();
        linkJsonObject.put((Object)"id", (Object)link.getPersistenceId());
        linkJsonObject.put((Object)"name", (Object)link.getName());
        linkJsonObject.put((Object)"enabled", (Object)link.getEnabled());
        linkJsonObject.put((Object)"creation-user", (Object)link.getCreationUser());
        linkJsonObject.put((Object)"creation-date", (Object)link.getCreationDate().getTime());
        linkJsonObject.put((Object)"update-user", (Object)link.getLastUpdateUser());
        linkJsonObject.put((Object)"update-date", (Object)link.getLastUpdateDate().getTime());
        linkJsonObject.put((Object)CONNECTOR_ID, (Object)link.getConnectorId());
        linkJsonObject.put((Object)LINK_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(link.getConnectorLinkConfig().getConfigs(), link.getConnectorLinkConfig().getType(), skipSensitive));
        return linkJsonObject;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.links = new ArrayList<MLink>();
        JSONObject obj = (JSONObject)jsonObject.get((Object)LINK);
        this.links.add(this.restoreLink(obj));
    }

    protected void restoreLinks(JSONArray array) {
        this.links = new ArrayList<MLink>();
        for (Object obj : array) {
            this.links.add(this.restoreLink(obj));
        }
    }

    private MLink restoreLink(Object obj) {
        JSONObject object = (JSONObject)obj;
        long connectorId = (Long)object.get((Object)CONNECTOR_ID);
        JSONArray connectorLinkConfig = (JSONArray)object.get((Object)LINK_CONFIG_VALUES);
        List<MConfig> linkConfig = ConfigInputSerialization.restoreConfigList(connectorLinkConfig);
        MLink link = new MLink(connectorId, new MLinkConfig(linkConfig));
        link.setPersistenceId((Long)object.get((Object)"id"));
        link.setName((String)object.get((Object)"name"));
        link.setEnabled((Boolean)object.get((Object)"enabled"));
        link.setCreationUser((String)object.get((Object)"creation-user"));
        link.setCreationDate(new Date((Long)object.get((Object)"creation-date")));
        link.setLastUpdateUser((String)object.get((Object)"update-user"));
        link.setLastUpdateDate(new Date((Long)object.get((Object)"update-date")));
        return link;
    }
}

