/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.json;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.sqoop.classification.InterfaceAudience;
import org.apache.sqoop.classification.InterfaceStability;
import org.apache.sqoop.json.JsonBean;
import org.apache.sqoop.json.util.ConfigInputSerialization;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MToConfig;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobBean
implements JsonBean {
    static final String FROM_LINK_ID = "from-link-id";
    static final String TO_LINK_ID = "to-link-id";
    static final String FROM_CONNECTOR_ID = "from-connector-id";
    static final String TO_CONNECTOR_ID = "to-connector-id";
    static final String FROM_CONFIG_VALUES = "from-config-values";
    static final String TO_CONFIG_VALUES = "to-config-values";
    static final String DRIVER_CONFIG_VALUES = "driver-config-values";
    private static final String JOB = "job";
    private List<MJob> jobs;
    private Map<Long, ResourceBundle> connectorConfigBundles = new HashMap<Long, ResourceBundle>();
    private ResourceBundle driverConfigBundle;

    public JobBean(MJob job) {
        this();
        this.jobs = new ArrayList<MJob>();
        this.jobs.add(job);
    }

    public JobBean(List<MJob> jobs) {
        this();
        this.jobs = jobs;
    }

    public JobBean() {
    }

    public void setDriverConfigBundle(ResourceBundle driverConfigBundle) {
        this.driverConfigBundle = driverConfigBundle;
    }

    public void addConnectorConfigBundle(Long id, ResourceBundle connectorConfigBundle) {
        this.connectorConfigBundles.put(id, connectorConfigBundle);
    }

    public boolean hasConnectorConfigBundle(Long id) {
        return this.connectorConfigBundles.containsKey(id);
    }

    public List<MJob> getJobs() {
        return this.jobs;
    }

    public ResourceBundle getConnectorConfigBundle(Long id) {
        return this.connectorConfigBundles.get(id);
    }

    public ResourceBundle getDriverConfigBundle() {
        return this.driverConfigBundle;
    }

    @Override
    public JSONObject extract(boolean skipSensitive) {
        JSONObject job = new JSONObject();
        job.put((Object)JOB, (Object)this.extractJob(skipSensitive, this.jobs.get(0)));
        return job;
    }

    protected JSONArray extractJobs(boolean skipSensitive) {
        JSONArray jobArray = new JSONArray();
        for (MJob job : this.jobs) {
            jobArray.add((Object)this.extractJob(skipSensitive, job));
        }
        return jobArray;
    }

    private JSONObject extractJob(boolean skipSensitive, MJob job) {
        JSONObject object = new JSONObject();
        object.put((Object)"id", (Object)job.getPersistenceId());
        object.put((Object)"name", (Object)job.getName());
        object.put((Object)"enabled", (Object)job.getEnabled());
        object.put((Object)"creation-user", (Object)job.getCreationUser());
        object.put((Object)"creation-date", (Object)job.getCreationDate().getTime());
        object.put((Object)"update-user", (Object)job.getLastUpdateUser());
        object.put((Object)"update-date", (Object)job.getLastUpdateDate().getTime());
        object.put((Object)FROM_CONNECTOR_ID, (Object)job.getFromConnectorId());
        object.put((Object)TO_CONNECTOR_ID, (Object)job.getToConnectorId());
        object.put((Object)FROM_LINK_ID, (Object)job.getFromLinkId());
        object.put((Object)TO_LINK_ID, (Object)job.getToLinkId());
        MFromConfig fromConfigList = job.getFromJobConfig();
        object.put((Object)FROM_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(fromConfigList.getConfigs(), fromConfigList.getType(), skipSensitive));
        MToConfig toConfigList = job.getToJobConfig();
        object.put((Object)TO_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(toConfigList.getConfigs(), toConfigList.getType(), skipSensitive));
        MDriverConfig driverConfigList = job.getDriverConfig();
        object.put((Object)DRIVER_CONFIG_VALUES, (Object)ConfigInputSerialization.extractConfigList(driverConfigList.getConfigs(), driverConfigList.getType(), skipSensitive));
        return object;
    }

    @Override
    public void restore(JSONObject jsonObject) {
        this.jobs = new ArrayList<MJob>();
        JSONObject obj = (JSONObject)jsonObject.get((Object)JOB);
        this.jobs.add(this.restoreJob(obj));
    }

    protected void restoreJobs(JSONArray array) {
        this.jobs = new ArrayList<MJob>();
        for (Object obj : array) {
            this.jobs.add(this.restoreJob(obj));
        }
    }

    private MJob restoreJob(Object obj) {
        JSONObject object = (JSONObject)obj;
        long fromConnectorId = (Long)object.get((Object)FROM_CONNECTOR_ID);
        long toConnectorId = (Long)object.get((Object)TO_CONNECTOR_ID);
        long fromConnectionId = (Long)object.get((Object)FROM_LINK_ID);
        long toConnectionId = (Long)object.get((Object)TO_LINK_ID);
        JSONArray fromConfigJson = (JSONArray)object.get((Object)FROM_CONFIG_VALUES);
        JSONArray toConfigJson = (JSONArray)object.get((Object)TO_CONFIG_VALUES);
        JSONArray driverConfigJson = (JSONArray)object.get((Object)DRIVER_CONFIG_VALUES);
        List<MConfig> fromConfig = ConfigInputSerialization.restoreConfigList(fromConfigJson);
        List<MConfig> toConfig = ConfigInputSerialization.restoreConfigList(toConfigJson);
        List<MConfig> driverConfig = ConfigInputSerialization.restoreConfigList(driverConfigJson);
        MJob job = new MJob(fromConnectorId, toConnectorId, fromConnectionId, toConnectionId, new MFromConfig(fromConfig), new MToConfig(toConfig), new MDriverConfig(driverConfig));
        job.setPersistenceId((Long)object.get((Object)"id"));
        job.setName((String)object.get((Object)"name"));
        job.setEnabled((Boolean)object.get((Object)"enabled"));
        job.setCreationUser((String)object.get((Object)"creation-user"));
        job.setCreationDate(new Date((Long)object.get((Object)"creation-date")));
        job.setLastUpdateUser((String)object.get((Object)"update-user"));
        job.setLastUpdateDate(new Date((Long)object.get((Object)"update-date")));
        return job;
    }
}

