/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import com.spatial4j.core.shape.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.spatial.bbox.BBoxOverlapRatioValueSource;
import org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.apache.lucene.spatial.query.SpatialArgs;
import org.apache.lucene.spatial.util.ShapeAreaValueSource;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.AbstractSpatialFieldType;
import org.apache.solr.schema.BoolField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaAware;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.TrieDoubleField;
import org.apache.solr.search.QParser;

public class BBoxField
extends AbstractSpatialFieldType<BBoxStrategy>
implements SchemaAware {
    private static final String PARAM_QUERY_TARGET_PROPORTION = "queryTargetProportion";
    private static final String PARAM_MIN_SIDE_LENGTH = "minSideLength";
    private String numberFieldName;
    private String booleanFieldName = "boolean";
    private IndexSchema schema;

    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
        super.init(schema, args);
        String v = args.remove("numberType");
        if (v == null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "The field type: " + this.typeName + " must specify the numberType attribute.");
        }
        this.numberFieldName = v;
        v = args.remove("booleanType");
        if (v != null) {
            this.booleanFieldName = v;
        }
    }

    @Override
    public void inform(IndexSchema schema) {
        this.schema = schema;
        FieldType numberType = schema.getFieldTypeByName(this.numberFieldName);
        FieldType booleanType = schema.getFieldTypeByName(this.booleanFieldName);
        if (numberType == null) {
            throw new RuntimeException("Cannot find number fieldType: " + this.numberFieldName);
        }
        if (booleanType == null) {
            throw new RuntimeException("Cannot find boolean fieldType: " + this.booleanFieldName);
        }
        if (!(booleanType instanceof BoolField)) {
            throw new RuntimeException("Must be a BoolField: " + booleanType);
        }
        if (!(numberType instanceof TrieDoubleField)) {
            throw new RuntimeException("Must be TrieDoubleField: " + numberType);
        }
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>(schema.getFields().values());
        for (SchemaField sf : fields) {
            if (sf.getType() != this) continue;
            String name = sf.getName();
            this.register(schema, name + "__minX", numberType);
            this.register(schema, name + "__maxX", numberType);
            this.register(schema, name + "__minY", numberType);
            this.register(schema, name + "__maxY", numberType);
            this.register(schema, name + "__xdl", booleanType);
        }
    }

    private void register(IndexSchema schema, String name, FieldType fieldType) {
        SchemaField sf = new SchemaField(name, fieldType);
        schema.getFields().put(sf.getName(), sf);
    }

    @Override
    protected BBoxStrategy newSpatialStrategy(String s) {
        BBoxStrategy strategy = new BBoxStrategy(this.ctx, s);
        SchemaField field = this.schema.getField(strategy.getFieldName() + "__minX");
        org.apache.lucene.document.FieldType luceneType = (org.apache.lucene.document.FieldType)field.createField(0.0, 1.0f).fieldType();
        if (field.hasDocValues()) {
            luceneType = new org.apache.lucene.document.FieldType(luceneType);
            luceneType.setDocValueType(FieldInfo.DocValuesType.NUMERIC);
        }
        strategy.setFieldType(luceneType);
        return strategy;
    }

    @Override
    protected ValueSource getValueSourceFromSpatialArgs(QParser parser, SchemaField field, SpatialArgs spatialArgs, String scoreParam, BBoxStrategy strategy) {
        switch (scoreParam) {
            case "overlapRatio": {
                double queryTargetProportion = 0.25;
                String v = parser.getParam(PARAM_QUERY_TARGET_PROPORTION);
                if (v != null) {
                    queryTargetProportion = Double.parseDouble(v);
                }
                double minSideLength = 0.0;
                v = parser.getParam(PARAM_MIN_SIDE_LENGTH);
                if (v != null) {
                    minSideLength = Double.parseDouble(v);
                }
                return new BBoxOverlapRatioValueSource(strategy.makeShapeValueSource(), this.ctx.isGeo(), (Rectangle)spatialArgs.getShape(), queryTargetProportion, minSideLength);
            }
            case "area": {
                return new ShapeAreaValueSource(strategy.makeShapeValueSource(), this.ctx, this.ctx.isGeo());
            }
            case "area2D": {
                return new ShapeAreaValueSource(strategy.makeShapeValueSource(), this.ctx, false);
            }
        }
        return super.getValueSourceFromSpatialArgs(parser, field, spatialArgs, scoreParam, strategy);
    }
}

