/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.model.sqoop;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;

public class SqoopActionFactory
extends BitFieldActionFactory {
    public BitFieldAction getActionByName(String name) {
        if ("ALL".equalsIgnoreCase(name)) {
            return new SqoopAction(SqoopActionType.ALL);
        }
        return new SqoopAction(name);
    }

    public List<? extends BitFieldAction> getActionsByCode(int code) {
        ArrayList actions = Lists.newArrayList();
        for (SqoopActionType action : SqoopActionType.getActionByCode(code)) {
            actions.add(new SqoopAction(action));
        }
        return actions;
    }

    public static class SqoopAction
    extends BitFieldAction {
        public SqoopAction(String name) {
            this(SqoopActionType.getActionByName(name));
        }

        public SqoopAction(SqoopActionType sqoopActionType) {
            super(sqoopActionType.name, sqoopActionType.code);
        }
    }

    static enum SqoopActionType {
        READ("read", 1),
        WRITE("write", 2),
        ALL("*", READ.getCode() | WRITE.getCode());

        private String name;
        private int code;

        private SqoopActionType(String name, int code) {
            this.name = name;
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        static SqoopActionType getActionByName(String name) {
            for (SqoopActionType action : SqoopActionType.values()) {
                if (!action.name.equalsIgnoreCase(name)) continue;
                return action;
            }
            throw new RuntimeException("can't get sqoopActionType by name:" + name);
        }

        static List<SqoopActionType> getActionByCode(int code) {
            ArrayList actions = Lists.newArrayList();
            for (SqoopActionType action : SqoopActionType.values()) {
                if ((action.code & code) != action.code || action == ALL) continue;
                actions.add(action);
            }
            if (actions.isEmpty()) {
                throw new RuntimeException("can't get sqoopActionType by code:" + code);
            }
            return actions;
        }
    }
}

