/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift.shim;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.security.sasl.SaslException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.hadoop.security.rpcauth.RpcAuthRegistry;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge20;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge25
extends HadoopThriftAuthBridge20 {
    @Override
    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new Server();
        }
        return new Server(keytabFile, principalConf);
    }

    @Override
    public Client createClient() {
        return new Client();
    }

    public static class Client
    extends HadoopThriftAuthBridge20.Client {
        @Override
        public TTransport createClientTransport(String principalConfig, String host, TTransport underlyingTransport, boolean wrapUgi) throws IOException {
            RpcAuthMethod rpcAuthMethod;
            String authTypeStr = System.getProperty("sentry.service.security.mode");
            if (authTypeStr == null || authTypeStr.equalsIgnoreCase("other")) {
                authTypeStr = "MAPRSASL";
            }
            if ((rpcAuthMethod = RpcAuthRegistry.getAuthMethod((String)authTypeStr.toUpperCase(Locale.ENGLISH))) == null) {
                throw new IOException("Unsupported authentication method: " + authTypeStr);
            }
            if (authTypeStr.equalsIgnoreCase("KERBEROS")) {
                return super.createClientTransport(principalConfig, host, underlyingTransport, wrapUgi);
            }
            try {
                Preconditions.checkArgument((!rpcAuthMethod.getMechanismName().equals("KERBEROS") ? 1 : 0) != 0, (Object)"Your system is configured to use Kerberos authentication. You should set value of 'sentry.service.security.mode' property to 'kerberos'");
                return new SentryPolicyServiceClientDefaultImpl.UgiSaslClientTransport(rpcAuthMethod.getMechanismName(), null, null, null, (Map<String, String>)ServiceConstants.ClientConfig.SASL_PROPERTIES, null, underlyingTransport, wrapUgi);
            }
            catch (SaslException se) {
                throw new IOException("Could not instantiate SASL transport", se);
            }
        }
    }

    public static class Server
    extends HadoopThriftAuthBridge20.Server {
        public Server() throws TTransportException {
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            super(keytabFile, principalConf);
        }

        @Override
        public TTransportFactory createTransportFactory(Configuration conf) throws TTransportException, IOException {
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            RpcAuthMethod rpcAuthMethod = RpcAuthRegistry.getAuthMethod((UserGroupInformation.AuthenticationMethod)this.realUgi.getAuthenticationMethod());
            if (rpcAuthMethod.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                return super.createTransportFactory(conf);
            }
            transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), null, "default", ServiceConstants.ServerConfig.SASL_PROPERTIES, rpcAuthMethod.createCallbackHandler());
            return new HadoopThriftAuthBridge.TUGIAssumingTransportFactory((TTransportFactory)transFactory, this.realUgi);
        }
    }
}

