/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift.shim;

import java.io.IOException;
import java.security.PrivilegedAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public abstract class HadoopThriftAuthBridge {
    protected static final String KERBEROS = "KERBEROS";

    public Client createClient() {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        throw new UnsupportedOperationException("The current version of Hadoop does not support Authentication");
    }

    public static class TUGIAssumingTransportFactory
    extends TTransportFactory {
        private final UserGroupInformation ugi;
        private final TTransportFactory wrapped;

        public TUGIAssumingTransportFactory(TTransportFactory wrapped, UserGroupInformation ugi) {
            assert (wrapped != null);
            assert (ugi != null);
            this.wrapped = wrapped;
            this.ugi = ugi;
        }

        public TTransport getTransport(final TTransport trans) {
            return (TTransport)this.ugi.doAs((PrivilegedAction)new PrivilegedAction<TTransport>(){

                @Override
                public TTransport run() {
                    return TUGIAssumingTransportFactory.this.wrapped.getTransport(trans);
                }
            });
        }
    }

    public static abstract class Server {
        public abstract TTransportFactory createTransportFactory(Configuration var1) throws TTransportException, IOException;
    }

    public static abstract class Client {
        public abstract TTransport createClientTransport(String var1, String var2, TTransport var3, boolean var4) throws IOException;
    }
}

