/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.service.thrift.HAClientInvocationHandler;
import org.apache.sentry.service.thrift.PoolClientInvocationHandler;

public class SentryServiceClientFactory {
    private SentryServiceClientFactory() {
    }

    public static SentryPolicyServiceClient create(Configuration conf) throws Exception {
        boolean haEnabled = conf.getBoolean("sentry.ha.enabled", false);
        boolean pooled = conf.getBoolean("sentry.service.client.connection.pool.enabled", false);
        if (pooled) {
            return (SentryPolicyServiceClient)Proxy.newProxyInstance(SentryPolicyServiceClientDefaultImpl.class.getClassLoader(), SentryPolicyServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new PoolClientInvocationHandler(conf));
        }
        if (haEnabled) {
            return (SentryPolicyServiceClient)Proxy.newProxyInstance(SentryPolicyServiceClientDefaultImpl.class.getClassLoader(), SentryPolicyServiceClientDefaultImpl.class.getInterfaces(), (InvocationHandler)new HAClientInvocationHandler(conf));
        }
        return new SentryPolicyServiceClientDefaultImpl(conf);
    }
}

