/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public class JaasConfiguration
extends Configuration {
    private static Map<String, AppConfigurationEntry> entries = new HashMap<String, AppConfigurationEntry>();
    private static JaasConfiguration me = null;
    private static final String krb5LoginModuleName = System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";

    private JaasConfiguration() {
    }

    public static Configuration getInstance() {
        if (me == null) {
            me = new JaasConfiguration();
        }
        return me;
    }

    public static void addEntryForKeytab(String name, String principal, String keytab) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("keyTab", keytab);
        options.put("principal", principal);
        options.put("useKeyTab", "true");
        options.put("storeKey", "true");
        options.put("useTicketCache", "false");
        AppConfigurationEntry entry = new AppConfigurationEntry(krb5LoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        entries.put(name, entry);
    }

    public static void addEntryForTicketCache(String sectionName) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("useKeyTab", "false");
        options.put("storeKey", "false");
        options.put("useTicketCache", "true");
        AppConfigurationEntry entry = new AppConfigurationEntry(krb5LoginModuleName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        entries.put(sectionName, entry);
    }

    public static void removeEntry(String name) {
        entries.remove(name);
    }

    public static void clearEntries() {
        entries.clear();
    }

    public static Map<String, AppConfigurationEntry> getEntries() {
        return entries;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return new AppConfigurationEntry[]{entries.get(name)};
    }
}

