/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.hadoop.net.NetUtils;
import org.apache.sentry.provider.db.service.persistent.FixedJsonInstanceSerializer;
import org.apache.sentry.provider.db.service.persistent.HAContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceManager.class);
    private HAContext haContext;
    private ServiceProvider<Void> serviceProvider;
    private ServiceDiscovery<Void> serviceDiscovery;

    public ServiceManager(HAContext haContext) throws IOException {
        this.haContext = haContext;
        this.init();
    }

    private void init() throws IOException {
        try {
            this.haContext.startCuratorFramework();
            FixedJsonInstanceSerializer<Void> instanceSerializer = new FixedJsonInstanceSerializer<Void>(Void.class);
            this.serviceDiscovery = ServiceDiscoveryBuilder.builder(Void.class).basePath("sentry-service").serializer(instanceSerializer).client(this.haContext.getCuratorFramework()).build();
            this.serviceDiscovery.start();
            this.serviceProvider = this.serviceDiscovery.serviceProviderBuilder().serviceName("sentry-service").build();
            this.serviceProvider.start();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ServiceInstance<Void> getServiceInstance() throws IOException {
        try {
            ServiceInstance service = this.serviceProvider.getInstance();
            return service;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void reportError(ServiceInstance<Void> instance) {
        this.serviceProvider.noteError(instance);
    }

    public static InetSocketAddress convertServiceInstance(ServiceInstance<?> service) {
        return NetUtils.createSocketAddr((String)service.getAddress(), (int)service.getPort());
    }

    public void close() {
        try {
            this.serviceProvider.close();
            this.serviceDiscovery.close();
            LOGGER.debug("Closed ZK resources");
        }
        catch (IOException e) {
            LOGGER.warn("Error closing the service manager", (Throwable)e);
        }
    }
}

