/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.datanucleus.enhancement.Detachable;
import org.datanucleus.enhancement.ExecutionContextReference;
import org.datanucleus.enhancement.Persistable;
import org.datanucleus.enhancement.StateManager;
import org.datanucleus.enhancer.EnhancementHelper;

@PersistenceCapable
public class MSentryRole
implements Detachable,
Persistable {
    private String roleName;
    private Set<MSentryPrivilege> privileges;
    private Set<MSentryGMPrivilege> gmPrivileges;
    private Set<MSentryGroup> groups;
    private long createTime;
    protected transient StateManager dnStateManager;
    protected transient byte dnFlags;
    protected Object[] dnDetachedState;
    private static final byte[] dnFieldFlags;
    private static final Class dnPersistableSuperclass;
    private static final Class[] dnFieldTypes;
    private static final String[] dnFieldNames;
    private static final int dnInheritedFieldCount;

    public MSentryRole(String roleName, long createTime) {
        this.roleName = roleName;
        this.createTime = createTime;
        this.privileges = new HashSet<MSentryPrivilege>();
        this.gmPrivileges = new HashSet<MSentryGMPrivilege>();
        this.groups = new HashSet<MSentryGroup>();
    }

    public long getCreateTime() {
        return MSentryRole.dnGetcreateTime(this);
    }

    public void setCreateTime(long createTime) {
        MSentryRole.dnSetcreateTime(this, createTime);
    }

    public String getRoleName() {
        return MSentryRole.dnGetroleName(this);
    }

    public void setRoleName(String roleName) {
        MSentryRole.dnSetroleName(this, roleName);
    }

    public void setPrivileges(Set<MSentryPrivilege> privileges) {
        MSentryRole.dnSetprivileges(this, privileges);
    }

    public Set<MSentryPrivilege> getPrivileges() {
        return MSentryRole.dnGetprivileges(this);
    }

    public Set<MSentryGMPrivilege> getGmPrivileges() {
        return MSentryRole.dnGetgmPrivileges(this);
    }

    public void setGmPrivileges(Set<MSentryGMPrivilege> gmPrivileges) {
        MSentryRole.dnSetgmPrivileges(this, gmPrivileges);
    }

    public void setGroups(Set<MSentryGroup> groups) {
        MSentryRole.dnSetgroups(this, groups);
    }

    public Set<MSentryGroup> getGroups() {
        return MSentryRole.dnGetgroups(this);
    }

    public void removePrivilege(MSentryPrivilege privilege) {
        if (MSentryRole.dnGetprivileges(this).remove(privilege)) {
            privilege.removeRole(this);
        }
    }

    public void appendPrivileges(Set<MSentryPrivilege> privileges) {
        MSentryRole.dnGetprivileges(this).addAll(privileges);
    }

    public void appendPrivilege(MSentryPrivilege privilege) {
        if (MSentryRole.dnGetprivileges(this).add(privilege)) {
            privilege.appendRole(this);
        }
    }

    public void removeGMPrivilege(MSentryGMPrivilege gmPrivilege) {
        if (MSentryRole.dnGetgmPrivileges(this).remove(gmPrivilege)) {
            gmPrivilege.removeRole(this);
        }
    }

    public void appendGMPrivilege(MSentryGMPrivilege gmPrivilege) {
        if (MSentryRole.dnGetgmPrivileges(this).add(gmPrivilege)) {
            gmPrivilege.appendRole(this);
        }
    }

    public void removeGMPrivileges() {
        for (MSentryGMPrivilege privilege : ImmutableSet.copyOf((Collection)MSentryRole.dnGetgmPrivileges(this))) {
            privilege.removeRole(this);
        }
        Preconditions.checkState((boolean)MSentryRole.dnGetgmPrivileges(this).isEmpty(), (Object)("gmPrivileges should be empty: " + MSentryRole.dnGetgmPrivileges(this)));
    }

    public void appendGroups(Set<MSentryGroup> groups) {
        MSentryRole.dnGetgroups(this).addAll(groups);
    }

    public void appendGroup(MSentryGroup group) {
        if (MSentryRole.dnGetgroups(this).add(group)) {
            group.appendRole(this);
        }
    }

    public void removeGroup(MSentryGroup group) {
        if (MSentryRole.dnGetgroups(this).remove(group)) {
            group.removeRole(this);
        }
    }

    public void removePrivileges() {
        for (MSentryPrivilege privilege : ImmutableSet.copyOf((Collection)MSentryRole.dnGetprivileges(this))) {
            privilege.removeRole(this);
        }
        Preconditions.checkState((boolean)MSentryRole.dnGetprivileges(this).isEmpty(), (Object)("Privileges should be empty: " + MSentryRole.dnGetprivileges(this)));
    }

    public String toString() {
        return "MSentryRole [roleName=" + MSentryRole.dnGetroleName(this) + ", privileges=[..]" + ", gmPrivileges=[..]" + ", groups=[...]" + ", createTime=" + MSentryRole.dnGetcreateTime(this) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (MSentryRole.dnGetroleName(this) == null ? 0 : MSentryRole.dnGetroleName(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSentryRole other = (MSentryRole)obj;
        return !(MSentryRole.dnGetroleName(this) == null ? MSentryRole.dnGetroleName(other) != null : !MSentryRole.dnGetroleName(this).equals(MSentryRole.dnGetroleName(other)));
    }

    static {
        dnFieldNames = MSentryRole.__dnFieldNamesInit();
        dnFieldTypes = MSentryRole.__dnFieldTypesInit();
        dnFieldFlags = MSentryRole.__dnFieldFlagsInit();
        dnInheritedFieldCount = MSentryRole.__dnGetInheritedFieldCount();
        dnPersistableSuperclass = MSentryRole.__dnPersistableSuperclassInit();
        EnhancementHelper.registerClass((Class)MSentryRole.___dn$loadClass("org.apache.sentry.provider.db.service.model.MSentryRole"), (String[])dnFieldNames, (Class[])dnFieldTypes, (byte[])dnFieldFlags, (Class)dnPersistableSuperclass, (Persistable)new MSentryRole());
    }

    protected MSentryRole() {
    }

    public void dnCopyKeyFieldsFromObjectId(Persistable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void dnCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Object oid) {
    }

    public void dnCopyKeyFieldsToObjectId(Persistable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object dnGetObjectId() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getObjectId((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[0];
    }

    public final Object dnGetVersion() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.getVersion((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return null;
        }
        return this.dnDetachedState[1];
    }

    protected final void dnPreSerialize() {
        if (this.dnStateManager != null) {
            this.dnStateManager.preSerialize((Persistable)this);
        }
    }

    public final ExecutionContextReference dnGetExecutionContext() {
        return this.dnStateManager != null ? this.dnStateManager.getExecutionContext((Persistable)this) : null;
    }

    public final Object dnGetTransactionalObjectId() {
        return this.dnStateManager != null ? this.dnStateManager.getTransactionalObjectId((Persistable)this) : null;
    }

    public final boolean dnIsDeleted() {
        return this.dnStateManager != null ? this.dnStateManager.isDeleted((Persistable)this) : false;
    }

    public final boolean dnIsDirty() {
        if (this.dnStateManager != null) {
            return this.dnStateManager.isDirty((Persistable)this);
        }
        if (!this.dnIsDetached()) {
            return false;
        }
        return ((BitSet)this.dnDetachedState[3]).length() > 0;
    }

    public final boolean dnIsNew() {
        return this.dnStateManager != null ? this.dnStateManager.isNew((Persistable)this) : false;
    }

    public final boolean dnIsPersistent() {
        return this.dnStateManager != null ? this.dnStateManager.isPersistent((Persistable)this) : false;
    }

    public final boolean dnIsTransactional() {
        return this.dnStateManager != null ? this.dnStateManager.isTransactional((Persistable)this) : false;
    }

    public void dnMakeDirty(String fieldName) {
        if (this.dnStateManager != null) {
            this.dnStateManager.makeDirty((Persistable)this, fieldName);
        }
        if (this.dnIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < dnFieldNames.length) {
                if (dnFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.dnDetachedState[2]).get(i + dnInheritedFieldCount)) {
                        ((BitSet)this.dnDetachedState[3]).set(i + dnInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object dnNewObjectIdInstance() {
        return null;
    }

    public Object dnNewObjectIdInstance(Object key) {
        return null;
    }

    public final void dnProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void dnReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.dnReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void dnReplaceFlags() {
        if (this.dnStateManager != null) {
            this.dnFlags = this.dnStateManager.replacingFlags((Persistable)this);
        }
    }

    public final synchronized void dnReplaceStateManager(StateManager sm) {
        if (this.dnStateManager != null) {
            this.dnStateManager = this.dnStateManager.replacingStateManager((Persistable)this, sm);
        } else {
            EnhancementHelper.checkAuthorizedStateManager((StateManager)sm);
            this.dnStateManager = sm;
            this.dnFlags = 1;
        }
    }

    public final synchronized void dnReplaceDetachedState() {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.dnDetachedState = this.dnStateManager.replacingDetachedState((Detachable)this, this.dnDetachedState);
    }

    public boolean dnIsDetached() {
        return this.dnStateManager == null && this.dnDetachedState != null;
    }

    public Persistable dnNewInstance(StateManager sm) {
        MSentryRole result = new MSentryRole();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        return result;
    }

    public Persistable dnNewInstance(StateManager sm, Object obj) {
        MSentryRole result = new MSentryRole();
        result.dnFlags = 1;
        result.dnStateManager = sm;
        result.dnCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void dnReplaceField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.createTime = this.dnStateManager.replacingLongField((Persistable)this, index);
                break;
            }
            case 1: {
                this.gmPrivileges = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 2: {
                this.groups = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 3: {
                this.privileges = (Set)this.dnStateManager.replacingObjectField((Persistable)this, index);
                break;
            }
            case 4: {
                this.roleName = this.dnStateManager.replacingStringField((Persistable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnProvideField(int index) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.dnStateManager.providedLongField((Persistable)this, index, this.createTime);
                break;
            }
            case 1: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.gmPrivileges);
                break;
            }
            case 2: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.groups);
                break;
            }
            case 3: {
                this.dnStateManager.providedObjectField((Persistable)this, index, this.privileges);
                break;
            }
            case 4: {
                this.dnStateManager.providedStringField((Persistable)this, index, this.roleName);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void dnCopyField(MSentryRole obj, int index) {
        switch (index) {
            case 0: {
                this.createTime = obj.createTime;
                break;
            }
            case 1: {
                this.gmPrivileges = obj.gmPrivileges;
                break;
            }
            case 2: {
                this.groups = obj.groups;
                break;
            }
            case 3: {
                this.privileges = obj.privileges;
                break;
            }
            case 4: {
                this.roleName = obj.roleName;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void dnCopyFields(Object obj, int[] indices) {
        if (this.dnStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MSentryRole)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MSentryRole");
        }
        MSentryRole other = (MSentryRole)obj;
        if (this.dnStateManager != other.dnStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.dnCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __dnFieldNamesInit() {
        return new String[]{"createTime", "gmPrivileges", "groups", "privileges", "roleName"};
    }

    private static final Class[] __dnFieldTypesInit() {
        return new Class[]{Long.TYPE, MSentryRole.___dn$loadClass("java.util.Set"), MSentryRole.___dn$loadClass("java.util.Set"), MSentryRole.___dn$loadClass("java.util.Set"), MSentryRole.___dn$loadClass("java.lang.String")};
    }

    private static final byte[] __dnFieldFlagsInit() {
        return new byte[]{21, 5, 10, 5, 21};
    }

    protected static int __dnGetInheritedFieldCount() {
        return 0;
    }

    protected static int dnGetManagedFieldCount() {
        return 5;
    }

    private static Class __dnPersistableSuperclassInit() {
        return null;
    }

    public static Class ___dn$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object dnSuperClone() throws CloneNotSupportedException {
        MSentryRole o = (MSentryRole)super.clone();
        o.dnFlags = 0;
        o.dnStateManager = null;
        return o;
    }

    private static long dnGetcreateTime(MSentryRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 0)) {
            return objPC.dnStateManager.getLongField((Persistable)objPC, 0, objPC.createTime);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void dnSetcreateTime(MSentryRole objPC, long val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setLongField((Persistable)objPC, 0, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(0);
            }
        }
    }

    private static Set dnGetgmPrivileges(MSentryRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 1)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 1, objPC.gmPrivileges);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"gmPrivileges\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.gmPrivileges;
    }

    private static void dnSetgmPrivileges(MSentryRole objPC, Set val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 1, objPC.gmPrivileges, (Object)val);
        } else {
            objPC.gmPrivileges = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(1);
            }
        }
    }

    private static Set dnGetgroups(MSentryRole objPC) {
        if (objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 2)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 2, objPC.groups);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(2) && !((BitSet)objPC.dnDetachedState[3]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"groups\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.groups;
    }

    private static void dnSetgroups(MSentryRole objPC, Set val) {
        if (objPC.dnStateManager == null) {
            objPC.groups = val;
        } else {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 2, objPC.groups, (Object)val);
        }
        if (objPC.dnIsDetached()) {
            ((BitSet)objPC.dnDetachedState[3]).set(2);
        }
    }

    private static Set dnGetprivileges(MSentryRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 3)) {
            return (Set)objPC.dnStateManager.getObjectField((Persistable)objPC, 3, objPC.privileges);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"privileges\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.privileges;
    }

    private static void dnSetprivileges(MSentryRole objPC, Set val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setObjectField((Persistable)objPC, 3, objPC.privileges, (Object)val);
        } else {
            objPC.privileges = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(3);
            }
        }
    }

    private static String dnGetroleName(MSentryRole objPC) {
        if (objPC.dnFlags > 0 && objPC.dnStateManager != null && !objPC.dnStateManager.isLoaded((Persistable)objPC, 4)) {
            return objPC.dnStateManager.getStringField((Persistable)objPC, 4, objPC.roleName);
        }
        if (objPC.dnIsDetached() && !((BitSet)objPC.dnDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"roleName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.roleName;
    }

    private static void dnSetroleName(MSentryRole objPC, String val) {
        if (objPC.dnFlags != 0 && objPC.dnStateManager != null) {
            objPC.dnStateManager.setStringField((Persistable)objPC, 4, objPC.roleName, val);
        } else {
            objPC.roleName = val;
            if (objPC.dnIsDetached()) {
                ((BitSet)objPC.dnDetachedState[3]).set(4);
            }
        }
    }
}

