/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntity;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.provider.db.log.util.Constants;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.ThriftUtil;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;

public class JsonLogEntityFactory {
    private static JsonLogEntityFactory factory = new JsonLogEntityFactory();

    private JsonLogEntityFactory() {
    }

    public static JsonLogEntityFactory getInstance() {
        return factory;
    }

    public JsonLogEntity createJsonLogEntity(TCreateSentryRoleRequest request, TCreateSentryRoleResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), true));
        return amle;
    }

    public JsonLogEntity createJsonLogEntity(TDropSentryRoleRequest request, TDropSentryRoleResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForCreateOrDropRole(request.getRoleName(), false));
        return amle;
    }

    public Set<JsonLogEntity> createJsonLogEntitys(TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response, Configuration conf) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (request.isSetPrivileges()) {
            for (TSentryPrivilege privilege : request.getPrivileges()) {
                JsonLogEntity logEntity = this.createJsonLogEntity(request, privilege, response, conf);
                setBuilder.add((Object)logEntity);
            }
        }
        return setBuilder.build();
    }

    private JsonLogEntity createJsonLogEntity(TAlterSentryRoleGrantPrivilegeRequest request, TSentryPrivilege privilege, TAlterSentryRoleGrantPrivilegeResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForGrantPrivilege(request));
        amle.setDatabaseName(privilege.getDbName());
        amle.setTableName(privilege.getTableName());
        amle.setResourcePath(privilege.getURI());
        return amle;
    }

    public Set<JsonLogEntity> createJsonLogEntitys(TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response, Configuration conf) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        if (request.isSetPrivileges()) {
            for (TSentryPrivilege privilege : request.getPrivileges()) {
                JsonLogEntity logEntity = this.createJsonLogEntity(request, privilege, response, conf);
                setBuilder.add((Object)logEntity);
            }
        }
        return setBuilder.build();
    }

    private JsonLogEntity createJsonLogEntity(TAlterSentryRoleRevokePrivilegeRequest request, TSentryPrivilege privilege, TAlterSentryRoleRevokePrivilegeResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForRevokePrivilege(request));
        amle.setDatabaseName(privilege.getDbName());
        amle.setTableName(privilege.getTableName());
        amle.setResourcePath(privilege.getURI());
        return amle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForRoleAddGroup(request));
        return amle;
    }

    public JsonLogEntity createJsonLogEntity(TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response, Configuration conf) {
        AuditMetadataLogEntity amle = this.createCommonAMLE(conf, response.getStatus(), request.getRequestorUserName(), request.getClass().getName());
        amle.setOperationText(CommandUtil.createCmdForRoleDeleteGroup(request));
        return amle;
    }

    public String isAllowed(TSentryResponseStatus status) {
        if (status.equals(Status.OK())) {
            return "true";
        }
        return "false";
    }

    private AuditMetadataLogEntity createCommonAMLE(Configuration conf, TSentryResponseStatus responseStatus, String userName, String requestClassName) {
        AuditMetadataLogEntity amle = new AuditMetadataLogEntity();
        amle.setUserName(userName);
        amle.setServiceName(conf.get("sentry.service.name", "Sentry-Service").trim());
        amle.setImpersonator(ThriftUtil.getImpersonator());
        amle.setIpAddress(ThriftUtil.getIpAddress());
        amle.setOperation(Constants.requestTypeToOperationMap.get(requestClassName));
        amle.setEventTime(Long.toString(System.currentTimeMillis()));
        amle.setAllowed(this.isAllowed(responseStatus));
        amle.setObjectType(Constants.requestTypeToObjectTypeMap.get(requestClassName));
        return amle;
    }
}

