/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.sentry.provider.db.log.entity.JsonLogEntity;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ContainerNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditMetadataLogEntity
implements JsonLogEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditMetadataLogEntity.class);
    private static final JsonFactory factory = new MappingJsonFactory();
    private String serviceName;
    private String userName;
    private String impersonator;
    private String ipAddress;
    private String operation;
    private String eventTime;
    private String operationText;
    private String allowed;
    private String databaseName;
    private String tableName;
    private String columnName;
    private String resourcePath;
    private String objectType;

    public AuditMetadataLogEntity() {
    }

    public AuditMetadataLogEntity(String serviceName, String userName, String impersonator, String ipAddress, String operation, String eventTime, String operationText, String allowed, String databaseName, String tableName, String columnName, String resourcePath, String objectType) {
        this.serviceName = serviceName;
        this.userName = userName;
        this.impersonator = impersonator;
        this.ipAddress = ipAddress;
        this.operation = operation;
        this.eventTime = eventTime;
        this.operationText = operationText;
        this.allowed = allowed;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.resourcePath = resourcePath;
        this.objectType = objectType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonFormatLog() {
        StringWriter stringWriter = new StringWriter();
        JsonGenerator json = null;
        try {
            json = factory.createJsonGenerator((Writer)stringWriter);
            json.writeStartObject();
            json.writeStringField("serviceName", this.serviceName);
            json.writeStringField("userName", this.userName);
            json.writeStringField("impersonator", this.impersonator);
            json.writeStringField("ipAddress", this.ipAddress);
            json.writeStringField("operation", this.operation);
            json.writeStringField("eventTime", this.eventTime);
            json.writeStringField("operationText", this.operationText);
            json.writeStringField("allowed", this.allowed);
            json.writeStringField("databaseName", this.databaseName);
            json.writeStringField("tableName", this.tableName);
            json.writeStringField("column", this.columnName);
            json.writeStringField("resourcePath", this.resourcePath);
            json.writeStringField("objectType", this.objectType);
            json.writeEndObject();
            json.flush();
        }
        catch (IOException e) {
            stringWriter = new StringWriter();
            String msg = "Error creating audit log in json format: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        finally {
            try {
                if (json != null) {
                    json.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error closing JsonGenerator", (Throwable)e);
            }
        }
        return stringWriter.toString();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getImpersonator() {
        return this.impersonator;
    }

    public void setImpersonator(String impersonator) {
        this.impersonator = impersonator;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public String getOperationText() {
        return this.operationText;
    }

    public void setOperationText(String operationText) {
        this.operationText = operationText;
    }

    public String getAllowed() {
        return this.allowed;
    }

    public void setAllowed(String allowed) {
        this.allowed = allowed;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public static ContainerNode parse(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper(factory);
        JsonNode jsonNode = mapper.readTree(json);
        if (!(jsonNode instanceof ContainerNode)) {
            throw new IOException("Wrong JSON data: " + json);
        }
        return (ContainerNode)jsonNode;
    }
}

