/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.provider.common.ProviderConstants;

public class PrivilegeObject {
    private final String component;
    private final String service;
    private final String action;
    private final Boolean grantOption;
    private List<? extends Authorizable> authorizables;

    private PrivilegeObject(String component, String service, String action, Boolean grantOption, List<? extends Authorizable> authorizables) {
        this.component = component;
        this.service = service;
        this.action = action;
        this.grantOption = grantOption;
        this.authorizables = authorizables;
    }

    public List<? extends Authorizable> getAuthorizables() {
        return this.authorizables;
    }

    public String getAction() {
        return this.action;
    }

    public String getComponent() {
        return this.component;
    }

    public String getService() {
        return this.service;
    }

    public Boolean getGrantOption() {
        return this.grantOption;
    }

    public String toString() {
        ArrayList authorizable = Lists.newArrayList();
        for (Authorizable authorizable2 : this.authorizables) {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)authorizable2.getTypeName(), (Object)authorizable2.getName(), new Object[0]));
        }
        return "PrivilegeObject [, service=" + this.service + ", component=" + this.component + ", authorizables=" + ProviderConstants.AUTHORIZABLE_JOINER.join((Iterable)authorizable) + ", action=" + this.action + ", grantOption=" + this.grantOption + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.component == null ? 0 : this.component.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this.grantOption == null ? 0 : this.grantOption.hashCode());
        for (Authorizable authorizable : this.authorizables) {
            result = 31 * result + authorizable.getTypeName().hashCode();
            result = 31 * result + authorizable.getName().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrivilegeObject other = (PrivilegeObject)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        if (this.component == null ? other.component != null : !this.component.equals(other.component)) {
            return false;
        }
        if (this.grantOption == null ? other.grantOption != null : !this.grantOption.equals(other.grantOption)) {
            return false;
        }
        if (this.authorizables.size() != other.authorizables.size()) {
            return false;
        }
        for (int i = 0; i < this.authorizables.size(); ++i) {
            String o2;
            String o1 = ProviderConstants.KV_JOINER.join((Object)this.authorizables.get(i).getTypeName(), (Object)this.authorizables.get(i).getName(), new Object[0]);
            if (o1.equalsIgnoreCase(o2 = ProviderConstants.KV_JOINER.join((Object)other.authorizables.get(i).getTypeName(), (Object)other.authorizables.get(i).getName(), new Object[0]))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private String component;
        private String service;
        private String action;
        private Boolean grantOption;
        private List<? extends Authorizable> authorizables;

        public Builder() {
        }

        public Builder(PrivilegeObject privilege) {
            this.component = privilege.component;
            this.service = privilege.service;
            this.action = privilege.action;
            this.grantOption = privilege.grantOption;
            this.authorizables = privilege.authorizables;
        }

        public Builder setComponent(String component) {
            this.component = component;
            return this;
        }

        public Builder setService(String service) {
            this.service = service;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder withGrantOption(Boolean grantOption) {
            this.grantOption = grantOption;
            return this;
        }

        public Builder setAuthorizables(List<? extends Authorizable> authorizables) {
            this.authorizables = authorizables;
            return this;
        }

        private List<? extends Authorizable> toLowerAuthorizableName(List<? extends Authorizable> authorizables) {
            ArrayList newAuthorizable = Lists.newArrayList();
            if (authorizables == null || authorizables.size() == 0) {
                return newAuthorizable;
            }
            for (final Authorizable authorizable : authorizables) {
                newAuthorizable.add(new Authorizable(){

                    public String getTypeName() {
                        return authorizable.getTypeName();
                    }

                    public String getName() {
                        return authorizable.getName().toLowerCase();
                    }
                });
            }
            return newAuthorizable;
        }

        public PrivilegeObject build() {
            Preconditions.checkNotNull((Object)this.component);
            Preconditions.checkNotNull((Object)this.service);
            Preconditions.checkNotNull((Object)this.action);
            List<? extends Authorizable> newAuthorizable = this.toLowerAuthorizableName(this.authorizables);
            return new PrivilegeObject(this.component.toLowerCase(), this.service.toLowerCase(), this.action.toLowerCase(), this.grantOption, newAuthorizable);
        }
    }
}

