/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericProviderBackend
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericProviderBackend.class);
    private final Configuration conf;
    private volatile boolean initialized = false;
    private String componentType;
    private String serviceName;

    public SentryGenericProviderBackend(Configuration conf, String resource) throws Exception {
        this.conf = conf;
    }

    public void initialize(ProviderBackendContext context) {
        if (this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has already been initialized, cannot be initialized twice");
        }
        this.initialized = true;
    }

    private SentryGenericServiceClient getClient() throws Exception {
        return SentryGenericServiceClientFactory.create(this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
        SentryGenericServiceClient client = null;
        try {
            client = this.getClient();
            ImmutableSet immutableSet = ImmutableSet.copyOf(client.listPrivilegesForProvider(this.componentType, this.serviceName, roleSet, groups, Arrays.asList(authorizableHierarchy)));
            return immutableSet;
        }
        catch (SentryUserException e) {
            String msg = "Unable to obtain privileges from server: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unable to obtain client:" + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return ImmutableSet.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
        SentryGenericServiceClient client = null;
        try {
            HashSet tRoles = Sets.newHashSet();
            client = this.getClient();
            String requestor = UserGroupInformation.getCurrentUser().getShortUserName();
            for (String group : groups) {
                tRoles.addAll(client.listRolesByGroupName(requestor, group, this.getComponentType()));
            }
            HashSet roles = Sets.newHashSet();
            for (TSentryRole tRole : tRoles) {
                roles.add(tRole.getRoleName());
            }
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)(roleSet.isAll() ? roles : Sets.intersection((Set)roles, (Set)roleSet.getRoles())));
            return immutableSet;
        }
        catch (SentryUserException e) {
            String msg = "Unable to obtain roles from server: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unable to obtain client:" + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
        return ImmutableSet.of();
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized) {
            throw new IllegalStateException("SentryGenericProviderBackend has not been properly initialized");
        }
    }

    public void close() {
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }
}

