/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift.shim;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.util.VersionInfo;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;

public abstract class ShimLoader {
    private static HadoopThriftAuthBridge hadoopThriftAuthBridge;
    private static final HashMap<String, String> HADOOP_THRIFT_AUTH_BRIDGE_CLASSES;

    public static synchronized HadoopThriftAuthBridge getHadoopThriftAuthBridge() {
        if (hadoopThriftAuthBridge == null) {
            hadoopThriftAuthBridge = ShimLoader.loadShims(HADOOP_THRIFT_AUTH_BRIDGE_CLASSES, HadoopThriftAuthBridge.class);
        }
        return hadoopThriftAuthBridge;
    }

    private static <T> T loadShims(Map<String, String> classMap, Class<T> xface) {
        String vers = ShimLoader.getMajorVersion();
        String className = classMap.get(vers);
        return ShimLoader.createShim(className, xface);
    }

    public static String getMajorVersion() {
        String vers = VersionInfo.getVersion();
        String[] parts = vers.split("\\.");
        if (parts.length < 2) {
            throw new RuntimeException("Illegal Hadoop Version: " + vers + " (expected A.B.* format)");
        }
        switch (Integer.parseInt(parts[0])) {
            case 0: {
                throw new IllegalArgumentException("Unrecognized Hadoop major version number: " + vers);
            }
            case 1: {
                return "0.20";
            }
            case 2: {
                int minor = Integer.parseInt(parts[1]);
                if (minor < 5) {
                    return "0.20";
                }
                return "0.25";
            }
        }
        throw new IllegalArgumentException("Unrecognized Hadoop major version number: " + vers);
    }

    private static <T> T createShim(String className, Class<T> xface) {
        try {
            Class<?> clazz = Class.forName(className);
            return xface.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load shims in class " + className, e);
        }
    }

    static {
        HADOOP_THRIFT_AUTH_BRIDGE_CLASSES = new HashMap();
        HADOOP_THRIFT_AUTH_BRIDGE_CLASSES.put("0.20", "org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge20");
        HADOOP_THRIFT_AUTH_BRIDGE_CLASSES.put("0.25", "org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge25");
    }
}

