/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift.shim;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.GSSCallback;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;

public class HadoopThriftAuthBridge20
extends HadoopThriftAuthBridge {
    @Override
    public Client createClient() {
        return new Client();
    }

    @Override
    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        return new Server(keytabFile, principalConf);
    }

    public static class Server
    extends HadoopThriftAuthBridge.Server {
        final UserGroupInformation realUgi;

        public Server() throws TTransportException {
            try {
                this.realUgi = UserGroupInformation.getCurrentUser();
            }
            catch (IOException ioe) {
                throw new TTransportException((Throwable)ioe);
            }
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            if (keytabFile == null || keytabFile.isEmpty()) {
                throw new TTransportException("No keytab specified");
            }
            if (principalConf == null || principalConf.isEmpty()) {
                throw new TTransportException("No principal specified");
            }
            try {
                String kerberosName = SecurityUtil.getServerPrincipal((String)principalConf, (String)"0.0.0.0");
                UserGroupInformation.loginUserFromKeytab((String)kerberosName, (String)keytabFile);
                this.realUgi = UserGroupInformation.getLoginUser();
                assert (this.realUgi.isFromKeytab());
            }
            catch (IOException ioe) {
                throw new TTransportException((Throwable)ioe);
            }
        }

        @Override
        public TTransportFactory createTransportFactory(Configuration conf) throws TTransportException, IOException {
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            String kerberosName = this.realUgi.getUserName();
            String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
            if (names.length != 3) {
                throw new TTransportException("Kerberos principal should have 3 parts: " + kerberosName);
            }
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), names[0], names[1], ServiceConstants.ServerConfig.SASL_PROPERTIES, (CallbackHandler)((Object)new GSSCallback(conf)));
            return new HadoopThriftAuthBridge.TUGIAssumingTransportFactory((TTransportFactory)transFactory, this.realUgi);
        }
    }

    public static class Client
    extends HadoopThriftAuthBridge.Client {
        @Override
        public TTransport createClientTransport(String principalConfig, String host, TTransport underlyingTransport, boolean wrapUgi) throws IOException {
            Preconditions.checkNotNull((Object)principalConfig, (Object)"Unsupported authentication method. Only Kerberos is supported. To use Kerberos please set value of 'sentry.service.security.mode' property to 'kerberos'");
            String serverPrincipal = SecurityUtil.getServerPrincipal((String)principalConfig, (String)host);
            String[] names = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkArgument((names.length == 3 ? 1 : 0) != 0, (Object)("Kerberos principal should have 3 parts: " + serverPrincipal));
            return new SentryPolicyServiceClient.UgiSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, names[0], names[1], (Map<String, String>)ServiceConstants.ClientConfig.SASL_PROPERTIES, null, underlyingTransport, wrapUgi);
        }
    }
}

