/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.sentry.Command;
import org.apache.sentry.service.thrift.PidUtils;
import org.apache.sentry.service.thrift.ProcessorFactory;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;
import org.apache.sentry.service.thrift.shim.ShimLoader;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryService
implements Callable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryService.class);
    private final Configuration conf;
    private final InetSocketAddress address;
    private final int maxThreads;
    private final int minThreads;
    private boolean isSecured;
    private final ExecutorService serviceExecutor;
    private Future future;
    private TServer thriftServer;
    private static int port;
    private Status status;

    public SentryService(Configuration conf) throws IOException {
        this.conf = conf;
        port = conf.getInt("sentry.service.server.rpc-port", 8038);
        if (port == 0) {
            port = SentryService.findFreePort();
        }
        this.address = NetUtils.createSocketAddr((String)conf.get("sentry.service.server.rpc-address", "0.0.0.0"), (int)port);
        LOGGER.info("Configured on address " + this.address);
        this.isSecured = !"none".equalsIgnoreCase(conf.get("sentry.service.security.mode", "none").trim());
        this.maxThreads = conf.getInt("sentry.service.server-max-threads", 500);
        this.minThreads = conf.getInt("sentry.service.server-min-threads", 10);
        this.serviceExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){
            private int count = 0;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, SentryService.class.getSimpleName() + "-" + this.count++);
            }
        });
        this.status = Status.NOT_STARTED;
    }

    public String call() throws Exception {
        this.runServer();
        return null;
    }

    private void runServer() throws Exception {
        Iterable processorFactories = ServiceConstants.ConfUtilties.CLASS_SPLITTER.split((CharSequence)this.conf.get("sentry.service.processor.factories", "org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessorFactory").trim());
        TMultiplexedProcessor processor = new TMultiplexedProcessor();
        boolean registeredProcessor = false;
        for (String processorFactory : processorFactories) {
            Class clazz = this.conf.getClassByName(processorFactory);
            if (!ProcessorFactory.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Processor Factory " + processorFactory + " is not a " + ProcessorFactory.class.getName());
            }
            try {
                Constructor constructor = clazz.getConstructor(Configuration.class);
                ProcessorFactory factory = (ProcessorFactory)constructor.newInstance(this.conf);
                registeredProcessor = factory.register(processor) || registeredProcessor;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create " + processorFactory, e);
            }
        }
        if (!registeredProcessor) {
            throw new IllegalStateException("Failed to register any processors from " + processorFactories);
        }
        HadoopThriftAuthBridge hadoopThriftAuthBridge = ShimLoader.getHadoopThriftAuthBridge();
        TServerSocket serverTransport = new TServerSocket(this.address);
        String principal = this.conf.get("sentry.service.server.principal", "");
        String keytab = this.conf.get("sentry.service.server.keytab", "");
        TTransportFactory transportFactory = this.isSecured ? hadoopThriftAuthBridge.createServer(keytab, principal).createTransportFactory(this.conf) : new TTransportFactory();
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor((TProcessor)processor)).transportFactory(transportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(this.minThreads).maxWorkerThreads(this.maxThreads);
        this.thriftServer = new TThreadPoolServer(args);
        LOGGER.info("Serving on " + this.address);
        this.thriftServer.serve();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public synchronized boolean isRunning() {
        return this.status == Status.STARTED && this.thriftServer != null && this.thriftServer.isServing();
    }

    public synchronized void start() throws Exception {
        if (this.status != Status.NOT_STARTED) {
            throw new IllegalStateException("Cannot start when " + (Object)((Object)this.status));
        }
        LOGGER.info("Attempting to start...");
        this.status = Status.STARTED;
        this.future = this.serviceExecutor.submit(this);
    }

    public synchronized void stop() {
        if (this.status == Status.NOT_STARTED) {
            return;
        }
        LOGGER.info("Attempting to stop...");
        if (this.thriftServer.isServing()) {
            this.thriftServer.stop();
        }
        this.thriftServer = null;
        this.status = Status.NOT_STARTED;
        LOGGER.info("Stopped...");
    }

    private static int findFreePort() {
        int attempts = 0;
        while (attempts++ <= 1000) {
            try {
                ServerSocket s = new ServerSocket(0);
                int port = s.getLocalPort();
                s.close();
                return port;
            }
            catch (IOException iOException) {
            }
        }
        throw new IllegalStateException("Unable to find a port after 1000 attempts");
    }

    public static Configuration loadConfig(String configFileName) throws MalformedURLException {
        File configFile = null;
        if (configFileName == null) {
            throw new IllegalArgumentException("Usage: conffile path/to/sentry-service.xml");
        }
        configFile = new File(configFileName);
        if (!configFile.isFile() || !configFile.canRead()) {
            throw new IllegalArgumentException("Cannot read configuration file " + configFile);
        }
        Configuration conf = new Configuration(false);
        conf.addResource(configFile.toURL());
        return conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static class CommandImpl
    implements Command {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(String[] args) throws Exception {
            GnuParser parser = new GnuParser();
            Options options = new Options();
            options.addOption("c", "conffile", true, "Sentry Service configuration file");
            CommandLine commandLine = parser.parse(options, args);
            String configFileName = commandLine.getOptionValue("conffile");
            File configFile = null;
            if (configFileName == null || commandLine.hasOption("h") || commandLine.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("sentry --command service", options);
                System.exit(-1);
            } else {
                configFile = new File(configFileName);
                if (!configFile.isFile() || !configFile.canRead()) {
                    throw new IllegalArgumentException("Cannot read configuration file " + configFile);
                }
            }
            Configuration serverConf = SentryService.loadConfig(configFileName);
            final SentryService server = new SentryService(serverConf);
            server.start();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    LOGGER.info("ShutdownHook shutting down server");
                    try {
                        server.stop();
                    }
                    catch (Throwable t) {
                        LOGGER.error("Error stopping SentryService", t);
                    }
                }
            });
            PidUtils.createSentryServicePidFile(port);
            try {
                LOGGER.info("Waiting on future.get()");
                server.future.get();
            }
            finally {
                server.serviceExecutor.shutdown();
            }
        }
    }

    private static enum Status {
        NOT_STARTED,
        STARTED;

    }
}

