/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.net.Socket;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyService;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryProcessorWrapper<I extends SentryPolicyService.Iface>
extends SentryPolicyService.Processor<SentryPolicyService.Iface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryProcessorWrapper.class);

    public SentryProcessorWrapper(I iface) {
        super(iface);
    }

    public boolean process(TProtocol in, TProtocol out) throws TException {
        this.setIpAddress(in);
        this.setImpersonator(in);
        return super.process(in, out);
    }

    private void setImpersonator(TProtocol in) {
        TTransport transport = in.getTransport();
        if (transport instanceof TSaslServerTransport) {
            String impersonator = ((TSaslServerTransport)transport).getSaslServer().getAuthorizationID();
            CommandUtil.setImpersonator(impersonator);
        }
    }

    private void setIpAddress(TProtocol in) {
        TTransport transport = in.getTransport();
        TSocket tSocket = this.getUnderlyingSocketFromTransport(transport);
        if (tSocket != null) {
            this.setIpAddress(tSocket.getSocket());
        } else {
            LOGGER.warn("Unknown Transport, cannot determine ipAddress");
        }
    }

    private void setIpAddress(Socket socket) {
        CommandUtil.setIpAddress(socket.getInetAddress().toString());
    }

    private TSocket getUnderlyingSocketFromTransport(TTransport transport) {
        if (transport != null) {
            if (transport instanceof TSaslServerTransport) {
                transport = ((TSaslServerTransport)transport).getUnderlyingTransport();
            } else if (transport instanceof TSaslClientTransport) {
                transport = ((TSaslClientTransport)transport).getUnderlyingTransport();
            } else if (transport instanceof TSocket) {
                return (TSocket)transport;
            }
        }
        return null;
    }
}

