/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.service.thrift.NotificationHandlerInvoker;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyService;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.Status;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryPolicyStoreProcessor
implements SentryPolicyService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryPolicyStoreProcessor.class);
    private static final Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"sentry.hive.authorization.ddl.logger");
    public static final String SENTRY_POLICY_SERVICE_NAME = "SentryPolicyService";
    private final String name;
    private final Configuration conf;
    private final SentryStore sentryStore;
    private final NotificationHandlerInvoker notificationHandlerInvoker;
    private final ImmutableSet<String> adminGroups;
    private boolean isReady;

    public SentryPolicyStoreProcessor(String name, Configuration conf) throws Exception {
        this.name = name;
        this.conf = conf;
        this.notificationHandlerInvoker = new NotificationHandlerInvoker(conf, SentryPolicyStoreProcessor.createHandlers(conf));
        this.isReady = false;
        this.sentryStore = new SentryStore(conf);
        this.isReady = true;
        this.adminGroups = ImmutableSet.copyOf(SentryPolicyStoreProcessor.toTrimedLower(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    public void stop() {
        if (this.isReady) {
            this.sentryStore.stop();
        }
    }

    @VisibleForTesting
    static List<NotificationHandler> createHandlers(Configuration conf) throws SentryConfigurationException {
        ArrayList handlers = Lists.newArrayList();
        Iterable notificationHandlers = Splitter.onPattern((String)"[\\s,]").trimResults().omitEmptyStrings().split((CharSequence)conf.get("sentry.policy.store.notification.handlers", ""));
        for (String notificationHandler : notificationHandlers) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(notificationHandler);
                if (!NotificationHandler.class.isAssignableFrom(clazz)) {
                    throw new SentryConfigurationException("Class " + notificationHandler + " is not a " + NotificationHandler.class.getName());
                }
            }
            catch (ClassNotFoundException e) {
                throw new SentryConfigurationException("Value " + notificationHandler + " is not a class", e);
            }
            Preconditions.checkNotNull(clazz, (Object)"Error class cannot be null");
            try {
                Constructor<?> constructor = clazz.getConstructor(Configuration.class);
                handlers.add((NotificationHandler)constructor.newInstance(conf));
            }
            catch (Exception e) {
                throw new SentryConfigurationException("Error attempting to create " + notificationHandler, e);
            }
        }
        return handlers;
    }

    @VisibleForTesting
    public Configuration getSentryStoreConf() {
        return this.conf;
    }

    private static Set<String> toTrimedLower(Set<String> s) {
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private boolean inAdminGroups(Set<String> requestorGroups) {
        return !Sets.intersection(this.adminGroups, requestorGroups = SentryPolicyStoreProcessor.toTrimedLower(requestorGroups)).isEmpty();
    }

    private void authorize(String requestorUser, Set<String> requestorGroups) throws SentryAccessDeniedException {
        if (!this.inAdminGroups(requestorGroups)) {
            String msg = "User: " + requestorUser + " is part of " + requestorGroups + " which does not, intersect admin groups " + this.adminGroups;
            LOGGER.warn(msg);
            throw new SentryAccessDeniedException("Access denied to " + requestorUser);
        }
    }

    @Override
    public TCreateSentryRoleResponse create_sentry_role(TCreateSentryRoleRequest request) throws TException {
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        try {
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            CommitContext commitContext = this.sentryStore.createSentryRole(request.getRoleName());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.create_sentry_role(commitContext, request, response);
        }
        catch (SentryAlreadyExistsException e) {
            String msg = "Role: " + request + " already exists.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.AlreadyExists(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TAlterSentryRoleGrantPrivilegeResponse alter_sentry_role_grant_privilege(TAlterSentryRoleGrantPrivilegeRequest request) throws TException {
        TAlterSentryRoleGrantPrivilegeResponse response = new TAlterSentryRoleGrantPrivilegeResponse();
        try {
            CommitContext commitContext = this.sentryStore.alterSentryRoleGrantPrivilege(request.getRequestorUserName(), request.getRoleName(), request.getPrivilege());
            response.setStatus(Status.OK());
            response.setPrivilege(request.getPrivilege());
            this.notificationHandlerInvoker.alter_sentry_role_grant_privilege(commitContext, request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request.getRoleName() + " doesn't exist.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryInvalidInputException e) {
            String msg = "Invalid input privilege object";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.InvalidInput(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TAlterSentryRoleRevokePrivilegeResponse alter_sentry_role_revoke_privilege(TAlterSentryRoleRevokePrivilegeRequest request) throws TException {
        TAlterSentryRoleRevokePrivilegeResponse response = new TAlterSentryRoleRevokePrivilegeResponse();
        try {
            CommitContext commitContext = this.sentryStore.alterSentryRoleRevokePrivilege(request.getRequestorUserName(), request.getRoleName(), request.getPrivilege());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_revoke_privilege(commitContext, request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Privilege: [server=" + request.getPrivilege().getServerName() + ",db=" + request.getPrivilege().getDbName() + ",table=" + request.getPrivilege().getTableName() + ",URI=" + request.getPrivilege().getURI() + ",action=" + request.getPrivilege().getAction() + "] doesn't exist.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryInvalidInputException e) {
            String msg = "Invalid input privilege object";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.InvalidInput(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TDropSentryRoleResponse drop_sentry_role(TDropSentryRoleRequest request) throws TException {
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        try {
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            CommitContext commitContext = this.sentryStore.dropSentryRole(request.getRoleName());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.drop_sentry_role(commitContext, request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role :" + request + " does not exist.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TAlterSentryRoleAddGroupsResponse alter_sentry_role_add_groups(TAlterSentryRoleAddGroupsRequest request) throws TException {
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        try {
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            CommitContext commitContext = this.sentryStore.alterSentryRoleAddGroups(request.getRequestorUserName(), request.getRoleName(), request.getGroups());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_add_groups(commitContext, request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " does not exist.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TAlterSentryRoleDeleteGroupsResponse alter_sentry_role_delete_groups(TAlterSentryRoleDeleteGroupsRequest request) throws TException {
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        try {
            this.authorize(request.getRequestorUserName(), this.getRequestorGroups(request.getRequestorUserName()));
            CommitContext commitContext = this.sentryStore.alterSentryRoleDeleteGroups(request.getRoleName(), request.getGroups());
            response.setStatus(Status.OK());
            this.notificationHandlerInvoker.alter_sentry_role_delete_groups(commitContext, request, response);
        }
        catch (SentryNoSuchObjectException e) {
            String msg = "Role: " + request + " does not exist.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error adding groups to role: " + request;
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        AUDIT_LOGGER.info(JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, this.conf).toJsonFormatLog());
        return response;
    }

    @Override
    public TListSentryRolesResponse list_sentry_roles_by_group(TListSentryRolesRequest request) throws TException {
        TListSentryRolesResponse response = new TListSentryRolesResponse();
        Set<TSentryRole> roleSet = new HashSet<TSentryRole>();
        String subject = request.getRequestorUserName();
        boolean checkAllGroups = false;
        try {
            Set<String> groups = this.getRequestorGroups(subject);
            if ("*".equalsIgnoreCase(request.getGroupName())) {
                checkAllGroups = true;
            } else {
                boolean admin = this.inAdminGroups(groups);
                if (!(admin || request.getGroupName() != null && groups.contains(request.getGroupName()))) {
                    throw new SentryAccessDeniedException("Access denied to " + subject);
                }
                groups.clear();
                groups.add(request.getGroupName());
            }
            roleSet = this.sentryStore.getTSentryRolesByGroupName(groups, checkAllGroups);
            response.setRoles(roleSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setRoles(roleSet);
            String msg = "Role: " + request + " couldn't be retrieved.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }

    @Override
    public TListSentryPrivilegesResponse list_sentry_privileges_by_role(TListSentryPrivilegesRequest request) throws TException {
        TListSentryPrivilegesResponse response = new TListSentryPrivilegesResponse();
        Set<TSentryPrivilege> privilegeSet = new HashSet<TSentryPrivilege>();
        String subject = request.getRequestorUserName();
        try {
            Set<String> roleNamesForGroups;
            Set<String> groups = this.getRequestorGroups(subject);
            Boolean admin = this.inAdminGroups(groups);
            if (!admin.booleanValue() && !(roleNamesForGroups = SentryPolicyStoreProcessor.toTrimedLower(this.sentryStore.getRoleNamesForGroups(groups))).contains(request.getRoleName().trim().toLowerCase())) {
                throw new SentryAccessDeniedException("Access denied to " + subject);
            }
            if (request.isSetAuthorizableHierarchy()) {
                TSentryAuthorizable authorizableHierarchy = request.getAuthorizableHierarchy();
                privilegeSet = this.sentryStore.getTSentryPrivileges(Sets.newHashSet((Object[])new String[]{request.getRoleName()}), authorizableHierarchy);
            } else {
                privilegeSet = this.sentryStore.getAllTSentryPrivilegesByRoleName(request.getRoleName());
            }
            response.setPrivileges(privilegeSet);
            response.setStatus(Status.OK());
        }
        catch (SentryNoSuchObjectException e) {
            response.setPrivileges(privilegeSet);
            String msg = "Privilege: " + request + " couldn't be retrieved.";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.setStatus(Status.NoSuchObject(msg, (Throwable)((Object)e)));
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }

    @Override
    public TListSentryPrivilegesForProviderResponse list_sentry_privileges_for_provider(TListSentryPrivilegesForProviderRequest request) throws TException {
        TListSentryPrivilegesForProviderResponse response = new TListSentryPrivilegesForProviderResponse();
        response.setPrivileges(new HashSet<String>());
        try {
            Set<String> privilegesForProvider = this.sentryStore.listSentryPrivilegesForProvider(request.getGroups(), request.getRoleSet(), request.getAuthorizableHierarchy());
            response.setPrivileges(privilegesForProvider);
            if ((privilegesForProvider == null || privilegesForProvider.size() == 0) && request.getAuthorizableHierarchy() != null && this.sentryStore.hasAnyServerPrivileges(request.getGroups(), request.getRoleSet(), request.getAuthorizableHierarchy().getServer())) {
                HashSet serverPriv = Sets.newHashSet((Object[])new String[]{"server=+"});
                response.setPrivileges(serverPriv);
            }
            response.setStatus(Status.OK());
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }

    private Set<String> getRequestorGroups(String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, userName);
    }

    public static Set<String> getGroupsFromUserName(Configuration conf, String userName) throws SentryUserException {
        GroupMappingService groupMappingService;
        String groupMapping = conf.get("sentry.store.group.mapping", "org.apache.sentry.provider.common.HadoopGroupMappingService");
        String authResoruce = conf.get("sentry.store.group.mapping.resource");
        try {
            Constructor<?> constrctor = Class.forName(groupMapping).getDeclaredConstructor(Configuration.class, String.class);
            constrctor.setAccessible(true);
            groupMappingService = (GroupMappingService)constrctor.newInstance(conf, authResoruce);
        }
        catch (NoSuchMethodException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (SecurityException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SentryUserException("Unable to instantiate group mapping", (Throwable)e);
        }
        return groupMappingService.getGroups(userName);
    }

    @Override
    public TDropPrivilegesResponse drop_sentry_privilege(TDropPrivilegesRequest request) throws TException {
        TDropPrivilegesResponse response = new TDropPrivilegesResponse();
        try {
            this.authorize(request.getRequestorUserName(), (Set<String>)this.adminGroups);
            this.sentryStore.dropPrivilege(request.getAuthorizable());
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }

    @Override
    public TRenamePrivilegesResponse rename_sentry_privilege(TRenamePrivilegesRequest request) throws TException {
        TRenamePrivilegesResponse response = new TRenamePrivilegesResponse();
        try {
            this.authorize(request.getRequestorUserName(), (Set<String>)this.adminGroups);
            this.sentryStore.renamePrivilege(request.getOldAuthorizable(), request.getNewAuthorizable());
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }

    @Override
    public TListSentryPrivilegesByAuthResponse list_sentry_privileges_by_authorizable(TListSentryPrivilegesByAuthRequest request) throws TException {
        TListSentryPrivilegesByAuthResponse response = new TListSentryPrivilegesByAuthResponse();
        HashMap authRoleMap = Maps.newHashMap();
        String subject = request.getRequestorUserName();
        Set<String> requestedGroups = request.getGroups();
        TSentryActiveRoleSet requestedRoleSet = request.getRoleSet();
        try {
            Set<String> memberGroups = this.getRequestorGroups(subject);
            if (!this.inAdminGroups(memberGroups)) {
                if (requestedGroups != null && !requestedGroups.isEmpty()) {
                    for (String requestedGroup : requestedGroups) {
                        if (memberGroups.contains(requestedGroup)) continue;
                        throw new SentryAccessDeniedException("Access denied to " + subject);
                    }
                } else {
                    requestedGroups = memberGroups;
                }
                if (requestedRoleSet != null && !requestedRoleSet.isAll()) {
                    Set<String> roles = SentryPolicyStoreProcessor.toTrimedLower(this.sentryStore.getRoleNamesForGroups(memberGroups));
                    for (String role : SentryPolicyStoreProcessor.toTrimedLower(requestedRoleSet.getRoles())) {
                        if (roles.contains(role)) continue;
                        throw new SentryAccessDeniedException("Access denied to " + subject);
                    }
                }
            }
            for (TSentryAuthorizable authorizable : request.getAuthorizableSet()) {
                authRoleMap.put(authorizable, this.sentryStore.listSentryPrivilegesByAuthorizable(requestedGroups, request.getRoleSet(), authorizable, this.inAdminGroups(memberGroups)));
            }
            response.setPrivilegesMapByAuth(authRoleMap);
            response.setStatus(Status.OK());
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.setStatus(Status.AccessDenied(e.getMessage(), (Throwable)((Object)e)));
        }
        catch (Exception e) {
            String msg = "Unknown error for request: " + request + ", message: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.setStatus(Status.RuntimeError(msg, e));
        }
        return response;
    }
}

