/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.security.auth.callback.CallbackHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyService;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesByAuthResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.shim.HadoopThriftAuthBridge;
import org.apache.sentry.service.thrift.shim.ShimLoader;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryPolicyServiceClient {
    private final Configuration conf;
    private final InetSocketAddress serverAddress;
    private SentryPolicyService.Client client;
    private TTransport transport;
    private int connectionTimeout;
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryPolicyServiceClient.class);
    private static final String THRIFT_EXCEPTION_MESSAGE = "Thrift exception occured ";

    public SentryPolicyServiceClient(Configuration conf) throws IOException {
        this.conf = conf;
        Preconditions.checkNotNull((Object)this.conf, (Object)"Configuration object cannot be null");
        this.serverAddress = NetUtils.createSocketAddr((String)((String)Preconditions.checkNotNull((Object)conf.get("sentry.service.client.server.rpc-address"), (Object)"Config key sentry.service.client.server.rpc-address is required")), (int)conf.getInt("sentry.service.client.server.rpc-port", 8038));
        this.connectionTimeout = conf.getInt("sentry.service.client.server.rpc-connection-timeout", 200000);
        boolean other = "other".equalsIgnoreCase(conf.get("sentry.service.security.mode", "none").trim());
        boolean kerberos = "kerberos".equalsIgnoreCase(conf.get("sentry.service.security.mode", "none").trim());
        HadoopThriftAuthBridge hadoopThriftAuthBridge = ShimLoader.getHadoopThriftAuthBridge();
        this.transport = new TSocket(this.serverAddress.getHostName(), this.serverAddress.getPort(), this.connectionTimeout);
        boolean wrapUgi = "true".equalsIgnoreCase(conf.get("sentry.service.security.use.ugi", "true"));
        if (kerberos) {
            String serverPrincipal = (String)Preconditions.checkNotNull((Object)conf.get("sentry.service.server.principal"), (Object)"sentry.service.server.principal is required");
            this.transport = hadoopThriftAuthBridge.createClient().createClientTransport(serverPrincipal, this.serverAddress.getHostName(), this.transport, wrapUgi);
        } else if (other) {
            this.transport = hadoopThriftAuthBridge.createClient().createClientTransport(null, null, this.transport, wrapUgi);
        }
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new IOException("Transport exception while opening transport: " + e.getMessage(), e);
        }
        LOGGER.debug("Successfully opened transport: " + this.transport + " to " + this.serverAddress);
        TMultiplexedProtocol protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol(this.transport), "SentryPolicyService");
        this.client = new SentryPolicyService.Client((TProtocol)protocol);
        LOGGER.debug("Successfully created client");
    }

    public synchronized void createRole(String requestorUserName, String roleName) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public void dropRole(String requestorUserName, String roleName) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, false);
    }

    public void dropRoleIfExists(String requestorUserName, String roleName) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, true);
    }

    private void dropRole(String requestorUserName, String roleName, boolean ifExists) throws SentryUserException {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        try {
            TDropSentryRoleResponse response = this.client.drop_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (ifExists && status == Status.NO_SUCH_OBJECT) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized Set<TSentryRole> listRolesByGroupName(String requestorUserName, String groupName) throws SentryUserException {
        TListSentryRolesRequest request = new TListSentryRolesRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setGroupName(groupName);
        try {
            TListSentryRolesResponse response = this.client.list_sentry_roles_by_group(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getRoles();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public Set<TSentryPrivilege> listAllPrivilegesByRoleName(String requestorUserName, String roleName) throws SentryUserException {
        return this.listPrivilegesByRoleName(requestorUserName, roleName, null);
    }

    public Set<TSentryPrivilege> listPrivilegesByRoleName(String requestorUserName, String roleName, List<? extends Authorizable> authorizable) throws SentryUserException {
        TListSentryPrivilegesRequest request = new TListSentryPrivilegesRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        if (authorizable != null) {
            TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClient.setupSentryAuthorizable(authorizable);
            request.setAuthorizableHierarchy(tSentryAuthorizable);
        }
        try {
            TListSentryPrivilegesResponse response = this.client.list_sentry_privileges_by_role(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public Set<TSentryRole> listRoles(String requestorUserName) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, null);
    }

    public Set<TSentryRole> listUserRoles(String requestorUserName) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, "*");
    }

    public TSentryPrivilege grantURIPrivilege(String requestorUserName, String roleName, String server, String uri) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, "*");
    }

    public TSentryPrivilege grantURIPrivilege(String requestorUserName, String roleName, String server, String uri, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, "*", grantOption);
    }

    public void grantServerPrivilege(String requestorUserName, String roleName, String server) throws SentryUserException {
        this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, "*");
    }

    public TSentryPrivilege grantServerPrivilege(String requestorUserName, String roleName, String server, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, "*", grantOption);
    }

    public TSentryPrivilege grantDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, action);
    }

    public TSentryPrivilege grantDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, action, grantOption);
    }

    public TSentryPrivilege grantTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, action);
    }

    public TSentryPrivilege grantTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, action, grantOption);
    }

    @VisibleForTesting
    public static TSentryAuthorizable setupSentryAuthorizable(List<? extends Authorizable> authorizable) {
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        for (Authorizable authorizable2 : authorizable) {
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Server.toString())) {
                tSentryAuthorizable.setServer(authorizable2.getName());
                continue;
            }
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.URI.toString())) {
                tSentryAuthorizable.setUri(authorizable2.getName());
                continue;
            }
            if (authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Db.toString())) {
                tSentryAuthorizable.setDb(authorizable2.getName());
                continue;
            }
            if (!authorizable2.getTypeName().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.Table.toString())) continue;
            tSentryAuthorizable.setTable(authorizable2.getName());
        }
        return tSentryAuthorizable;
    }

    private TSentryPrivilege grantPrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String action) throws SentryUserException {
        return this.grantPrivilege(requestorUserName, roleName, scope, serverName, uri, db, table, action, false);
    }

    private TSentryPrivilege grantPrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope(scope.toString());
        privilege.setServerName(serverName);
        privilege.setURI(uri);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction(action);
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(this.convertTSentryGrantOption(grantOption));
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleGrantPrivilegeResponse response = this.client.alter_sentry_role_grant_privilege(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivilege();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public void revokeURIPrivilege(String requestorUserName, String roleName, String server, String uri) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, "*");
    }

    public void revokeURIPrivilege(String requestorUserName, String roleName, String server, String uri, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.URI, server, uri, null, null, "*", grantOption);
    }

    public void revokeServerPrivilege(String requestorUserName, String roleName, String server) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, "*");
    }

    public void revokeServerPrivilege(String requestorUserName, String roleName, String server, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.SERVER, server, null, null, null, "*", grantOption);
    }

    public void revokeDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, action);
    }

    public void revokeDatabasePrivilege(String requestorUserName, String roleName, String server, String db, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.DATABASE, server, null, db, null, action, grantOption);
    }

    public void revokeTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, action);
    }

    public void revokeTablePrivilege(String requestorUserName, String roleName, String server, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, ServiceConstants.PrivilegeScope.TABLE, server, null, db, table, action, grantOption);
    }

    private void revokePrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String action) throws SentryUserException {
        this.revokePrivilege(requestorUserName, roleName, scope, serverName, uri, db, table, action, false);
    }

    private void revokePrivilege(String requestorUserName, String roleName, ServiceConstants.PrivilegeScope scope, String serverName, String uri, String db, String table, String action, Boolean grantOption) throws SentryUserException {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setProtocol_version(1);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope(scope.toString());
        privilege.setServerName(serverName);
        privilege.setURI(uri);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction(action);
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(this.convertTSentryGrantOption(grantOption));
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleRevokePrivilegeResponse response = this.client.alter_sentry_role_revoke_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private TSentryGrantOption convertTSentryGrantOption(Boolean grantOption) {
        if (grantOption == null) {
            return TSentryGrantOption.UNSET;
        }
        if (grantOption.equals(true)) {
            return TSentryGrantOption.TRUE;
        }
        if (grantOption.equals(false)) {
            return TSentryGrantOption.FALSE;
        }
        return TSentryGrantOption.FALSE;
    }

    public Set<String> listPrivilegesForProvider(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizable) throws SentryUserException {
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles());
        TListSentryPrivilegesForProviderRequest request = new TListSentryPrivilegesForProviderRequest(1, groups, thriftRoleSet);
        if (authorizable != null && authorizable.length > 0) {
            TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClient.setupSentryAuthorizable(Lists.newArrayList((Object[])authorizable));
            request.setAuthorizableHierarchy(tSentryAuthorizable);
        }
        try {
            TListSentryPrivilegesForProviderResponse response = this.client.list_sentry_privileges_for_provider(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized void grantRoleToGroup(String requestorUserName, String groupName, String roleName) throws SentryUserException {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest(1, requestorUserName, roleName, Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(groupName)}));
        try {
            TAlterSentryRoleAddGroupsResponse response = this.client.alter_sentry_role_add_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized void revokeRoleFromGroup(String requestorUserName, String groupName, String roleName) throws SentryUserException {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest(1, requestorUserName, roleName, Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(groupName)}));
        try {
            TAlterSentryRoleDeleteGroupsResponse response = this.client.alter_sentry_role_delete_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized void dropPrivileges(String requestorUserName, List<? extends Authorizable> authorizableObjects) throws SentryUserException {
        TSentryAuthorizable tSentryAuthorizable = SentryPolicyServiceClient.setupSentryAuthorizable(authorizableObjects);
        TDropPrivilegesRequest request = new TDropPrivilegesRequest(1, requestorUserName, tSentryAuthorizable);
        try {
            TDropPrivilegesResponse response = this.client.drop_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized void renamePrivileges(String requestorUserName, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables) throws SentryUserException {
        TSentryAuthorizable tOldSentryAuthorizable = SentryPolicyServiceClient.setupSentryAuthorizable(oldAuthorizables);
        TSentryAuthorizable tNewSentryAuthorizable = SentryPolicyServiceClient.setupSentryAuthorizable(newAuthorizables);
        TRenamePrivilegesRequest request = new TRenamePrivilegesRequest(1, requestorUserName, tOldSentryAuthorizable, tNewSentryAuthorizable);
        try {
            TRenamePrivilegesResponse response = this.client.rename_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public synchronized Map<TSentryAuthorizable, TSentryPrivilegeMap> listPrivilegsbyAuthorizable(String requestorUserName, Set<List<? extends Authorizable>> authorizables, Set<String> groups, ActiveRoleSet roleSet) throws SentryUserException {
        TreeSet authSet = Sets.newTreeSet();
        for (List<? extends Authorizable> authorizableHierarchy : authorizables) {
            authSet.add(SentryPolicyServiceClient.setupSentryAuthorizable(authorizableHierarchy));
        }
        TListSentryPrivilegesByAuthRequest request = new TListSentryPrivilegesByAuthRequest(1, requestorUserName, authSet);
        if (groups != null) {
            request.setGroups(groups);
        }
        if (roleSet != null) {
            request.setRoleSet(new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles()));
        }
        try {
            TListSentryPrivilegesByAuthResponse response = this.client.list_sentry_privileges_by_authorizable(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivilegesMapByAuth();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }

    public static class UgiSaslClientTransport
    extends TSaslClientTransport {
        protected UserGroupInformation ugi = null;

        public UgiSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport, boolean wrapUgi) throws IOException {
            super(mechanism, authorizationId, protocol, serverName, props, cbh, transport);
            if (wrapUgi) {
                this.ugi = UserGroupInformation.getLoginUser();
            }
        }

        public void open() throws TTransportException {
            if (this.ugi == null) {
                this.baseOpen();
            } else {
                try {
                    if (this.ugi.isFromKeytab()) {
                        this.ugi.checkTGTAndReloginFromKeytab();
                    }
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws TTransportException {
                            UgiSaslClientTransport.this.baseOpen();
                            return null;
                        }
                    });
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to open SASL transport", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new TTransportException("Interrupted while opening underlying transport", (Throwable)e);
                }
            }
        }

        private void baseOpen() throws TTransportException {
            super.open();
        }
    }
}

