/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandlerInvoker
extends NotificationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationHandlerInvoker.class);
    private final ImmutableList<NotificationHandler> handlers;

    public NotificationHandlerInvoker(Configuration conf, NotificationHandler handler) throws Exception {
        this(conf, (List<NotificationHandler>)ImmutableList.of((Object)handler));
    }

    public NotificationHandlerInvoker(Configuration conf, List<NotificationHandler> handlers) throws Exception {
        super(conf);
        this.handlers = ImmutableList.copyOf(handlers);
    }

    @Override
    public void create_sentry_role(CommitContext context, TCreateSentryRoleRequest request, TCreateSentryRoleResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.create_sentry_role(context, new TCreateSentryRoleRequest(request), new TCreateSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void drop_sentry_role(CommitContext context, TDropSentryRoleRequest request, TDropSentryRoleResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.drop_sentry_role(context, new TDropSentryRoleRequest(request), new TDropSentryRoleResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_grant_privilege(CommitContext context, TAlterSentryRoleGrantPrivilegeRequest request, TAlterSentryRoleGrantPrivilegeResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_grant_privilege(context, new TAlterSentryRoleGrantPrivilegeRequest(request), new TAlterSentryRoleGrantPrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_revoke_privilege(CommitContext context, TAlterSentryRoleRevokePrivilegeRequest request, TAlterSentryRoleRevokePrivilegeResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_revoke_privilege(context, new TAlterSentryRoleRevokePrivilegeRequest(request), new TAlterSentryRoleRevokePrivilegeResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_add_groups(CommitContext context, TAlterSentryRoleAddGroupsRequest request, TAlterSentryRoleAddGroupsResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_add_groups(context, new TAlterSentryRoleAddGroupsRequest(request), new TAlterSentryRoleAddGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }

    @Override
    public void alter_sentry_role_delete_groups(CommitContext context, TAlterSentryRoleDeleteGroupsRequest request, TAlterSentryRoleDeleteGroupsResponse response) {
        for (NotificationHandler handler : this.handlers) {
            try {
                LOGGER.debug("Calling " + handler);
                handler.alter_sentry_role_delete_groups(context, new TAlterSentryRoleDeleteGroupsRequest(request), new TAlterSentryRoleDeleteGroupsResponse(response));
            }
            catch (Exception ex) {
                LOGGER.error("Unexpected error in " + handler + ". Request: " + request + ", Response: " + response, (Throwable)ex);
            }
        }
    }
}

