/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.SentryUserException;

public class SentryStoreSchemaInfo {
    private static String SQL_FILE_EXTENSION = ".sql";
    private static String UPGRADE_FILE_PREFIX = "upgrade-";
    private static String INIT_FILE_PREFIX = "sentry-";
    private static String VERSION_UPGRADE_LIST = "upgrade.order";
    private final String dbType;
    private final String[] sentrySchemaVersions;
    private final String sentryScriptDir;
    private static final String SENTRY_VERSION = "1.4.0-mapr";

    public SentryStoreSchemaInfo(String sentryScriptDir, String dbType) throws SentryUserException {
        this.sentryScriptDir = sentryScriptDir;
        this.dbType = dbType;
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getSentryStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try {
            String currSchemaVersion;
            BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new SentryUserException("File " + upgradeListFile + "not found ", (Throwable)e);
        }
        catch (IOException e) {
            throw new SentryUserException("Error reading " + upgradeListFile, (Throwable)e);
        }
        this.sentrySchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    public String getSentrySchemaVersion() {
        return SENTRY_VERSION;
    }

    public List<String> getUpgradeScripts(String fromSchemaVer) throws SentryUserException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (SentryStoreSchemaInfo.getSentryVersion().equals(fromSchemaVer)) {
            return upgradeScriptList;
        }
        int firstScript = this.sentrySchemaVersions.length;
        for (i = 0; i < this.sentrySchemaVersions.length; ++i) {
            if (!this.sentrySchemaVersions[i].startsWith(fromSchemaVer)) continue;
            firstScript = i;
        }
        if (firstScript == this.sentrySchemaVersions.length) {
            throw new SentryUserException("Unknown version specified for upgrade " + fromSchemaVer + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.sentrySchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.sentrySchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    public String generateInitFileName(String toVersion) throws SentryUserException {
        if (toVersion == null) {
            toVersion = SentryStoreSchemaInfo.getSentryVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + this.dbType + "-" + toVersion + SQL_FILE_EXTENSION;
        if (!new File(this.getSentryStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new SentryUserException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    public String getSentryStoreScriptDir() {
        return this.sentryScriptDir;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return INIT_FILE_PREFIX + UPGRADE_FILE_PREFIX + this.dbType + "-" + fileVersion + SQL_FILE_EXTENSION;
    }

    public static String getSentryVersion() {
        return SENTRY_VERSION;
    }
}

