/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import javax.jdo.FetchGroup;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryVersion;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;

public class SentryStore {
    private static final UUID SERVER_UUID = UUID.randomUUID();
    public static String NULL_COL = "__NULL__";
    static final String DEFAULT_DATA_DIR = "sentry_policy_db";
    private long commitSequenceId = 0L;
    private final PersistenceManagerFactory pmf;
    private Configuration conf;

    public SentryStore(Configuration conf) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        this.conf = conf;
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)ServiceConstants.ServerConfig.SENTRY_STORE_DEFAULTS);
        String jdbcUrl = conf.get("sentry.store.jdbc.url", "").trim();
        Preconditions.checkArgument((!jdbcUrl.isEmpty() ? 1 : 0) != 0, (Object)"Required parameter sentry.store.jdbc.url missing");
        String user = conf.get("sentry.store.jdbc.user", "Sentry").trim();
        String pass = conf.get("sentry.store.jdbc.password", "Sentry").trim();
        String driverName = conf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("javax.jdo.option.ConnectionURL", jdbcUrl);
        prop.setProperty("javax.jdo.option.ConnectionUserName", user);
        prop.setProperty("javax.jdo.option.ConnectionPassword", pass);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", driverName);
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("sentry.javax.jdo") && !key.startsWith("sentry.datanucleus")) continue;
            key = StringUtils.removeStart((String)key, (String)"sentry.");
            prop.setProperty(key, (String)entry.getValue());
        }
        boolean checkSchemaVersion = conf.get("sentry.verify.schema.version", "true").equalsIgnoreCase("true");
        if (!checkSchemaVersion) {
            prop.setProperty("datanucleus.autoCreateSchema", "true");
            prop.setProperty("datanucleus.fixedDatastore", "false");
        }
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        this.verifySentryStoreSchema(conf, checkSchemaVersion);
    }

    private void verifySentryStoreSchema(Configuration serverConf, boolean checkVersion) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        if (!checkVersion) {
            this.setSentryVersion(SentryStoreSchemaInfo.getSentryVersion(), "Schema version set implicitly");
        } else {
            String currentVersion = this.getSentryVersion();
            if (!SentryStoreSchemaInfo.getSentryVersion().equals(currentVersion)) {
                throw new SentryAccessDeniedException("The Sentry store schema version " + currentVersion + " is different from distribution version " + SentryStoreSchemaInfo.getSentryVersion());
            }
        }
    }

    public synchronized void stop() {
        if (this.pmf != null) {
            this.pmf.close();
        }
    }

    private synchronized PersistenceManager openTransaction() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction currentTransaction = pm.currentTransaction();
        currentTransaction.begin();
        return pm;
    }

    private synchronized CommitContext commitUpdateTransaction(PersistenceManager pm) {
        this.commitTransaction(pm);
        return new CommitContext(SERVER_UUID, this.incrementGetSequenceId());
    }

    private synchronized long incrementGetSequenceId() {
        return ++this.commitSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransaction(PersistenceManager pm) {
        Transaction currentTransaction = pm.currentTransaction();
        try {
            Preconditions.checkState((boolean)currentTransaction.isActive(), (Object)"Transaction is not active");
            currentTransaction.commit();
        }
        finally {
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackTransaction(PersistenceManager pm) {
        if (pm == null || pm.isClosed()) {
            return;
        }
        Transaction currentTransaction = pm.currentTransaction();
        if (currentTransaction.isActive()) {
            try {
                currentTransaction.rollback();
            }
            finally {
                pm.close();
            }
        }
    }

    private MSentryRole getMSentryRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
        return sentryRole;
    }

    private String trimAndLower(String input) {
        return input.trim().toLowerCase();
    }

    public CommitContext createSentryRole(String roleName) throws SentryAlreadyExistsException {
        roleName = this.trimAndLower(roleName);
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            MSentryRole mSentryRole = this.getMSentryRole(pm, roleName);
            if (mSentryRole == null) {
                MSentryRole mRole = new MSentryRole(roleName, System.currentTimeMillis());
                pm.makePersistent((Object)mRole);
                CommitContext commit = this.commitUpdateTransaction(pm);
                rollbackTransaction = false;
                CommitContext commitContext = commit;
                return commitContext;
            }
            throw new SentryAlreadyExistsException("Role: " + roleName);
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleGrantPrivilege(String grantorPrincipal, String roleName, TSentryPrivilege privilege) throws SentryUserException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = this.trimAndLower(roleName);
        try {
            pm = this.openTransaction();
            this.grantOptionCheck(pm, grantorPrincipal, privilege);
            MSentryPrivilege mPrivilege = this.alterSentryRoleGrantPrivilegeCore(pm, roleName, privilege);
            if (mPrivilege != null) {
                this.convertToTSentryPrivilege(mPrivilege, privilege);
            }
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryPrivilege alterSentryRoleGrantPrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        MSentryPrivilege mPrivilege = null;
        MSentryRole mRole = this.getMSentryRole(pm, roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        if (!SentryStore.isNULL(privilege.getTableName()) || !SentryStore.isNULL(privilege.getDbName())) {
            if (privilege.getAction().equalsIgnoreCase("*")) {
                TSentryPrivilege tNotAll = new TSentryPrivilege(privilege);
                tNotAll.setAction("select");
                MSentryPrivilege mSelect = this.getMSentryPrivilege(tNotAll, pm);
                tNotAll.setAction("insert");
                MSentryPrivilege mInsert = this.getMSentryPrivilege(tNotAll, pm);
                if (mSelect != null && mRole.getPrivileges().contains(mSelect)) {
                    mSelect.removeRole(mRole);
                    pm.makePersistent((Object)mSelect);
                }
                if (mInsert != null && mRole.getPrivileges().contains(mInsert)) {
                    mInsert.removeRole(mRole);
                    pm.makePersistent((Object)mInsert);
                }
            } else {
                TSentryPrivilege tAll = new TSentryPrivilege(privilege);
                tAll.setAction("*");
                MSentryPrivilege mAll = this.getMSentryPrivilege(tAll, pm);
                if (mAll != null && mRole.getPrivileges().contains(mAll)) {
                    return null;
                }
            }
        }
        if ((mPrivilege = this.getMSentryPrivilege(privilege, pm)) == null) {
            mPrivilege = this.convertToMSentryPrivilege(privilege);
        }
        mPrivilege.appendRole(mRole);
        pm.makePersistent((Object)mRole);
        pm.makePersistent((Object)mPrivilege);
        return mPrivilege;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleRevokePrivilege(String grantorPrincipal, String roleName, TSentryPrivilege tPrivilege) throws SentryUserException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = SentryStore.safeTrimLower(roleName);
        try {
            pm = this.openTransaction();
            this.grantOptionCheck(pm, grantorPrincipal, tPrivilege);
            this.alterSentryRoleRevokePrivilegeCore(pm, roleName, tPrivilege);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void alterSentryRoleRevokePrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole mRole = (MSentryRole)query.execute((Object)roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        query = pm.newQuery(MSentryPrivilege.class);
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege, pm);
        mPrivilege = mPrivilege == null ? this.convertToMSentryPrivilege(tPrivilege) : (MSentryPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet privilegeGraph = Sets.newHashSet();
        if (mPrivilege.getGrantOption() != null) {
            privilegeGraph.add(mPrivilege);
        } else {
            MSentryPrivilege mTure = new MSentryPrivilege(mPrivilege);
            mTure.setGrantOption(true);
            privilegeGraph.add(mTure);
            MSentryPrivilege mFalse = new MSentryPrivilege(mPrivilege);
            mFalse.setGrantOption(false);
            privilegeGraph.add(mFalse);
        }
        this.populateChildren(Sets.newHashSet((Object[])new String[]{roleName}), mPrivilege, privilegeGraph);
        for (MSentryPrivilege childPriv : privilegeGraph) {
            this.revokePartial(pm, tPrivilege, mRole, childPriv);
        }
        pm.makePersistent((Object)mRole);
    }

    private void revokePartial(PersistenceManager pm, TSentryPrivilege requestedPrivToRevoke, MSentryRole mRole, MSentryPrivilege currentPrivilege) throws SentryInvalidInputException {
        MSentryPrivilege persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv == null) {
            persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
        }
        if (requestedPrivToRevoke.getAction().equalsIgnoreCase("ALL") || requestedPrivToRevoke.getAction().equalsIgnoreCase("*")) {
            persistedPriv.removeRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("select") && !currentPrivilege.getAction().equalsIgnoreCase("insert")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "insert");
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("insert") && !currentPrivilege.getAction().equalsIgnoreCase("select")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "select");
        }
    }

    private void revokeRolePartial(PersistenceManager pm, MSentryRole mRole, MSentryPrivilege currentPrivilege, MSentryPrivilege persistedPriv, String addAction) throws SentryInvalidInputException {
        persistedPriv.removeRole(mRole);
        pm.makePersistent((Object)persistedPriv);
        currentPrivilege.setAction("*");
        persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
        if (persistedPriv != null && mRole.getPrivileges().contains(persistedPriv)) {
            persistedPriv.removeRole(mRole);
            pm.makePersistent((Object)persistedPriv);
            currentPrivilege.setAction(addAction);
            persistedPriv = this.getMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege), pm);
            if (persistedPriv == null) {
                persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
                mRole.appendPrivilege(persistedPriv);
            }
            persistedPriv.appendRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    private void populateChildren(Set<String> roleNames, MSentryPrivilege priv, Set<MSentryPrivilege> children) throws SentryInvalidInputException {
        if (!SentryStore.isNULL(priv.getServerName()) || !SentryStore.isNULL(priv.getDbName())) {
            Set<MSentryPrivilege> childPrivs = this.getChildPrivileges(roleNames, priv);
            for (MSentryPrivilege childPriv : childPrivs) {
                if (!SentryStore.isNULL(childPriv.getDbName()) && !SentryStore.isNULL(childPriv.getTableName())) {
                    this.populateChildren(roleNames, childPriv, children);
                }
                children.add(childPriv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MSentryPrivilege> getChildPrivileges(Set<String> roleNames, MSentryPrivilege parent) throws SentryInvalidInputException {
        if (!SentryStore.isNULL(parent.getTableName()) || !SentryStore.isNULL(parent.getURI())) {
            return new HashSet<MSentryPrivilege>();
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
            filters.append(" && serverName == \"" + parent.getServerName() + "\"");
            if (!SentryStore.isNULL(parent.getDbName())) {
                filters.append(" && dbName == \"" + parent.getDbName() + "\"");
                filters.append(" && tableName != \"__NULL__\"");
            } else {
                filters.append(" && (dbName != \"__NULL__\" || URI != \"__NULL__\")");
            }
            query.setFilter(filters.toString());
            query.setResult("privilegeScope, serverName, dbName, tableName, URI, action, grantOption");
            HashSet<MSentryPrivilege> privileges = new HashSet<MSentryPrivilege>();
            for (Object[] privObj : (List)query.execute()) {
                MSentryPrivilege priv = new MSentryPrivilege();
                priv.setPrivilegeScope((String)privObj[0]);
                priv.setServerName((String)privObj[1]);
                priv.setDbName((String)privObj[2]);
                priv.setTableName((String)privObj[3]);
                priv.setURI((String)privObj[4]);
                priv.setAction((String)privObj[5]);
                priv.setGrantOption((Boolean)privObj[6]);
                privileges.add(priv);
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashSet<MSentryPrivilege> hashSet = privileges;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryPrivilege getMSentryPrivilege(TSentryPrivilege tPriv, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.setFilter("this.serverName == \"" + SentryStore.toNULLCol(tPriv.getServerName()) + "\" " + "&& this.dbName == \"" + SentryStore.toNULLCol(tPriv.getDbName()) + "\" " + "&& this.tableName == \"" + SentryStore.toNULLCol(tPriv.getTableName()) + "\" " + "&& this.URI == \"" + SentryStore.toNULLCol(tPriv.getURI()) + "\" " + "&& this.grantOption == grantOption " + "&& this.action == \"" + SentryStore.toNULLCol(tPriv.getAction().toLowerCase()) + "\"");
        query.declareParameters("Boolean grantOption");
        query.setUnique(true);
        Boolean grantOption = null;
        if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.TRUE)) {
            grantOption = true;
        } else if (tPriv.getGrantOption().equals((Object)TSentryGrantOption.FALSE)) {
            grantOption = false;
        }
        Object obj = query.execute((Object)grantOption);
        if (obj != null) {
            return (MSentryPrivilege)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext dropSentryRole(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + roleName);
            }
            pm.retrieve((Object)sentryRole);
            sentryRole.removePrivileges();
            pm.deletePersistent((Object)sentryRole);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleAddGroups(String grantorPrincipal, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole role = (MSentryRole)query.execute((Object)roleName);
            if (role == null) {
                throw new SentryNoSuchObjectException("Role: " + roleName);
            }
            query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) {
                    group = new MSentryGroup(groupName, System.currentTimeMillis(), Sets.newHashSet((Object[])new MSentryRole[]{role}));
                }
                group.appendRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleDeleteGroups(String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole role = (MSentryRole)query.execute((Object)roleName);
            if (role == null) {
                throw new SentryNoSuchObjectException("Role: " + roleName);
            }
            query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) continue;
                group.removeRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    MSentryRole getMSentryRoleByName(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + roleName);
            }
            pm.retrieve((Object)sentryRole);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            MSentryRole mSentryRole = sentryRole;
            return mSentryRole;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnyServerPrivileges(Set<String> roleNames, String serverName) {
        if (roleNames.size() == 0 || roleNames == null) {
            return false;
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            filters.append("&& serverName == \"" + serverName + "\"");
            query.setFilter(filters.toString());
            query.setResult("count(this)");
            Long numPrivs = (Long)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            boolean bl = numPrivs > 0L;
            return bl;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MSentryPrivilege> getMSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) {
        if (roleNames.size() == 0 || roleNames == null) {
            return new ArrayList<MSentryPrivilege>();
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            if (authHierarchy != null && authHierarchy.getServer() != null) {
                filters.append("&& serverName == \"" + authHierarchy.getServer().toLowerCase() + "\"");
                if (authHierarchy.getDb() != null) {
                    filters.append(" && ((dbName == \"" + authHierarchy.getDb().toLowerCase() + "\") || (dbName == \"__NULL__\")) && (URI == \"__NULL__\")");
                    if (authHierarchy.getTable() != null && !"*".equalsIgnoreCase(authHierarchy.getTable())) {
                        filters.append(" && ((tableName == \"" + authHierarchy.getTable().toLowerCase() + "\") || (tableName == \"__NULL__\")) && (URI == \"__NULL__\")");
                    }
                }
                if (authHierarchy.getUri() != null) {
                    filters.append(" && ((URI != \"__NULL__\") && (\"" + authHierarchy.getUri() + "\".startsWith(URI)) || (URI == \"__NULL__\")) && (dbName == \"__NULL__\")");
                }
            }
            query.setFilter(filters.toString());
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            List list = privileges;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MSentryPrivilege> getMSentryPrivilegesByAuth(Set<String> roleNames, TSentryAuthorizable authHierarchy) {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            LinkedList<MSentryPrivilege> rolesFiler;
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            StringBuilder filters = new StringBuilder();
            if (roleNames.size() == 0 || roleNames == null) {
                filters.append(" !roles.isEmpty() ");
            } else {
                query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
                rolesFiler = new LinkedList();
                for (String rName : roleNames) {
                    rolesFiler.add((MSentryPrivilege)((Object)("role.roleName == \"" + rName.trim().toLowerCase() + "\"")));
                }
                filters.append("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            }
            if (authHierarchy.getServer() != null) {
                filters.append("&& serverName == \"" + authHierarchy.getServer().toLowerCase() + "\"");
                if (authHierarchy.getDb() != null) {
                    filters.append(" && (dbName == \"" + authHierarchy.getDb().toLowerCase() + "\") && (URI == \"__NULL__\")");
                    if (authHierarchy.getTable() != null) {
                        filters.append(" && (tableName == \"" + authHierarchy.getTable().toLowerCase() + "\")");
                    } else {
                        filters.append(" && (tableName == \"__NULL__\")");
                    }
                } else if (authHierarchy.getUri() != null) {
                    filters.append(" && (URI != \"__NULL__\") && (\"" + authHierarchy.getUri() + "\".startsWith(URI)) && (dbName == \"__NULL__\")");
                } else {
                    filters.append(" && (dbName == \"__NULL__\") && (URI == \"__NULL__\")");
                }
            } else {
                rolesFiler = new ArrayList();
                return rolesFiler;
            }
            FetchGroup grp = pm.getFetchGroup(MSentryPrivilege.class, "fetchRole");
            grp.addMember("roles");
            pm.getFetchPlan().addGroup("fetchRole");
            query.setFilter(filters.toString());
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            List list = privileges;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public TSentryPrivilegeMap listSentryPrivilegesByAuthorizable(Set<String> groups, TSentryActiveRoleSet activeRoles, TSentryAuthorizable authHierarchy, boolean isAdmin) throws SentryInvalidInputException {
        TreeMap resultPrivilegeMap = Maps.newTreeMap();
        Set<Object> roles = Sets.newHashSet();
        if (groups != null && !groups.isEmpty()) {
            roles = this.getRolesToQuery(groups, new TSentryActiveRoleSet(true, null));
        }
        if (activeRoles != null && !activeRoles.isAll()) {
            for (String aRole : activeRoles.getRoles()) {
                roles.add(aRole.toLowerCase());
            }
        }
        if (isAdmin || !roles.isEmpty()) {
            List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivilegesByAuth((Set<String>)roles, authHierarchy);
            for (MSentryPrivilege priv : mSentryPrivileges) {
                for (MSentryRole role : priv.getRoles()) {
                    TSentryPrivilege tPriv = this.convertToTSentryPrivilege(priv);
                    if (resultPrivilegeMap.containsKey(role.getRoleName())) {
                        ((Set)resultPrivilegeMap.get(role.getRoleName())).add(tPriv);
                        continue;
                    }
                    TreeSet tPrivSet = Sets.newTreeSet();
                    tPrivSet.add(tPriv);
                    resultPrivilegeMap.put(role.getRoleName(), tPrivSet);
                }
            }
        }
        return new TSentryPrivilegeMap(resultPrivilegeMap);
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        MSentryRole mSentryRole = this.getMSentryRoleByName(roleName);
        return mSentryRole.getPrivileges();
    }

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByRoleName(roleName));
    }

    public Set<TSentryPrivilege> getTSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        if (authHierarchy.getServer() == null) {
            throw new SentryInvalidInputException("serverName cannot be null !!");
        }
        if (authHierarchy.getTable() != null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("dbName cannot be null when tableName is present !!");
        }
        if (authHierarchy.getUri() == null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("One of uri or dbName must not be null !!");
        }
        return this.convertToTSentryPrivileges(this.getMSentryPrivileges(roleNames, authHierarchy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MSentryRole> getMSentryRolesByGroupName(String groupName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            Set<MSentryRole> roles;
            Query query;
            pm = this.openTransaction();
            if (groupName == null) {
                query = pm.newQuery(MSentryRole.class);
                roles = new HashSet<MSentryRole>((List)query.execute());
            } else {
                query = pm.newQuery(MSentryGroup.class);
                groupName = groupName.trim();
                query.setFilter("this.groupName == t");
                query.declareParameters("java.lang.String t");
                query.setUnique(true);
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)groupName);
                if (sentryGroup == null) {
                    throw new SentryNoSuchObjectException("Group " + groupName);
                }
                pm.retrieve((Object)sentryGroup);
                roles = sentryGroup.getRoles();
            }
            for (MSentryRole role : roles) {
                pm.retrieve((Object)role);
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashSet<MSentryRole> hashSet = roles;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public Set<TSentryRole> getTSentryRolesByGroupName(Set<String> groupNames, boolean checkAllGroups) throws SentryNoSuchObjectException {
        HashSet roleSet = Sets.newHashSet();
        for (String groupName : groupNames) {
            try {
                roleSet.addAll(this.getMSentryRolesByGroupName(groupName));
            }
            catch (SentryNoSuchObjectException e) {
                if (checkAllGroups) continue;
                throw e;
            }
        }
        return this.convertToTSentryRoles(roleSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getRoleNamesForGroups(Set<String> groups) {
        HashSet<String> result = new HashSet<String>();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            for (String group : groups) {
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
                if (sentryGroup == null) continue;
                for (MSentryRole role : sentryGroup.getRoles()) {
                    result.add(role.getRoleName());
                }
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private Set<MSentryRole> getRolesForGroups(PersistenceManager pm, Set<String> groups) {
        HashSet<MSentryRole> result = new HashSet<MSentryRole>();
        Query query = pm.newQuery(MSentryGroup.class);
        query.setFilter("this.groupName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        for (String group : groups) {
            MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
            if (sentryGroup == null) continue;
            result.addAll(sentryGroup.getRoles());
        }
        return result;
    }

    public Set<String> listAllSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet) throws SentryInvalidInputException {
        return this.listSentryPrivilegesForProvider(groups, roleSet, null);
    }

    public Set<String> listSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        HashSet result = Sets.newHashSet();
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivileges(rolesToQuery, authHierarchy);
        for (MSentryPrivilege priv : mSentryPrivileges) {
            result.add(SentryStore.toAuthorizable(priv));
        }
        return result;
    }

    public boolean hasAnyServerPrivileges(Set<String> groups, TSentryActiveRoleSet roleSet, String server) {
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        return this.hasAnyServerPrivileges(rolesToQuery, server);
    }

    private Set<String> getRolesToQuery(Set<String> groups, TSentryActiveRoleSet roleSet) {
        Set<String> activeRoleNames = SentryStore.toTrimedLower(roleSet.getRoles());
        Sets.SetView roleNamesForGroups = SentryStore.toTrimedLower(this.getRoleNamesForGroups(groups));
        Sets.SetView rolesToQuery = roleSet.isAll() ? roleNamesForGroups : Sets.intersection(activeRoleNames, roleNamesForGroups);
        return rolesToQuery;
    }

    @VisibleForTesting
    static String toAuthorizable(MSentryPrivilege privilege) {
        ArrayList<String> authorizable = new ArrayList<String>(4);
        authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), (Object)privilege.getServerName(), new Object[0]));
        if (SentryStore.isNULL(privilege.getURI())) {
            if (!SentryStore.isNULL(privilege.getDbName())) {
                authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), (Object)privilege.getDbName(), new Object[0]));
                if (!SentryStore.isNULL(privilege.getTableName())) {
                    authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), (Object)privilege.getTableName(), new Object[0]));
                }
            }
        } else {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), (Object)privilege.getURI(), new Object[0]));
        }
        if (!SentryStore.isNULL(privilege.getAction()) && !privilege.getAction().equalsIgnoreCase("*")) {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)"action".toLowerCase(), (Object)privilege.getAction(), new Object[0]));
        }
        return ProviderConstants.AUTHORIZABLE_JOINER.join(authorizable);
    }

    @VisibleForTesting
    static Set<String> toTrimedLower(Set<String> s) {
        if (null == s) {
            return new HashSet<String>();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<TSentryPrivilege> convertToTSentryPrivileges(Collection<MSentryPrivilege> mSentryPrivileges) {
        HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>();
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            privileges.add(this.convertToTSentryPrivilege(mSentryPrivilege));
        }
        return privileges;
    }

    private Set<TSentryRole> convertToTSentryRoles(Set<MSentryRole> mSentryRoles) {
        HashSet<TSentryRole> roles = new HashSet<TSentryRole>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            roles.add(this.convertToTSentryRole(mSentryRole));
        }
        return roles;
    }

    private TSentryRole convertToTSentryRole(MSentryRole mSentryRole) {
        TSentryRole role = new TSentryRole();
        role.setRoleName(mSentryRole.getRoleName());
        role.setGrantorPrincipal("--");
        HashSet<TSentryGroup> sentryGroups = new HashSet<TSentryGroup>();
        for (MSentryGroup mSentryGroup : mSentryRole.getGroups()) {
            TSentryGroup group = this.convertToTSentryGroup(mSentryGroup);
            sentryGroups.add(group);
        }
        role.setGroups(sentryGroups);
        return role;
    }

    private TSentryGroup convertToTSentryGroup(MSentryGroup mSentryGroup) {
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(mSentryGroup.getGroupName());
        return group;
    }

    private TSentryPrivilege convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        this.convertToTSentryPrivilege(mSentryPrivilege, privilege);
        return privilege;
    }

    private void convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege, TSentryPrivilege privilege) {
        privilege.setCreateTime(mSentryPrivilege.getCreateTime());
        privilege.setAction(SentryStore.fromNULLCol(mSentryPrivilege.getAction()));
        privilege.setPrivilegeScope(mSentryPrivilege.getPrivilegeScope());
        privilege.setServerName(SentryStore.fromNULLCol(mSentryPrivilege.getServerName()));
        privilege.setDbName(SentryStore.fromNULLCol(mSentryPrivilege.getDbName()));
        privilege.setTableName(SentryStore.fromNULLCol(mSentryPrivilege.getTableName()));
        privilege.setURI(SentryStore.fromNULLCol(mSentryPrivilege.getURI()));
        if (mSentryPrivilege.getGrantOption() != null) {
            privilege.setGrantOption(TSentryGrantOption.valueOf(mSentryPrivilege.getGrantOption().toString().toUpperCase()));
        } else {
            privilege.setGrantOption(TSentryGrantOption.UNSET);
        }
    }

    private MSentryPrivilege convertToMSentryPrivilege(TSentryPrivilege privilege) throws SentryInvalidInputException {
        MSentryPrivilege mSentryPrivilege = new MSentryPrivilege();
        mSentryPrivilege.setServerName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getServerName())));
        mSentryPrivilege.setDbName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getDbName())));
        mSentryPrivilege.setTableName(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getTableName())));
        mSentryPrivilege.setPrivilegeScope(SentryStore.safeTrim(privilege.getPrivilegeScope()));
        mSentryPrivilege.setAction(SentryStore.toNULLCol(SentryStore.safeTrimLower(privilege.getAction())));
        mSentryPrivilege.setCreateTime(System.currentTimeMillis());
        mSentryPrivilege.setURI(SentryStore.toNULLCol(SentryStore.safeTrim(privilege.getURI())));
        if (!privilege.getGrantOption().equals((Object)TSentryGrantOption.UNSET)) {
            mSentryPrivilege.setGrantOption(Boolean.valueOf(privilege.getGrantOption().toString()));
        } else {
            mSentryPrivilege.setGrantOption(null);
        }
        return mSentryPrivilege;
    }

    private static String safeTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private static String safeTrimLower(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toLowerCase();
    }

    public String getSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion = this.getMSentryVersion();
        return mVersion.getSchemaVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSentryVersion(String newVersion, String verComment) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion;
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            mVersion = this.getMSentryVersion();
            if (newVersion.equals(mVersion.getSchemaVersion())) {
                return;
            }
        }
        catch (SentryNoSuchObjectException e) {
            mVersion = new MSentryVersion();
        }
        mVersion.setSchemaVersion(newVersion);
        mVersion.setVersionComment(verComment);
        try {
            pm = this.openTransaction();
            pm.makePersistent((Object)mVersion);
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryVersion getMSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryVersion.class);
            List mSentryVersions = (List)query.execute();
            pm.retrieveAll((Collection)mSentryVersions);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            if (mSentryVersions.isEmpty()) {
                throw new SentryNoSuchObjectException("No matching version found");
            }
            if (mSentryVersions.size() > 1) {
                throw new SentryAccessDeniedException("Metastore contains multiple versions");
            }
            MSentryVersion mSentryVersion = (MSentryVersion)mSentryVersions.get(0);
            return mSentryVersion;
        }
        catch (JDODataStoreException e) {
            if (e.getCause() instanceof MissingTableException) {
                throw new SentryAccessDeniedException("Version table not found. The sentry store is not set or corrupt ");
            }
            throw e;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void dropPrivilege(TSentryAuthorizable tAuthorizable) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : Sets.newHashSet((Object[])new String[]{"*", "select", "insert"})) {
                    tPrivilege.setAction(privilegeAction);
                    this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                }
            } else {
                this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void renamePrivilege(TSentryAuthorizable tAuthorizable, TSentryAuthorizable newTAuthorizable) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        TSentryPrivilege newPrivilege = this.toSentryPrivilege(newTAuthorizable);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : Sets.newHashSet((Object[])new String[]{"*", "select", "insert"})) {
                    tPrivilege.setAction(privilegeAction);
                    newPrivilege.setAction(privilegeAction);
                    this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                }
            } else {
                this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private boolean isMultiActionsSupported(TSentryPrivilege tPrivilege) {
        return tPrivilege.getDbName() != null;
    }

    private void renamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
    }

    private void dropPrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, null);
    }

    private void dropOrRenamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newTPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        HashSet roleSet = Sets.newHashSet();
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege, pm);
        if (mPrivilege != null) {
            roleSet.addAll(ImmutableSet.copyOf(mPrivilege.getRoles()));
        }
        for (MSentryRole role : roleSet) {
            this.alterSentryRoleRevokePrivilegeCore(pm, role.getRoleName(), tPrivilege);
            if (newTPrivilege == null) continue;
            this.alterSentryRoleGrantPrivilegeCore(pm, role.getRoleName(), newTPrivilege);
        }
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable) throws SentryInvalidInputException {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setDbName(SentryStore.fromNULLCol(tAuthorizable.getDb()));
        tSentryPrivilege.setServerName(SentryStore.fromNULLCol(tAuthorizable.getServer()));
        tSentryPrivilege.setTableName(SentryStore.fromNULLCol(tAuthorizable.getTable()));
        tSentryPrivilege.setURI(SentryStore.fromNULLCol(tAuthorizable.getUri()));
        ServiceConstants.PrivilegeScope scope = !SentryStore.isNULL(tSentryPrivilege.getTableName()) ? ServiceConstants.PrivilegeScope.TABLE : (!SentryStore.isNULL(tSentryPrivilege.getDbName()) ? ServiceConstants.PrivilegeScope.DATABASE : (!SentryStore.isNULL(tSentryPrivilege.getURI()) ? ServiceConstants.PrivilegeScope.URI : ServiceConstants.PrivilegeScope.SERVER));
        tSentryPrivilege.setPrivilegeScope(scope.name());
        tSentryPrivilege.setAction("*");
        return tSentryPrivilege;
    }

    public static String toNULLCol(String s) {
        return Strings.isNullOrEmpty((String)s) ? NULL_COL : s;
    }

    public static String fromNULLCol(String s) {
        return SentryStore.isNULL(s) ? "" : s;
    }

    public static boolean isNULL(String s) {
        return Strings.isNullOrEmpty((String)s) || s.equals(NULL_COL);
    }

    private void grantOptionCheck(PersistenceManager pm, String grantorPrincipal, TSentryPrivilege privilege) throws SentryUserException {
        MSentryPrivilege mPrivilege = this.convertToMSentryPrivilege(privilege);
        if (grantorPrincipal == null) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null");
        }
        Set<String> groups = SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, grantorPrincipal);
        if (groups == null || groups.isEmpty()) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
        Set<String> admins = this.getAdminGroups();
        boolean isAdminGroup = false;
        if (admins != null && !admins.isEmpty()) {
            for (String g : groups) {
                if (!admins.contains(g)) continue;
                isAdminGroup = true;
                break;
            }
        }
        if (!isAdminGroup) {
            boolean hasGrant = false;
            Set<MSentryRole> roles = this.getRolesForGroups(pm, groups);
            if (roles != null && !roles.isEmpty()) {
                block1: for (MSentryRole role : roles) {
                    Set<MSentryPrivilege> privilegeSet = role.getPrivileges();
                    if (privilegeSet == null || privilegeSet.isEmpty()) continue;
                    for (MSentryPrivilege p : privilegeSet) {
                        if (!p.getGrantOption().booleanValue() || !p.implies(mPrivilege)) continue;
                        hasGrant = true;
                        continue block1;
                    }
                }
            }
            if (!hasGrant) {
                throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
            }
        }
    }

    private Set<String> getAdminGroups() {
        return Sets.newHashSet((Object[])this.conf.getStrings("sentry.service.admin.group", new String[0]));
    }
}

