/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;

@javax.jdo.annotations.PersistenceCapable
public class MSentryRole
implements Detachable,
PersistenceCapable {
    private String roleName;
    private Set<MSentryPrivilege> privileges;
    private Set<MSentryGroup> groups;
    private long createTime;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public MSentryRole(String roleName, long createTime) {
        this.roleName = roleName;
        this.createTime = createTime;
        this.privileges = new HashSet<MSentryPrivilege>();
        this.groups = new HashSet<MSentryGroup>();
    }

    public long getCreateTime() {
        return MSentryRole.jdoGetcreateTime(this);
    }

    public void setCreateTime(long createTime) {
        MSentryRole.jdoSetcreateTime(this, createTime);
    }

    public String getRoleName() {
        return MSentryRole.jdoGetroleName(this);
    }

    public void setRoleName(String roleName) {
        MSentryRole.jdoSetroleName(this, roleName);
    }

    public void setPrivileges(Set<MSentryPrivilege> privileges) {
        MSentryRole.jdoSetprivileges(this, privileges);
    }

    public Set<MSentryPrivilege> getPrivileges() {
        return MSentryRole.jdoGetprivileges(this);
    }

    public void setGroups(Set<MSentryGroup> groups) {
        MSentryRole.jdoSetgroups(this, groups);
    }

    public Set<MSentryGroup> getGroups() {
        return MSentryRole.jdoGetgroups(this);
    }

    public void removePrivilege(MSentryPrivilege privilege) {
        if (MSentryRole.jdoGetprivileges(this).remove(privilege)) {
            privilege.removeRole(this);
        }
    }

    public void appendPrivileges(Set<MSentryPrivilege> privileges) {
        MSentryRole.jdoGetprivileges(this).addAll(privileges);
    }

    public void appendPrivilege(MSentryPrivilege privilege) {
        if (MSentryRole.jdoGetprivileges(this).add(privilege)) {
            privilege.appendRole(this);
        }
    }

    public void appendGroups(Set<MSentryGroup> groups) {
        MSentryRole.jdoGetgroups(this).addAll(groups);
    }

    public void appendGroup(MSentryGroup group) {
        if (MSentryRole.jdoGetgroups(this).add(group)) {
            group.appendRole(this);
        }
    }

    public void removeGroup(MSentryGroup group) {
        if (MSentryRole.jdoGetgroups(this).remove(group)) {
            group.removeRole(this);
        }
    }

    public void removePrivileges() {
        for (MSentryPrivilege privilege : ImmutableSet.copyOf((Collection)MSentryRole.jdoGetprivileges(this))) {
            privilege.removeRole(this);
        }
        Preconditions.checkState((boolean)MSentryRole.jdoGetprivileges(this).isEmpty(), (Object)("Privileges should be empty: " + MSentryRole.jdoGetprivileges(this)));
    }

    public String toString() {
        return "MSentryRole [roleName=" + MSentryRole.jdoGetroleName(this) + ", privileges=[..]" + ", groups=[...]" + ", createTime=" + MSentryRole.jdoGetcreateTime(this) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (MSentryRole.jdoGetroleName(this) == null ? 0 : MSentryRole.jdoGetroleName(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSentryRole other = (MSentryRole)obj;
        return !(MSentryRole.jdoGetroleName(this) == null ? MSentryRole.jdoGetroleName(other) != null : !MSentryRole.jdoGetroleName(this).equals(MSentryRole.jdoGetroleName(other)));
    }

    static {
        jdoFieldNames = MSentryRole.__jdoFieldNamesInit();
        jdoFieldTypes = MSentryRole.__jdoFieldTypesInit();
        jdoFieldFlags = MSentryRole.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = MSentryRole.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = MSentryRole.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)MSentryRole.___jdo$loadClass("org.apache.sentry.provider.db.service.model.MSentryRole"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new MSentryRole());
    }

    protected MSentryRole() {
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return null;
    }

    public Object jdoNewObjectIdInstance(Object key) {
        return null;
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        MSentryRole result = new MSentryRole();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        MSentryRole result = new MSentryRole();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.createTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.groups = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.privileges = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.roleName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.createTime);
                break;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.groups);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.privileges);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.roleName);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(MSentryRole obj, int index) {
        switch (index) {
            case 0: {
                this.createTime = obj.createTime;
                break;
            }
            case 1: {
                this.groups = obj.groups;
                break;
            }
            case 2: {
                this.privileges = obj.privileges;
                break;
            }
            case 3: {
                this.roleName = obj.roleName;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MSentryRole)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MSentryRole");
        }
        MSentryRole other = (MSentryRole)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"createTime", "groups", "privileges", "roleName"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{Long.TYPE, MSentryRole.___jdo$loadClass("java.util.Set"), MSentryRole.___jdo$loadClass("java.util.Set"), MSentryRole.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 10, 5, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 4;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        MSentryRole o = (MSentryRole)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static long jdoGetcreateTime(MSentryRole objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 0, objPC.createTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void jdoSetcreateTime(MSentryRole objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 0, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static Set jdoGetgroups(MSentryRole objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, objPC.groups);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1) && !((BitSet)objPC.jdoDetachedState[3]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"groups\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.groups;
    }

    private static void jdoSetgroups(MSentryRole objPC, Set val) {
        if (objPC.jdoStateManager == null) {
            objPC.groups = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, objPC.groups, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(1);
        }
    }

    private static Set jdoGetprivileges(MSentryRole objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, objPC.privileges);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"privileges\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.privileges;
    }

    private static void jdoSetprivileges(MSentryRole objPC, Set val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, objPC.privileges, (Object)val);
        } else {
            objPC.privileges = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetroleName(MSentryRole objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.roleName);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"roleName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.roleName;
    }

    private static void jdoSetroleName(MSentryRole objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.roleName, val);
        } else {
            objPC.roleName = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }
}

