/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.model;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.SentryStore;

@javax.jdo.annotations.PersistenceCapable
public class MSentryPrivilege
implements Detachable,
PersistenceCapable {
    private String privilegeScope;
    private String serverName = "";
    private String dbName = "";
    private String tableName = "";
    private String URI = "";
    private String action = "";
    private Boolean grantOption = false;
    private Set<MSentryRole> roles;
    private long createTime;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    protected Object[] jdoDetachedState;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public MSentryPrivilege() {
        this.roles = new HashSet<MSentryRole>();
    }

    public MSentryPrivilege(String privilegeName, String privilegeScope, String serverName, String dbName, String tableName, String URI2, String action, Boolean grantOption) {
        this.privilegeScope = privilegeScope;
        this.serverName = serverName;
        this.dbName = SentryStore.toNULLCol(dbName);
        this.tableName = SentryStore.toNULLCol(tableName);
        this.URI = SentryStore.toNULLCol(URI2);
        this.action = SentryStore.toNULLCol(action);
        this.grantOption = grantOption;
        this.roles = new HashSet<MSentryRole>();
    }

    public MSentryPrivilege(String privilegeName, String privilegeScope, String serverName, String dbName, String tableName, String URI2, String action) {
        this(privilegeName, privilegeScope, serverName, dbName, tableName, URI2, action, false);
    }

    public MSentryPrivilege(MSentryPrivilege other) {
        this.privilegeScope = other.privilegeScope;
        this.serverName = other.serverName;
        this.dbName = SentryStore.toNULLCol(other.dbName);
        this.tableName = SentryStore.toNULLCol(other.tableName);
        this.URI = SentryStore.toNULLCol(other.URI);
        this.action = SentryStore.toNULLCol(other.action);
        this.grantOption = other.grantOption;
        this.roles = new HashSet<MSentryRole>();
        for (MSentryRole role : other.roles) {
            this.roles.add(role);
        }
    }

    public String getServerName() {
        return MSentryPrivilege.jdoGetserverName(this);
    }

    public void setServerName(String serverName) {
        MSentryPrivilege.jdoSetserverName(this, serverName == null ? "" : serverName);
    }

    public String getDbName() {
        return MSentryPrivilege.jdoGetdbName(this);
    }

    public void setDbName(String dbName) {
        MSentryPrivilege.jdoSetdbName(this, dbName == null ? "" : dbName);
    }

    public String getTableName() {
        return MSentryPrivilege.jdoGettableName(this);
    }

    public void setTableName(String tableName) {
        MSentryPrivilege.jdoSettableName(this, tableName == null ? "" : tableName);
    }

    public String getURI() {
        return MSentryPrivilege.jdoGetURI(this);
    }

    public void setURI(String uRI) {
        MSentryPrivilege.jdoSetURI(this, uRI == null ? "" : uRI);
    }

    public String getAction() {
        return MSentryPrivilege.jdoGetaction(this);
    }

    public void setAction(String action) {
        MSentryPrivilege.jdoSetaction(this, action == null ? "" : action);
    }

    public long getCreateTime() {
        return MSentryPrivilege.jdoGetcreateTime(this);
    }

    public void setCreateTime(long createTime) {
        MSentryPrivilege.jdoSetcreateTime(this, createTime);
    }

    public String getPrivilegeScope() {
        return MSentryPrivilege.jdoGetprivilegeScope(this);
    }

    public void setPrivilegeScope(String privilegeScope) {
        MSentryPrivilege.jdoSetprivilegeScope(this, privilegeScope);
    }

    public Boolean getGrantOption() {
        return MSentryPrivilege.jdoGetgrantOption(this);
    }

    public void setGrantOption(Boolean grantOption) {
        MSentryPrivilege.jdoSetgrantOption(this, grantOption);
    }

    public void appendRole(MSentryRole role) {
        MSentryPrivilege.jdoGetroles(this).add(role);
    }

    public Set<MSentryRole> getRoles() {
        return MSentryPrivilege.jdoGetroles(this);
    }

    public void removeRole(MSentryRole role) {
        MSentryPrivilege.jdoGetroles(this).remove(role);
        role.removePrivilege(this);
    }

    public String toString() {
        return "MSentryPrivilege [privilegeScope=" + MSentryPrivilege.jdoGetprivilegeScope(this) + ", serverName=" + MSentryPrivilege.jdoGetserverName(this) + ", dbName=" + MSentryPrivilege.jdoGetdbName(this) + ", tableName=" + MSentryPrivilege.jdoGettableName(this) + ", URI=" + MSentryPrivilege.jdoGetURI(this) + ", action=" + MSentryPrivilege.jdoGetaction(this) + ", roles=[...]" + ", createTime=" + MSentryPrivilege.jdoGetcreateTime(this) + ", grantOption=" + MSentryPrivilege.jdoGetgrantOption(this) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (MSentryPrivilege.jdoGetURI(this) == null ? 0 : MSentryPrivilege.jdoGetURI(this).hashCode());
        result = 31 * result + (MSentryPrivilege.jdoGetaction(this) == null ? 0 : MSentryPrivilege.jdoGetaction(this).hashCode());
        result = 31 * result + (MSentryPrivilege.jdoGetdbName(this) == null ? 0 : MSentryPrivilege.jdoGetdbName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.jdoGetserverName(this) == null ? 0 : MSentryPrivilege.jdoGetserverName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.jdoGettableName(this) == null ? 0 : MSentryPrivilege.jdoGettableName(this).hashCode());
        result = 31 * result + (MSentryPrivilege.jdoGetgrantOption(this) == null ? 0 : MSentryPrivilege.jdoGetgrantOption(this).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MSentryPrivilege other = (MSentryPrivilege)obj;
        if (MSentryPrivilege.jdoGetURI(this) == null ? MSentryPrivilege.jdoGetURI(other) != null : !MSentryPrivilege.jdoGetURI(this).equals(MSentryPrivilege.jdoGetURI(other))) {
            return false;
        }
        if (MSentryPrivilege.jdoGetaction(this) == null ? MSentryPrivilege.jdoGetaction(other) != null : !MSentryPrivilege.jdoGetaction(this).equals(MSentryPrivilege.jdoGetaction(other))) {
            return false;
        }
        if (MSentryPrivilege.jdoGetdbName(this) == null ? MSentryPrivilege.jdoGetdbName(other) != null : !MSentryPrivilege.jdoGetdbName(this).equals(MSentryPrivilege.jdoGetdbName(other))) {
            return false;
        }
        if (MSentryPrivilege.jdoGetserverName(this) == null ? MSentryPrivilege.jdoGetserverName(other) != null : !MSentryPrivilege.jdoGetserverName(this).equals(MSentryPrivilege.jdoGetserverName(other))) {
            return false;
        }
        if (MSentryPrivilege.jdoGettableName(this) == null ? MSentryPrivilege.jdoGettableName(other) != null : !MSentryPrivilege.jdoGettableName(this).equals(MSentryPrivilege.jdoGettableName(other))) {
            return false;
        }
        return !(MSentryPrivilege.jdoGetgrantOption(this) == null ? MSentryPrivilege.jdoGetgrantOption(other) != null : !MSentryPrivilege.jdoGetgrantOption(this).equals(MSentryPrivilege.jdoGetgrantOption(other)));
    }

    public boolean implies(MSentryPrivilege other) {
        if (this.isNULL(MSentryPrivilege.jdoGetserverName(this)) || this.isNULL(MSentryPrivilege.jdoGetserverName(other))) {
            return false;
        }
        if (!MSentryPrivilege.jdoGetserverName(this).equals(MSentryPrivilege.jdoGetserverName(other))) {
            return false;
        }
        if (!this.isNULL(MSentryPrivilege.jdoGetURI(this)) && !this.isNULL(MSentryPrivilege.jdoGetURI(other))) {
            if (!PathUtils.impliesURI((String)MSentryPrivilege.jdoGetURI(this), (String)MSentryPrivilege.jdoGetURI(other))) {
                return false;
            }
        } else if (this.isNULL(MSentryPrivilege.jdoGetURI(this)) && this.isNULL(MSentryPrivilege.jdoGetURI(other))) {
            if (!this.isNULL(MSentryPrivilege.jdoGetdbName(this))) {
                if (this.isNULL(MSentryPrivilege.jdoGetdbName(other))) {
                    return false;
                }
                if (!MSentryPrivilege.jdoGetdbName(this).equals(MSentryPrivilege.jdoGetdbName(other))) {
                    return false;
                }
            }
            if (!this.isNULL(MSentryPrivilege.jdoGettableName(this))) {
                if (this.isNULL(MSentryPrivilege.jdoGettableName(other))) {
                    return false;
                }
                if (!MSentryPrivilege.jdoGettableName(this).equals(MSentryPrivilege.jdoGettableName(other))) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return MSentryPrivilege.jdoGetaction(this).equalsIgnoreCase("*") || MSentryPrivilege.jdoGetaction(this).equalsIgnoreCase(MSentryPrivilege.jdoGetaction(other)) || MSentryPrivilege.jdoGetaction(this).equalsIgnoreCase("ALL");
    }

    private boolean isNULL(String s) {
        return SentryStore.isNULL(s);
    }

    static {
        jdoFieldNames = MSentryPrivilege.__jdoFieldNamesInit();
        jdoFieldTypes = MSentryPrivilege.__jdoFieldTypesInit();
        jdoFieldFlags = MSentryPrivilege.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = MSentryPrivilege.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = MSentryPrivilege.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)MSentryPrivilege.___jdo$loadClass("org.apache.sentry.provider.db.service.model.MSentryPrivilege"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new MSentryPrivilege());
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
        if (this.jdoIsDetached() && fieldName != null) {
            String fldName = null;
            fldName = fieldName.indexOf(46) >= 0 ? fieldName.substring(fieldName.lastIndexOf(46) + 1) : fieldName;
            int i = 0;
            while (i < jdoFieldNames.length) {
                if (jdoFieldNames[i].equals(fldName)) {
                    if (((BitSet)this.jdoDetachedState[2]).get(i + jdoInheritedFieldCount)) {
                        ((BitSet)this.jdoDetachedState[3]).set(i + jdoInheritedFieldCount);
                        return;
                    }
                    throw new JDODetachedFieldAccessException("You have just attempted to access a field/property that hasn't been detached. Please detach it first before performing this operation");
                }
                ++i;
            }
        }
    }

    public Object jdoNewObjectIdInstance() {
        return null;
    }

    public Object jdoNewObjectIdInstance(Object key) {
        return null;
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    public boolean jdoIsDetached() {
        return this.jdoStateManager == null && this.jdoDetachedState != null;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        MSentryPrivilege result = new MSentryPrivilege();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        MSentryPrivilege result = new MSentryPrivilege();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.URI = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.action = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.createTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.dbName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.grantOption = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.privilegeScope = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.roles = (Set)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 7: {
                this.serverName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 8: {
                this.tableName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.URI);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.action);
                break;
            }
            case 2: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, index, this.createTime);
                break;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.dbName);
                break;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.grantOption);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.privilegeScope);
                break;
            }
            case 6: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, this.roles);
                break;
            }
            case 7: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.serverName);
                break;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.tableName);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(MSentryPrivilege obj, int index) {
        switch (index) {
            case 0: {
                this.URI = obj.URI;
                break;
            }
            case 1: {
                this.action = obj.action;
                break;
            }
            case 2: {
                this.createTime = obj.createTime;
                break;
            }
            case 3: {
                this.dbName = obj.dbName;
                break;
            }
            case 4: {
                this.grantOption = obj.grantOption;
                break;
            }
            case 5: {
                this.privilegeScope = obj.privilegeScope;
                break;
            }
            case 6: {
                this.roles = obj.roles;
                break;
            }
            case 7: {
                this.serverName = obj.serverName;
                break;
            }
            case 8: {
                this.tableName = obj.tableName;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MSentryPrivilege)) {
            throw new IllegalArgumentException("object is not an object of type org.apache.sentry.provider.db.service.model.MSentryPrivilege");
        }
        MSentryPrivilege other = (MSentryPrivilege)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"URI", "action", "createTime", "dbName", "grantOption", "privilegeScope", "roles", "serverName", "tableName"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{MSentryPrivilege.___jdo$loadClass("java.lang.String"), MSentryPrivilege.___jdo$loadClass("java.lang.String"), Long.TYPE, MSentryPrivilege.___jdo$loadClass("java.lang.String"), MSentryPrivilege.___jdo$loadClass("java.lang.Boolean"), MSentryPrivilege.___jdo$loadClass("java.lang.String"), MSentryPrivilege.___jdo$loadClass("java.util.Set"), MSentryPrivilege.___jdo$loadClass("java.lang.String"), MSentryPrivilege.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 10, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 9;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        MSentryPrivilege o = (MSentryPrivilege)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private static String jdoGetURI(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.URI);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"URI\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.URI;
    }

    private static void jdoSetURI(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.URI, val);
        } else {
            objPC.URI = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(0);
            }
        }
    }

    private static String jdoGetaction(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.action);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"action\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.action;
    }

    private static void jdoSetaction(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.action, val);
        } else {
            objPC.action = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(1);
            }
        }
    }

    private static long jdoGetcreateTime(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 2, objPC.createTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"createTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.createTime;
    }

    private static void jdoSetcreateTime(MSentryPrivilege objPC, long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 2, objPC.createTime, val);
        } else {
            objPC.createTime = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(2);
            }
        }
    }

    private static String jdoGetdbName(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.dbName);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dbName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.dbName;
    }

    private static void jdoSetdbName(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.dbName, val);
        } else {
            objPC.dbName = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(3);
            }
        }
    }

    private static Boolean jdoGetgrantOption(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.grantOption);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"grantOption\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.grantOption;
    }

    private static void jdoSetgrantOption(MSentryPrivilege objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.grantOption, (Object)val);
        } else {
            objPC.grantOption = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(4);
            }
        }
    }

    private static String jdoGetprivilegeScope(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.privilegeScope);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"privilegeScope\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.privilegeScope;
    }

    private static void jdoSetprivilegeScope(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.privilegeScope, val);
        } else {
            objPC.privilegeScope = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(5);
            }
        }
    }

    private static Set jdoGetroles(MSentryPrivilege objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return (Set)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 6, objPC.roles);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6) && !((BitSet)objPC.jdoDetachedState[3]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"roles\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.roles;
    }

    private static void jdoSetroles(MSentryPrivilege objPC, Set val) {
        if (objPC.jdoStateManager == null) {
            objPC.roles = val;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 6, objPC.roles, (Object)val);
        }
        if (objPC.jdoIsDetached()) {
            ((BitSet)objPC.jdoDetachedState[3]).set(6);
        }
    }

    private static String jdoGetserverName(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 7, objPC.serverName);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"serverName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.serverName;
    }

    private static void jdoSetserverName(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 7, objPC.serverName, val);
        } else {
            objPC.serverName = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(7);
            }
        }
    }

    private static String jdoGettableName(MSentryPrivilege objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.tableName);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"tableName\" yet this field was not detached when you detached the object. Either dont access this field, or detach it when detaching the object.");
        }
        return objPC.tableName;
    }

    private static void jdoSettableName(MSentryPrivilege objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.tableName, val);
        } else {
            objPC.tableName = val;
            if (objPC.jdoIsDetached()) {
                ((BitSet)objPC.jdoDetachedState[3]).set(8);
            }
        }
    }
}

