/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.db;

import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.policy.common.PrivilegeValidatorContext;
import org.apache.sentry.policy.db.AbstractDBPrivilegeValidator;
import org.apache.shiro.config.ConfigurationException;

public class DatabaseMustMatch
extends AbstractDBPrivilegeValidator {
    public void validate(PrivilegeValidatorContext context) throws ConfigurationException {
        String database = context.getDatabase();
        String privilege = context.getPrivilege();
        if (database != null) {
            Iterable<DBModelAuthorizable> authorizables = DatabaseMustMatch.parsePrivilege(privilege);
            for (DBModelAuthorizable authorizable : authorizables) {
                if (!(authorizable instanceof Database) || database.equalsIgnoreCase(authorizable.getName())) continue;
                String msg = "Privilege " + privilege + " references db " + authorizable.getName() + ", but is only allowed to reference " + database;
                throw new ConfigurationException(msg);
            }
        }
    }
}

