/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.core.common.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class PathUtils {
    private static final String uriRegex = "(\\w*):/.*";

    public static boolean impliesURI(URI privilegeURI, URI requestURI) throws URISyntaxException {
        if (privilegeURI.getPath() == null || requestURI.getPath() == null) {
            return false;
        }
        if (privilegeURI.getScheme() == null ? requestURI.getScheme() != null : !privilegeURI.getScheme().equals(requestURI.getScheme())) {
            return false;
        }
        String requestPath = PathUtils.ensureEndsWithSeparator(requestURI.getPath()).replace("//", "/");
        String privilegePath = PathUtils.ensureEndsWithSeparator(privilegeURI.getPath()).replace("//", "/");
        return requestURI.getPath().equals(requestURI.normalize().getPath()) && requestPath.startsWith(privilegePath) && Strings.nullToEmpty((String)privilegeURI.getAuthority()).equals(Strings.nullToEmpty((String)requestURI.getAuthority()));
    }

    private static String ensureEndsWithSeparator(String path) {
        if (path.endsWith(File.separator)) {
            return path;
        }
        return path + File.separator;
    }

    public static String parseDFSURI(String warehouseDir, String uri) throws URISyntaxException {
        return PathUtils.parseDFSURI(warehouseDir, uri, false);
    }

    public static String parseDFSURI(String warehouseDir, String uri, boolean isLocal) throws URISyntaxException {
        if (uri.matches(uriRegex)) {
            return uri;
        }
        if (uri.startsWith("file:")) {
            uri = uri.replace("file:", "file://");
        } else if (uri.startsWith("/")) {
            if (warehouseDir.startsWith("maprfs:")) {
                URI warehouse = PathUtils.toDFSURI(warehouseDir);
                uri = warehouse.getScheme() + "://" + warehouse.getAuthority() + uri;
            } else {
                uri = warehouseDir.startsWith("file:") ? "file://" + uri : (isLocal ? "file://" + uri : "maprfs:/" + uri);
            }
        }
        return uri;
    }

    public static String parseLocalURI(String uri) throws URISyntaxException {
        if (uri.startsWith("file://")) {
            return uri;
        }
        if (uri.startsWith("file:")) {
            return uri.replace("file:", "file://");
        }
        if (uri.startsWith("/")) {
            return "file://" + uri;
        }
        throw new IllegalStateException("Parse URI does not work on relative URI: " + uri);
    }

    private static URI toDFSURI(String s) throws URISyntaxException {
        URI uri = new URI(s);
        if (uri.getScheme() == null || uri.getAuthority() == null) {
            throw new IllegalArgumentException("Invalid URI " + s + ". No scheme or authority.");
        }
        return uri;
    }
}

