/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry;

import com.google.common.collect.ImmutableMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.log4j.PropertyConfigurator;
import org.apache.sentry.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryMain {
    private static final String HELP_SHORT = "h";
    private static final String HELP_LONG = "help";
    private static final String COMMAND = "command";
    private static final String HIVE_CONF = "hiveconf";
    private static final String LOG4J_CONF = "log4jConf";
    private static final ImmutableMap<String, String> COMMANDS = ImmutableMap.builder().put((Object)"service", (Object)"org.apache.sentry.service.thrift.SentryService$CommandImpl").put((Object)"config-tool", (Object)"org.apache.sentry.binding.hive.authz.SentryConfigTool$CommandImpl").put((Object)"schema-tool", (Object)"org.apache.sentry.provider.db.tools.SentrySchemaTool$CommandImpl").build();

    public static void main(String[] args) throws Exception {
        Object command;
        String commandClazz;
        String commandName;
        GnuParser parser = new GnuParser();
        Options options = new Options();
        options.addOption(HELP_SHORT, HELP_LONG, false, "Print this help text");
        options.addOption(HIVE_CONF, true, "Set hive configuration variables");
        options.addOption(null, COMMAND, true, "Command to run. Options: " + COMMANDS.keySet());
        options.addOption(null, LOG4J_CONF, true, "Location of log4j properties file");
        CommandLine commandLine = parser.parse(options, args, true);
        String log4jconf = commandLine.getOptionValue(LOG4J_CONF);
        if (log4jconf != null && log4jconf.length() > 0) {
            PropertyConfigurator.configure((String)log4jconf);
            Logger sentryLogger = LoggerFactory.getLogger(SentryMain.class);
            sentryLogger.info("Configuring log4j to use [" + log4jconf + "]");
        }
        if ((commandName = commandLine.getOptionValue(COMMAND)) == null && (commandLine.hasOption(HELP_SHORT) || commandLine.hasOption(HELP_LONG))) {
            SentryMain.printHelp(options, null);
        }
        if ((commandClazz = (String)COMMANDS.get((Object)commandName)) == null) {
            SentryMain.printHelp(options, "Unknown command " + commandName + "\n");
        }
        try {
            command = Class.forName(commandClazz.trim()).newInstance();
        }
        catch (Exception e) {
            String msg = "Could not create instance of " + commandClazz + " for command " + commandName;
            throw new IllegalStateException(msg, e);
        }
        if (!(command instanceof Command)) {
            String msg = "Command " + command.getClass().getName() + " is not an instance of " + Command.class.getName();
            throw new IllegalStateException(msg);
        }
        ((Command)command).run(commandLine.getArgs());
    }

    private static void printHelp(Options options, String msg) {
        String sentry = "sentry";
        if (msg != null) {
            sentry = msg + sentry;
        }
        new HelpFormatter().printHelp(sentry, options);
        System.exit(1);
    }
}

