/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PidUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PidUtils.class);
    private static final int RETRY_COUNT = 10;
    private static final long ONE_SECOND = 1000L;
    private static final String MAPR_HOME_PATH_DEFAULT = "/opt/mapr";
    private static final String MAPR_PID_DEFAULT = "pid";
    private static final String SENTRY_PID = "sentry.pid";
    private static final String SENTRY_THRIFT_PID = "sentry-thrift.pid";

    private PidUtils() {
    }

    public static void createSentryServicePidFile() {
        LOGGER.info("Creating sentry pid file...");
        File sentryPidFile = new File("/opt/mapr/pid/sentry.pid");
        if (sentryPidFile.exists()) {
            PidUtils.removeFile(sentryPidFile);
        }
        int sentryServicePid = PidUtils.findSentryServicePid();
        try {
            FileWriter fw = new FileWriter(sentryPidFile);
            fw.write(Integer.toString(sentryServicePid));
            fw.close();
        }
        catch (IOException e) {
            LOGGER.error("IO Exception while trying to write to: " + sentryPidFile, (Throwable)e);
        }
        LOGGER.info("Sentry pid = " + sentryServicePid);
    }

    public static void createSentryThriftServicePidFile(int port) {
        LOGGER.info("Creating sentry-thrift pid file...");
        File sentryThriftPidFile = new File("/opt/mapr/pid/sentry-thrift.pid");
        if (sentryThriftPidFile.exists()) {
            PidUtils.removeFile(sentryThriftPidFile);
        }
        int sentryThriftServicePid = PidUtils.findSentryThriftServicePid(port);
        try {
            FileWriter fw = new FileWriter(sentryThriftPidFile);
            fw.write(Integer.toString(sentryThriftServicePid));
            fw.close();
        }
        catch (IOException e) {
            LOGGER.error("IO Exception while trying to write to: " + sentryThriftPidFile, (Throwable)e);
        }
        LOGGER.info("Sentry-thrift pid = " + sentryThriftServicePid);
    }

    private static int findSentryServicePid() {
        int sentryServicePid;
        String[] commandArray = new String[]{"pgrep", "sentry"};
        int i = 0;
        do {
            LOGGER.info("Attempt " + Integer.toString(i) + ". Getting PID for sentry.");
            sentryServicePid = PidUtils.execBashReturnInt(commandArray);
            PidUtils.waitForTimeout(1000L);
        } while (sentryServicePid < 0 && ++i < 10);
        return sentryServicePid;
    }

    private static int findSentryThriftServicePid(int port) {
        int sentryThriftServicePid;
        String[] commandArray = new String[]{"/bin/bash", "-c", "netstat -nltp | grep " + Integer.toString(port) + "|awk -F \" \" '{print $7}'|awk -F \"/\" '{print $1}'"};
        int i = 0;
        do {
            LOGGER.info("Attempt " + Integer.toString(i) + ". Getting PID for sentry-thrift.");
            sentryThriftServicePid = PidUtils.execBashReturnInt(commandArray);
            PidUtils.waitForTimeout(1000L);
        } while (sentryThriftServicePid < 0 && ++i <= 10);
        return sentryThriftServicePid;
    }

    private static int execBashReturnInt(String[] cmdarray) {
        try {
            String output;
            String[] pidStrs;
            int len;
            Process process = Runtime.getRuntime().exec(cmdarray);
            BufferedInputStream is = new BufferedInputStream(process.getInputStream());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int retValue = -1;
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            try {
                retValue = process.waitFor();
                is.close();
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted Exception during command: " + Arrays.asList(cmdarray) + " execution");
                is.close();
                process.destroy();
                Thread.currentThread().interrupt();
                return -1;
            }
            process.destroy();
            if (retValue == 0 && (pidStrs = (output = baos.toString()).split("\\s+")).length > 0) {
                for (String pidStr : pidStrs) {
                    try {
                        return Integer.valueOf(pidStr);
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.error("PID is not integer: " + pidStr);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while trying to get PID.", (Throwable)e);
        }
        return -1;
    }

    private static void waitForTimeout(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    private static void removeFile(File file) {
        try {
            if (file.delete()) {
                LOGGER.info("Existing " + file.getName() + " is deleted!");
            } else {
                LOGGER.info("Delete operation is failed for file " + file.getCanonicalPath());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error deleting pid file.", (Throwable)e);
        }
    }
}

