/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class CharRDBMSMapping
extends AbstractDatastoreMapping {
    private static final ThreadLocal<FormatterInfo> formatterThreadInfo = new ThreadLocal<FormatterInfo>(){

        @Override
        protected FormatterInfo initialValue() {
            return new FormatterInfo();
        }
    };

    protected CharRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public CharRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    protected void initialize() {
        if (this.column != null) {
            Object[] validValues;
            SingleFieldMapping m;
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && this.column.getColumnMetaData().getLength() == null && (m = (SingleFieldMapping)this.getJavaTypeMapping()).getDefaultLength(0) > 0) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(m.getDefaultLength(0)));
            }
            this.column.getColumnMetaData().setJdbcType("CHAR");
            this.column.checkString();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = this.getDatastoreAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                this.column.getColumnMetaData().setLength(Integer.valueOf(1));
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN ('Y','N')");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
            SQLTypeInfo typeInfo = this.getTypeInfo();
            int maxlength = typeInfo.getPrecision();
            if ((this.column.getColumnMetaData().getLength() <= 0 || this.column.getColumnMetaData().getLength() > maxlength) && typeInfo.isAllowsPrecisionSpec()) {
                throw new NucleusUserException("String max length of " + this.column.getColumnMetaData().getLength() + " is outside the acceptable range [0, " + maxlength + "] for column \"" + this.column.getIdentifier() + "\"");
            }
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isStringBased() {
        return true;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(1, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(1);
    }

    @Override
    public void setChar(PreparedStatement ps, int param, char value) {
        try {
            if (value == '\u0000' && !this.getDatastoreAdapter().supportsOption("PersistOfUnassignedChar")) {
                value = (char)32;
                NucleusLogger.DATASTORE.warn((Object)LOCALISER_RDBMS.msg("055008"));
            }
            ps.setString(param, Character.valueOf(value).toString());
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"char", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public char getChar(ResultSet rs, int param) {
        char value;
        try {
            String str = rs.getString(param);
            if (str == null) {
                return '\u0000';
            }
            value = str.charAt(0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"char", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setString(PreparedStatement ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ps.setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ps.setNull(param, this.getTypeInfo().getDataType());
                }
            } else if (value.length() == 0) {
                if (this.storeMgr.getBooleanProperty("datanucleus.rdbms.persistEmptyStringAsNull")) {
                    ps.setString(param, null);
                } else {
                    if (this.getDatastoreAdapter().supportsOption("NullEqualsEmptyString")) {
                        value = this.getDatastoreAdapter().getSurrogateForEmptyStrings();
                    }
                    ps.setString(param, value);
                }
            } else {
                Integer colLength;
                if (this.column != null && (colLength = this.column.getColumnMetaData().getLength()) != null && colLength < value.length()) {
                    String action = this.storeMgr.getStringProperty("datanucleus.rdbms.stringLengthExceededAction");
                    if (action.equals("EXCEPTION")) {
                        throw new NucleusUserException(LOCALISER_RDBMS.msg("055007", (Object)value, (Object)this.column.getIdentifier().toString(), (Object)("" + colLength))).setFatal();
                    }
                    if (action.equals("TRUNCATE")) {
                        value = value.substring(0, colLength);
                    }
                }
                ps.setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public String getString(ResultSet rs, int param) {
        try {
            String value = rs.getString(param);
            if (value == null) {
                return value;
            }
            if (this.getDatastoreAdapter().supportsOption("NullEqualsEmptyString") && value.equals(this.getDatastoreAdapter().getSurrogateForEmptyStrings())) {
                return "";
            }
            if (this.column.getJdbcType() == 1 && this.getDatastoreAdapter().supportsOption("CharColumnsPaddedWithSpaces")) {
                int numPaddingChars = 0;
                for (int i = value.length() - 1; i >= 0 && value.charAt(i) == ' '; --i) {
                    ++numPaddingChars;
                }
                if (numPaddingChars > 0) {
                    value = value.substring(0, value.length() - numPaddingChars);
                }
            }
            return value;
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"String", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void setBoolean(PreparedStatement ps, int param, boolean value) {
        try {
            ps.setString(param, value ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(ResultSet rs, int param) {
        boolean value;
        block6: {
            try {
                String s = rs.getString(param);
                if (s == null) {
                    if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                        throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                    }
                    return false;
                }
                if (s.equals("Y")) {
                    value = true;
                    break block6;
                }
                if (s.equals("N")) {
                    value = false;
                    break block6;
                }
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        try {
            if (value == null) {
                ps.setNull(param, this.getTypeInfo().getDataType());
            } else if (value instanceof Boolean) {
                ps.setString(param, (Boolean)value != false ? "Y" : "N");
            } else if (value instanceof Time) {
                ps.setString(param, ((Time)value).toString());
            } else if (value instanceof Date) {
                ps.setString(param, ((Date)value).toString());
            } else if (value instanceof java.util.Date) {
                ps.setString(param, this.getJavaUtilDateFormat().format((java.util.Date)value));
            } else if (value instanceof Timestamp) {
                Calendar cal = this.storeMgr.getCalendarForDateTimezone();
                if (cal != null) {
                    ps.setTimestamp(param, (Timestamp)value, cal);
                } else {
                    ps.setTimestamp(param, (Timestamp)value);
                }
            } else if (value instanceof String) {
                ps.setString(param, (String)value);
            } else {
                ps.setString(param, value.toString());
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getObject(ResultSet rs, int param) {
        try {
            String s = rs.getString(param);
            if (s == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                if (s.equals("Y")) {
                    return Boolean.TRUE;
                }
                if (!s.equals("N")) throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
                return Boolean.FALSE;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_CHARACTER)) {
                return Character.valueOf(s.charAt(0));
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
                return Time.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
                return Date.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                return this.getJavaUtilDateFormat().parse(s);
            }
            if (!this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIMESTAMP)) return s;
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            return TypeConversionHelper.stringToTimestamp((String)s, (Calendar)cal);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        catch (ParseException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    public SimpleDateFormat getJavaUtilDateFormat() {
        FormatterInfo formatInfo = formatterThreadInfo.get();
        if (formatInfo.formatter == null) {
            Calendar cal = this.storeMgr.getCalendarForDateTimezone();
            formatInfo.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            if (cal != null) {
                formatInfo.formatter.setTimeZone(cal.getTimeZone());
            }
        }
        return formatInfo.formatter;
    }

    static class FormatterInfo {
        SimpleDateFormat formatter;

        FormatterInfo() {
        }
    }
}

