/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.core.model.search.SearchModelAuthorizable;
import org.apache.sentry.policy.common.PrivilegeValidator;
import org.apache.sentry.policy.search.SearchModelAuthorizables;
import org.apache.sentry.provider.file.PolicyFileConstants;
import org.apache.shiro.config.ConfigurationException;

public abstract class AbstractSearchPrivilegeValidator
implements PrivilegeValidator {
    @VisibleForTesting
    public static Iterable<SearchModelAuthorizable> parsePrivilege(String string) {
        ArrayList result = Lists.newArrayList();
        System.err.println("privilege = " + string);
        for (String section : PolicyFileConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)string)) {
            if (section.toLowerCase().startsWith(PolicyFileConstants.PRIVILEGE_PREFIX)) continue;
            SearchModelAuthorizable authorizable = SearchModelAuthorizables.from(section);
            if (authorizable == null) {
                String msg = "No authorizable found for " + section;
                throw new ConfigurationException(msg);
            }
            result.add(authorizable);
        }
        return result;
    }
}

