/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.metastore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.events.AlterTableEvent;
import org.apache.hadoop.hive.metastore.events.CreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.CreateTableEvent;
import org.apache.hadoop.hive.metastore.events.DropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.DropTableEvent;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;

public class SentryMetastorePostEventListener
extends MetaStoreEventListener {
    private final SentryServiceClientFactory sentryClientFactory = new SentryServiceClientFactory();
    private final HiveAuthzConf authzConf = HiveAuthzConf.getAuthzConf(new HiveConf());
    private final Server server = new Server(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()));

    public SentryMetastorePostEventListener(Configuration config) {
        super(config);
    }

    public void onCreateTable(CreateTableEvent tableEvent) throws MetaException {
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryTablePrivilege(tableEvent.getTable().getDbName(), tableEvent.getTable().getTableName());
    }

    public void onDropTable(DropTableEvent tableEvent) throws MetaException {
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryTablePrivilege(tableEvent.getTable().getDbName(), tableEvent.getTable().getTableName());
    }

    public void onCreateDatabase(CreateDatabaseEvent dbEvent) throws MetaException {
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_CREATE_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryDbPrivileges(dbEvent.getDatabase().getName());
    }

    public void onDropDatabase(DropDatabaseEvent dbEvent) throws MetaException {
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_DROP_WITH_POLICY_STORE)) {
            return;
        }
        this.dropSentryDbPrivileges(dbEvent.getDatabase().getName());
    }

    public void onAlterTable(AlterTableEvent tableEvent) throws MetaException {
        String oldTableName = null;
        String newTableName = null;
        if (!this.syncWithPolicyStore(HiveAuthzConf.AuthzConfVars.AUTHZ_SYNC_ALTER_WITH_POLICY_STORE)) {
            return;
        }
        if (tableEvent.getOldTable() != null) {
            oldTableName = tableEvent.getOldTable().getTableName();
        }
        if (tableEvent.getNewTable() != null) {
            newTableName = tableEvent.getNewTable().getTableName();
        }
        if (!oldTableName.equalsIgnoreCase(newTableName)) {
            this.renameSentryTablePrivilege(tableEvent.getOldTable().getDbName(), oldTableName, tableEvent.getNewTable().getDbName(), newTableName);
        }
    }

    private SentryPolicyServiceClient getSentryServiceClient() throws MetaException {
        try {
            return this.sentryClientFactory.create((Configuration)this.authzConf);
        }
        catch (Exception e) {
            throw new MetaException("Failed to connect to Sentry service " + e.getMessage());
        }
    }

    private void dropSentryDbPrivileges(String dbName) throws MetaException {
        ArrayList<Object> authorizableTable = new ArrayList<Object>();
        authorizableTable.add(this.server);
        authorizableTable.add(new Database(dbName));
        try {
            this.dropSentryPrivileges(authorizableTable);
        }
        catch (SentryUserException e) {
            throw new MetaException("Failed to remove Sentry policies for drop DB " + dbName + " Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to find local user " + e.getMessage());
        }
    }

    private void dropSentryTablePrivilege(String dbName, String tabName) throws MetaException {
        ArrayList<Object> authorizableTable = new ArrayList<Object>();
        authorizableTable.add(this.server);
        authorizableTable.add(new Database(dbName));
        authorizableTable.add(new Table(tabName));
        try {
            this.dropSentryPrivileges(authorizableTable);
        }
        catch (SentryUserException e) {
            throw new MetaException("Failed to remove Sentry policies for drop table " + dbName + "." + tabName + " Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to find local user " + e.getMessage());
        }
    }

    private void dropSentryPrivileges(List<? extends Authorizable> authorizableTable) throws SentryUserException, IOException, MetaException {
        String requestorUserName = UserGroupInformation.getCurrentUser().getShortUserName();
        SentryPolicyServiceClient sentryClient = this.getSentryServiceClient();
        sentryClient.dropPrivileges(requestorUserName, authorizableTable);
    }

    private void renameSentryTablePrivilege(String oldDbName, String oldTabName, String newDbName, String newTabName) throws MetaException {
        ArrayList<Object> oldAuthorizableTable = new ArrayList<Object>();
        oldAuthorizableTable.add(this.server);
        oldAuthorizableTable.add(new Database(oldDbName));
        oldAuthorizableTable.add(new Table(oldTabName));
        ArrayList<Object> newAuthorizableTable = new ArrayList<Object>();
        newAuthorizableTable.add(this.server);
        newAuthorizableTable.add(new Database(newDbName));
        newAuthorizableTable.add(new Table(newTabName));
        try {
            String requestorUserName = UserGroupInformation.getCurrentUser().getShortUserName();
            SentryPolicyServiceClient sentryClient = this.getSentryServiceClient();
            sentryClient.renamePrivileges(requestorUserName, oldAuthorizableTable, newAuthorizableTable);
        }
        catch (SentryUserException e) {
            throw new MetaException("Failed to remove Sentry policies for rename table " + oldDbName + "." + oldTabName + "to " + newDbName + "." + newTabName + " Error: " + e.getMessage());
        }
        catch (IOException e) {
            throw new MetaException("Failed to find local user " + e.getMessage());
        }
    }

    private boolean syncWithPolicyStore(HiveAuthzConf.AuthzConfVars syncConfVar) {
        return "true".equalsIgnoreCase(this.authzConf.get(syncConfVar.getVar(), "true"));
    }
}

