/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive.authz;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;

public class HiveAuthzPrivilegesMap {
    private static final Map<HiveOperation, HiveAuthzPrivileges> hiveAuthzStmtPrivMap = new HashMap<HiveOperation, HiveAuthzPrivileges>();
    private static final Map<HiveAuthzPrivileges.HiveExtendedOperation, HiveAuthzPrivileges> hiveAuthzExtendedPrivMap = new HashMap<HiveAuthzPrivileges.HiveExtendedOperation, HiveAuthzPrivileges>();

    public static HiveAuthzPrivileges getHiveAuthzPrivileges(HiveOperation hiveStmtOp) {
        return hiveAuthzStmtPrivMap.get(hiveStmtOp);
    }

    public static HiveAuthzPrivileges getHiveExtendedAuthzPrivileges(HiveAuthzPrivileges.HiveExtendedOperation hiveExtOp) {
        return hiveAuthzExtendedPrivMap.get((Object)hiveExtOp);
    }

    static {
        HiveAuthzPrivileges tableDDLPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges tableDDLAndUriPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges tableDDLAndOptionalUriPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges tableQueryPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        HiveAuthzPrivileges tableLoadPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DATA_LOAD).build();
        HiveAuthzPrivileges tableExportPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DATA_UNLOAD).build();
        HiveAuthzPrivileges tableMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges dbDDLPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges createTablePrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dbImportPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges createViewPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges dbMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        HiveAuthzPrivileges tableDMLPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DML).build();
        HiveAuthzPrivileges serverPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Server, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.SERVER).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build();
        HiveAuthzPrivileges anyPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEDATABASE, serverPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPDATABASE, dbDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATETABLE, createTablePrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPTABLE, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEVIEW, createViewPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPVIEW, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEINDEX, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPINDEX, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAME, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_PROPERTIES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SERDEPROPERTIES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_CLUSTER_SORT, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_FILEFORMAT, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_TOUCH, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_PROTECTMODE, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAMECOL, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ADDCOLS, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_REPLACECOLS, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ADDPARTS, tableDDLAndOptionalUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_RENAMEPART, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_DROPPARTS, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_ARCHIVE, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_UNARCHIVE, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_FILEFORMAT, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_PROTECTMODE, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_SERDEPROPERTIES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SERIALIZER, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_MERGEFILES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_SKEWED, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_SERIALIZER, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_MERGEFILES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERINDEX_PROPS, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERINDEX_REBUILD, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERVIEW_PROPERTIES, tableDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTABLE_LOCATION, tableDDLAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERPARTITION_LOCATION, tableDDLAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERTBLPART_SKEWED_LOCATION, tableDDLAndUriPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ALTERDATABASE, dbDDLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.ANALYZE_TABLE, tableQueryPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SWITCHDATABASE, anyPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATEFUNCTION, anyPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DROPFUNCTION, anyPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWCOLUMNS, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_TABLESTATUS, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_TBLPROPERTIES, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOW_CREATETABLE, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWINDEXES, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.SHOWPARTITIONS, tableMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.EXPORT, tableExportPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.IMPORT, dbImportPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.LOAD, tableLoadPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.LOCKTABLE, tableDMLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.UNLOCKTABLE, tableDMLPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.CREATETABLE_AS_SELECT, new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT)).addOutputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Db, EnumSet.of(DBModelAction.ALL)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.DATABASE).setOperationType(HiveAuthzPrivileges.HiveOperationType.DDL).build());
        hiveAuthzStmtPrivMap.put(HiveOperation.QUERY, tableQueryPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DESCDATABASE, dbMetaDataPrivilege);
        hiveAuthzStmtPrivMap.put(HiveOperation.DESCTABLE, tableMetaDataPrivilege);
        hiveAuthzExtendedPrivMap.put(HiveAuthzPrivileges.HiveExtendedOperation.TRANSFORM, serverPrivilege);
    }
}

