/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.SentryHiveConstants;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.exec.SentryGrantRevokeTask;
import org.apache.hadoop.hive.ql.exec.SentryHivePrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactory;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeRegistry;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.core.model.db.AccessConstants;

public class SentryHiveAuthorizationTaskFactoryImpl
implements HiveAuthorizationTaskFactory {
    public SentryHiveAuthorizationTaskFactoryImpl(HiveConf conf, Hive db) {
    }

    public Task<? extends Serializable> createCreateRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        String roleName = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText());
        if (AccessConstants.RESERVED_ROLE_NAMES.contains((Object)roleName.toUpperCase())) {
            String msg = "Roles cannot be one of the reserved roles: " + AccessConstants.RESERVED_ROLE_NAMES;
            throw new SemanticException(msg);
        }
        RoleDDLDesc roleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.CREATE_ROLE);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, roleDesc));
    }

    public Task<? extends Serializable> createDropRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        String roleName = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText());
        if (AccessConstants.RESERVED_ROLE_NAMES.contains((Object)roleName.toUpperCase())) {
            String msg = "Roles cannot be one of the reserved roles: " + AccessConstants.RESERVED_ROLE_NAMES;
            throw new SemanticException(msg);
        }
        RoleDDLDesc roleDesc = new RoleDDLDesc(roleName, RoleDDLDesc.RoleOperation.DROP_ROLE);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, roleDesc));
    }

    public Task<? extends Serializable> createShowRoleGrantTask(ASTNode ast, Path resultFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        ASTNode child = (ASTNode)ast.getChild(0);
        PrincipalType principalType = PrincipalType.USER;
        switch (child.getType()) {
            case 880: {
                principalType = PrincipalType.USER;
                break;
            }
            case 685: {
                principalType = PrincipalType.GROUP;
                break;
            }
            case 782: {
                principalType = PrincipalType.ROLE;
            }
        }
        if (principalType != PrincipalType.GROUP) {
            String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principalType;
            throw new SemanticException(msg);
        }
        String principalName = BaseSemanticAnalyzer.unescapeIdentifier((String)child.getChild(0).getText());
        RoleDDLDesc roleDesc = new RoleDDLDesc(principalName, principalType, RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT, null);
        roleDesc.setResFile(resultFile.toString());
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, roleDesc));
    }

    public Task<? extends Serializable> createGrantTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        SentryHivePrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            for (int i = 2; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getType() == 684) {
                    throw new SemanticException("Sentry does not allow WITH GRANT OPTION");
                }
                if (astChild.getType() != 766) continue;
                privilegeObj = this.analyzePrivilegeObject(astChild);
            }
        }
        String userName = null;
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            userName = SessionState.get().getAuthenticator().getUserName();
        }
        Preconditions.checkNotNull(privilegeObj, (Object)("privilegeObj is null for " + ast.dump()));
        if (privilegeObj.getPartSpec() != null) {
            throw new SemanticException("Sentry does not support partition level authorization");
        }
        for (PrivilegeDesc privDesc : privilegeDesc) {
            List columns = privDesc.getColumns();
            if (columns == null || columns.isEmpty()) continue;
            throw new SemanticException("Sentry users should use views to grant privileges on columns");
        }
        for (PrincipalDesc princ : principalDesc) {
            if (princ.getType() == PrincipalType.ROLE) continue;
            String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + princ.getType();
            throw new SemanticException(msg);
        }
        GrantDesc grantDesc = new GrantDesc((PrivilegeObjectDesc)privilegeObj, privilegeDesc, principalDesc, userName, PrincipalType.USER, false);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, grantDesc));
    }

    public Task<? extends Serializable> createRevokeTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        List<PrivilegeDesc> privilegeDesc = this.analyzePrivilegeListDef((ASTNode)ast.getChild(0));
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(1));
        SentryHivePrivilegeObjectDesc privilegeObj = null;
        if (ast.getChildCount() > 2) {
            ASTNode astChild = (ASTNode)ast.getChild(2);
            privilegeObj = this.analyzePrivilegeObject(astChild);
        }
        if (privilegeObj.getPartSpec() != null) {
            throw new SemanticException("Sentry does not support partition level authorization");
        }
        for (PrivilegeDesc privDesc : privilegeDesc) {
            List columns = privDesc.getColumns();
            if (columns == null || columns.isEmpty()) continue;
            throw new SemanticException("Sentry users should use views to grant privileges on columns");
        }
        for (PrincipalDesc princ : principalDesc) {
            if (princ.getType() == PrincipalType.ROLE) continue;
            String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + princ.getType();
            throw new SemanticException(msg);
        }
        RevokeDesc revokeDesc = new RevokeDesc(privilegeDesc, principalDesc, (PrivilegeObjectDesc)privilegeObj);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, revokeDesc));
    }

    public Task<? extends Serializable> createGrantRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        return this.analyzeGrantRevokeRole(true, ast, inputs, outputs);
    }

    public Task<? extends Serializable> createShowGrantTask(ASTNode ast, Path resultFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        SentryHivePrivilegeObjectDesc privHiveObj = null;
        ASTNode principal = (ASTNode)ast.getChild(0);
        PrincipalType type = PrincipalType.USER;
        switch (principal.getType()) {
            case 880: {
                type = PrincipalType.USER;
                break;
            }
            case 685: {
                type = PrincipalType.GROUP;
                break;
            }
            case 782: {
                type = PrincipalType.ROLE;
            }
        }
        if (type != PrincipalType.ROLE) {
            String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + type;
            throw new SemanticException(msg);
        }
        String principalName = BaseSemanticAnalyzer.unescapeIdentifier((String)principal.getChild(0).getText());
        PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
        if (ast.getChildCount() > 1) {
            ASTNode child = (ASTNode)ast.getChild(1);
            if (child.getToken().getType() == 767) {
                privHiveObj = this.analyzePrivilegeObject(child);
            } else {
                throw new SemanticException("Unrecognized Token: " + child.getToken().getType());
            }
        }
        ShowGrantDesc showGrant = new ShowGrantDesc(resultFile.toString(), principalDesc, privHiveObj, null);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, showGrant));
    }

    public Task<? extends Serializable> createRevokeRoleTask(ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        return this.analyzeGrantRevokeRole(false, ast, inputs, outputs);
    }

    private Task<? extends Serializable> analyzeGrantRevokeRole(boolean isGrant, ASTNode ast, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        List<PrincipalDesc> principalDesc = this.analyzePrincipalListDef((ASTNode)ast.getChild(0));
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 1; i < ast.getChildCount(); ++i) {
            roles.add(BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(i).getText()));
        }
        String roleOwnerName = "";
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            roleOwnerName = SessionState.get().getAuthenticator().getUserName();
        }
        for (PrincipalDesc princ : principalDesc) {
            if (princ.getType() == PrincipalType.GROUP) continue;
            String msg = "Sentry does not allow grant/revoke on: " + princ.getType();
            throw new SemanticException(msg);
        }
        GrantRevokeRoleDDL grantRevokeRoleDDL = new GrantRevokeRoleDDL(isGrant, roles, principalDesc, roleOwnerName, PrincipalType.USER, false);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, grantRevokeRoleDDL));
    }

    public Task<? extends Serializable> createSetRoleTask(String role, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) {
        RoleDDLDesc roleDesc = new RoleDDLDesc(role, RoleDDLDesc.RoleOperation.SET_ROLE);
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, roleDesc));
    }

    public Task<? extends Serializable> createShowCurrentRoleTask(HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, Path resultFile) throws SemanticException {
        RoleDDLDesc ddlDesc = new RoleDDLDesc(null, RoleDDLDesc.RoleOperation.SHOW_CURRENT_ROLE);
        ddlDesc.setResFile(resultFile.toString());
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, ddlDesc));
    }

    public Task<? extends Serializable> createShowRolePrincipalsTask(ASTNode astNode, Path path, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        if (astNode.getChildCount() != 1) {
            throw new AssertionError((Object)"Unexpected Tokens in SHOW ROLE PRINCIPALS");
        }
        String roleName = astNode.getChild(0).getText();
        RoleDDLDesc roleDDLDesc = new RoleDDLDesc(roleName, PrincipalType.ROLE, RoleDDLDesc.RoleOperation.SHOW_ROLE_PRINCIPALS, null);
        roleDDLDesc.setResFile(path.toString());
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, roleDDLDesc));
    }

    public Task<? extends Serializable> createShowRolesTask(ASTNode ast, Path resFile, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        RoleDDLDesc showRolesDesc = new RoleDDLDesc(null, null, RoleDDLDesc.RoleOperation.SHOW_ROLES, null);
        showRolesDesc.setResFile(resFile.toString());
        return SentryHiveAuthorizationTaskFactoryImpl.createTask(new DDLWork(inputs, outputs, showRolesDesc));
    }

    private SentryHivePrivilegeObjectDesc analyzePrivilegeObject(ASTNode ast) throws SemanticException {
        SentryHivePrivilegeObjectDesc subject = new SentryHivePrivilegeObjectDesc();
        String privilegeObject = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText());
        if (ast.getChildCount() > 1) {
            for (int i = 1; i < ast.getChildCount(); ++i) {
                ASTNode astChild = (ASTNode)ast.getChild(i);
                if (astChild.getToken().getType() == 751) {
                    throw new SemanticException("Sentry does not support partition level authorization");
                }
                if (astChild.getToken().getType() == 831) {
                    throw new SemanticException("Sentry users should use views to grant privileges on columns");
                }
                if (astChild.getToken().getType() == 879) {
                    privilegeObject = privilegeObject.replaceAll("'", "").replaceAll("\"", "");
                    subject.setUri(true);
                    continue;
                }
                if (astChild.getToken().getType() == 791) {
                    subject.setServer(true);
                    continue;
                }
                if (astChild.getToken().getType() != 855) continue;
                subject.setTable(true);
            }
        }
        subject.setObject(privilegeObject);
        return subject;
    }

    private List<PrincipalDesc> analyzePrincipalListDef(ASTNode node) {
        ArrayList<PrincipalDesc> principalList = new ArrayList<PrincipalDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            PrincipalType type = null;
            switch (child.getType()) {
                case 880: {
                    type = PrincipalType.USER;
                    break;
                }
                case 685: {
                    type = PrincipalType.GROUP;
                    break;
                }
                case 782: {
                    type = PrincipalType.ROLE;
                }
            }
            String principalName = BaseSemanticAnalyzer.unescapeIdentifier((String)child.getChild(0).getText());
            PrincipalDesc principalDesc = new PrincipalDesc(principalName, type);
            principalList.add(principalDesc);
        }
        return principalList;
    }

    private List<PrivilegeDesc> analyzePrivilegeListDef(ASTNode node) throws SemanticException {
        ArrayList<PrivilegeDesc> ret = new ArrayList<PrivilegeDesc>();
        for (int i = 0; i < node.getChildCount(); ++i) {
            ASTNode privilegeDef = (ASTNode)node.getChild(i);
            ASTNode privilegeType = (ASTNode)privilegeDef.getChild(0);
            Privilege privObj = PrivilegeRegistry.getPrivilege((int)privilegeType.getType());
            if (privObj == null) {
                throw new SemanticException("undefined privilege " + privilegeType.getType());
            }
            if (!SentryHiveConstants.ALLOWED_PRIVS.contains(privObj.getPriv())) {
                String msg = "Sentry does not support privilege: " + privObj.getPriv();
                throw new SemanticException(msg);
            }
            if (privilegeDef.getChildCount() > 1) {
                throw new SemanticException("Sentry users should use views to grant privileges on columns");
            }
            PrivilegeDesc privilegeDesc = new PrivilegeDesc(privObj, null);
            ret.add(privilegeDesc);
        }
        return ret;
    }

    private static Task<? extends Serializable> createTask(DDLWork work) {
        SentryGrantRevokeTask task = new SentryGrantRevokeTask();
        task.setId("Stage-" + Integer.toString(TaskFactory.getAndIncrementId()));
        task.setWork((Serializable)work);
        return task;
    }
}

