/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzBindingPreExecHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBindingPreExecHook.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(HookContext hookContext) throws Exception {
        HiveAuthzBinding hiveAuthzBinding = HiveAuthzBinding.get((Configuration)hookContext.getConf());
        try {
            QueryPlan qPlan = hookContext.getQueryPlan();
            if (qPlan == null || qPlan.getQueryProperties() == null) {
                return;
            }
            if (qPlan.getQueryProperties().usesScript()) {
                if (hiveAuthzBinding == null) {
                    LOG.warn("No authorization binding found, skipping the authorization for transform");
                    return;
                }
                ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<Server> serverHierarchy = new ArrayList<Server>();
                serverHierarchy.add(hiveAuthzBinding.getAuthServer());
                inputHierarchy.add(serverHierarchy);
                hiveAuthzBinding.authorize(HiveOperation.QUERY, HiveAuthzPrivilegesMap.getHiveExtendedAuthzPrivileges(HiveAuthzPrivileges.HiveExtendedOperation.TRANSFORM), new Subject(hookContext.getUserName()), inputHierarchy, outputHierarchy);
            }
        }
        finally {
            if (hiveAuthzBinding != null) {
                hiveAuthzBinding.clear((Configuration)hookContext.getConf());
            }
        }
    }
}

