/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.SentryHiveConstants;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.SentryHivePrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.GrantDesc;
import org.apache.hadoop.hive.ql.plan.GrantRevokeRoleDDL;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;
import org.apache.hadoop.hive.ql.plan.RevokeDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.SentryOnFailureHookContextImpl;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGrantRevokeTask
extends Task<DDLWork>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(SentryGrantRevokeTask.class);
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_FAILURE = 1;
    private static final Splitter DB_TBL_SPLITTER = Splitter.on((String)".").omitEmptyStrings().trimResults();
    private static final int separator = 9;
    private static final int terminator = 10;
    private static final long serialVersionUID = -7625118066790571999L;
    private SentryServiceClientFactory sentryClientFactory;
    private SentryPolicyServiceClient sentryClient;
    private HiveConf conf;
    private HiveAuthzBinding hiveAuthzBinding;
    private HiveAuthzConf authzConf;
    private String server;
    private Subject subject;
    private Set<String> subjectGroups;
    private String ipAddress;
    private HiveOperation stmtOperation;

    public SentryGrantRevokeTask() {
        this(new SentryServiceClientFactory());
    }

    public SentryGrantRevokeTask(SentryServiceClientFactory sentryClientFactory) {
        this.sentryClientFactory = sentryClientFactory;
    }

    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, this.driverContext);
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int execute(DriverContext driverContext) {
        try {
            block20: {
                try {
                    this.sentryClient = this.sentryClientFactory.create((Configuration)this.authzConf);
                }
                catch (Exception e) {
                    String msg = "Error creating Sentry client: " + e.getMessage();
                    LOG.error(msg, (Throwable)e);
                    throw new RuntimeException(msg, e);
                }
                Preconditions.checkNotNull((Object)this.hiveAuthzBinding, (Object)"HiveAuthzBinding cannot be null");
                Preconditions.checkNotNull((Object)((Object)this.authzConf), (Object)"HiveAuthConf cannot be null");
                Preconditions.checkNotNull((Object)this.subject, (Object)"Subject cannot be null");
                this.server = (String)Preconditions.checkNotNull((Object)this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar()), (Object)("Config " + HiveAuthzConf.AuthzConfVars.AUTHZ_SERVER_NAME.getVar() + " is required"));
                if (((DDLWork)this.work).getRoleDDLDesc() == null) break block20;
                int e = this.processRoleDDL(this.conf, this.console, this.sentryClient, this.subject.getName(), this.hiveAuthzBinding, ((DDLWork)this.work).getRoleDDLDesc());
                return e;
                {
                    catch (SentryAccessDeniedException e2) {
                        String csHooks = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), "").trim();
                        SentryOnFailureHookContextImpl hookContext = new SentryOnFailureHookContextImpl(this.queryPlan.getQueryString(), new HashSet<ReadEntity>(), new HashSet<WriteEntity>(), this.stmtOperation, null, null, null, null, this.subject.getName(), this.ipAddress, new AuthorizationException((Throwable)e2), (Configuration)this.conf);
                        HiveAuthzBindingHook.runFailureHook(hookContext, csHooks);
                        throw e2;
                    }
                }
            }
            if (((DDLWork)this.work).getGrantDesc() != null) {
                int e = this.processGrantDDL(this.conf, this.console, this.sentryClient, this.subject.getName(), this.server, ((DDLWork)this.work).getGrantDesc());
                return e;
            }
            if (((DDLWork)this.work).getRevokeDesc() != null) {
                int e = this.processRevokeDDL(this.conf, this.console, this.sentryClient, this.subject.getName(), this.server, ((DDLWork)this.work).getRevokeDesc());
                return e;
            }
            if (((DDLWork)this.work).getShowGrantDesc() != null) {
                int e = this.processShowGrantDDL(this.conf, this.console, this.sentryClient, this.subject.getName(), this.server, ((DDLWork)this.work).getShowGrantDesc());
                return e;
            }
            if (((DDLWork)this.work).getGrantRevokeRoleDDL() != null) {
                int e = this.processGrantRevokeRoleDDL(this.conf, this.console, this.sentryClient, this.subject.getName(), ((DDLWork)this.work).getGrantRevokeRoleDDL());
                return e;
            }
            try {
                throw new AssertionError((Object)"Unknown command passed to Sentry Grant/Revoke Task");
            }
            catch (Throwable throwable) {
                this.setException(throwable);
                String msg = "Error processing Sentry command: " + throwable.getMessage();
                LOG.error(msg, throwable);
                this.console.printError(msg);
                int n = 1;
                return n;
            }
        }
        finally {
            if (this.sentryClient != null) {
                this.sentryClient.close();
            }
        }
    }

    public void setAuthzConf(HiveAuthzConf authzConf) {
        Preconditions.checkState((this.authzConf == null ? 1 : 0) != 0, (Object)("setAuthzConf should only be called once: " + (Object)((Object)this.authzConf)));
        this.authzConf = authzConf;
    }

    public void setHiveAuthzBinding(HiveAuthzBinding hiveAuthzBinding) {
        Preconditions.checkState((this.hiveAuthzBinding == null ? 1 : 0) != 0, (Object)("setHiveAuthzBinding should only be called once: " + this.hiveAuthzBinding));
        this.hiveAuthzBinding = hiveAuthzBinding;
    }

    public void setSubject(Subject subject) {
        Preconditions.checkState((this.subject == null ? 1 : 0) != 0, (Object)("setSubject should only be called once: " + this.subject));
        this.subject = subject;
    }

    public void setSubjectGroups(Set<String> subjectGroups) {
        Preconditions.checkState((this.subjectGroups == null ? 1 : 0) != 0, (Object)("setSubjectGroups should only be called once: " + this.subjectGroups));
        this.subjectGroups = subjectGroups;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setOperation(HiveOperation stmtOperation) {
        this.stmtOperation = stmtOperation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processRoleDDL(HiveConf conf, SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, HiveAuthzBinding hiveAuthzBinding, RoleDDLDesc desc) throws SentryUserException {
        RoleDDLDesc.RoleOperation operation = desc.getOperation();
        DataOutputStream outStream = null;
        String name = desc.getName();
        try {
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.SET_ROLE)) {
                hiveAuthzBinding.setActiveRoleSet(name, sentryClient.listUserRoles(subject));
                int n = 0;
                return n;
            }
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.CREATE_ROLE)) {
                sentryClient.createRole(subject, name);
                int n = 0;
                return n;
            }
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.DROP_ROLE)) {
                sentryClient.dropRole(subject, name);
                int n = 0;
                return n;
            }
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLE_GRANT)) {
                PrincipalType principalType = desc.getPrincipalType();
                if (principalType != PrincipalType.GROUP) {
                    String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principalType;
                    throw new HiveException(msg);
                }
                Set roles = sentryClient.listRolesByGroupName(subject, desc.getName());
                this.writeToFile(SentryGrantRevokeTask.writeRoleGrantsInfo(roles), desc.getResFile());
                int n = 0;
                return n;
            }
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.SHOW_ROLES)) {
                Set roles = sentryClient.listRoles(subject);
                this.writeToFile(SentryGrantRevokeTask.writeRolesInfo(roles), desc.getResFile());
                int principalType = 0;
                return principalType;
            }
            if (operation.equals((Object)RoleDDLDesc.RoleOperation.SHOW_CURRENT_ROLE)) {
                ActiveRoleSet roleSet = hiveAuthzBinding.getActiveRoleSet();
                if (roleSet.isAll()) {
                    Set roles = sentryClient.listUserRoles(subject);
                    this.writeToFile(SentryGrantRevokeTask.writeRolesInfo(roles), desc.getResFile());
                    int n = 0;
                    return n;
                }
                Set roles = roleSet.getRoles();
                this.writeToFile(SentryGrantRevokeTask.writeActiveRolesInfo(roles), desc.getResFile());
                int n = 0;
                return n;
            }
            try {
                throw new HiveException("Unknown role operation " + operation.getOperationName());
            }
            catch (HiveException e) {
                String msg = "Error in role operation " + operation.getOperationName() + " on role name " + name + ", error message " + e.getMessage();
                LOG.warn(msg, (Throwable)e);
                console.printError(msg);
                int n = 1;
                return n;
            }
            catch (IOException e) {
                String msg = "IO Error in role operation " + e.getMessage();
                LOG.info(msg, (Throwable)e);
                console.printError(msg);
                int n = 1;
                return n;
            }
        }
        finally {
            SentryGrantRevokeTask.closeQuiet(outStream);
        }
    }

    private int processGrantDDL(HiveConf conf, SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, String server, GrantDesc desc) throws SentryUserException {
        return SentryGrantRevokeTask.processGrantRevokeDDL(console, sentryClient, subject, server, true, desc.getPrincipals(), desc.getPrivileges(), desc.getPrivilegeSubjectDesc());
    }

    private int processRevokeDDL(HiveConf conf, SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, String server, RevokeDesc desc) throws SentryUserException {
        return SentryGrantRevokeTask.processGrantRevokeDDL(console, sentryClient, subject, server, false, desc.getPrincipals(), desc.getPrivileges(), desc.getPrivilegeSubjectDesc());
    }

    private int processShowGrantDDL(HiveConf conf, SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, String server, ShowGrantDesc desc) throws SentryUserException {
        PrincipalDesc principalDesc = desc.getPrincipalDesc();
        PrivilegeObjectDesc hiveObjectDesc = desc.getHiveObj();
        String principalName = principalDesc.getName();
        try {
            Set privileges;
            if (principalDesc.getType() != PrincipalType.ROLE) {
                String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principalDesc.getType();
                throw new HiveException(msg);
            }
            if (hiveObjectDesc == null) {
                privileges = sentryClient.listPrivilegesByRoleName(subject, principalName, null);
            } else {
                SentryHivePrivilegeObjectDesc privSubjectDesc = SentryGrantRevokeTask.toSentryHivePrivilegeObjectDesc(hiveObjectDesc);
                List<Authorizable> authorizableHeirarchy = this.toAuthorizable(privSubjectDesc);
                privileges = sentryClient.listPrivilegesByRoleName(subject, principalName, authorizableHeirarchy);
            }
            this.writeToFile(SentryGrantRevokeTask.writeGrantInfo(privileges, principalName), desc.getResFile());
            return 0;
        }
        catch (IOException e) {
            String msg = "IO Error in show grant " + e.getMessage();
            LOG.info(msg, (Throwable)e);
            console.printError(msg);
            return 1;
        }
        catch (HiveException e) {
            String msg = "Error in show grant operation, error message " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            console.printError(msg);
            return 1;
        }
    }

    private List<Authorizable> toAuthorizable(SentryHivePrivilegeObjectDesc privSubjectDesc) throws HiveException {
        ArrayList<Authorizable> authorizableHeirarchy = new ArrayList<Authorizable>();
        authorizableHeirarchy.add((Authorizable)new Server(this.server));
        String dbName = null;
        if (privSubjectDesc.getTable()) {
            DatabaseTable dbTable = SentryGrantRevokeTask.parseDBTable(privSubjectDesc.getObject());
            dbName = dbTable.getDatabase();
            String tableName = dbTable.getTable();
            authorizableHeirarchy.add((Authorizable)new Table(tableName));
            authorizableHeirarchy.add((Authorizable)new Database(dbName));
        } else if (privSubjectDesc.getUri()) {
            String uriPath = privSubjectDesc.getObject();
            String warehouseDir = this.conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
            try {
                authorizableHeirarchy.add((Authorizable)new AccessURI(PathUtils.parseDFSURI((String)warehouseDir, (String)uriPath)));
            }
            catch (URISyntaxException e) {
                throw new HiveException(e.getMessage());
            }
        } else {
            dbName = privSubjectDesc.getObject();
            authorizableHeirarchy.add((Authorizable)new Database(dbName));
        }
        return authorizableHeirarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(String data, String file) throws IOException {
        Path resFile = new Path(file);
        FileSystem fs = resFile.getFileSystem((Configuration)this.conf);
        FSDataOutputStream out = fs.create(resFile);
        try {
            if (data != null && !data.isEmpty()) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write(data);
                writer.write(10);
                writer.flush();
            }
        }
        finally {
            SentryGrantRevokeTask.closeQuiet((DataOutputStream)out);
        }
    }

    private int processGrantRevokeRoleDDL(HiveConf conf, SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, GrantRevokeRoleDDL desc) throws SentryUserException {
        try {
            boolean grantRole = desc.getGrant();
            List principals = desc.getPrincipalDesc();
            List roles = desc.getRoles();
            for (PrincipalDesc principal : principals) {
                if (principal.getType() != PrincipalType.GROUP) {
                    String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + principal.getType();
                    throw new HiveException(msg);
                }
                String groupName = principal.getName();
                for (String roleName : roles) {
                    if (grantRole) {
                        sentryClient.grantRoleToGroup(subject, groupName, roleName);
                        continue;
                    }
                    sentryClient.revokeRoleFromGroup(subject, groupName, roleName);
                }
            }
        }
        catch (HiveException e) {
            String msg = "Error in grant/revoke operation, error message " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            console.printError(msg);
            return 1;
        }
        return 0;
    }

    static String writeGrantInfo(Set<TSentryPrivilege> privileges, String roleName) {
        if (privileges == null || privileges.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (TSentryPrivilege privilege : privileges) {
            if (ServiceConstants.PrivilegeScope.URI.name().equalsIgnoreCase(privilege.getPrivilegeScope())) {
                SentryGrantRevokeTask.appendNonNull(builder, privilege.getURI(), true);
            } else if (ServiceConstants.PrivilegeScope.SERVER.name().equalsIgnoreCase(privilege.getPrivilegeScope())) {
                SentryGrantRevokeTask.appendNonNull(builder, "*", true);
            } else {
                SentryGrantRevokeTask.appendNonNull(builder, privilege.getDbName(), true);
            }
            SentryGrantRevokeTask.appendNonNull(builder, privilege.getTableName());
            SentryGrantRevokeTask.appendNonNull(builder, null);
            SentryGrantRevokeTask.appendNonNull(builder, null);
            SentryGrantRevokeTask.appendNonNull(builder, roleName);
            SentryGrantRevokeTask.appendNonNull(builder, "ROLE");
            SentryGrantRevokeTask.appendNonNull(builder, privilege.getAction());
            SentryGrantRevokeTask.appendNonNull(builder, false);
            SentryGrantRevokeTask.appendNonNull(builder, privilege.getCreateTime() * 1000L);
            SentryGrantRevokeTask.appendNonNull(builder, privilege.getGrantorPrincipal());
        }
        LOG.info("builder.toString(): " + builder.toString());
        return builder.toString();
    }

    static String writeRoleGrantsInfo(Set<TSentryRole> roleGrants) {
        if (roleGrants == null || roleGrants.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (TSentryRole roleGrant : roleGrants) {
            SentryGrantRevokeTask.appendNonNull(builder, roleGrant.getRoleName(), true);
            SentryGrantRevokeTask.appendNonNull(builder, false);
            SentryGrantRevokeTask.appendNonNull(builder, null);
            SentryGrantRevokeTask.appendNonNull(builder, roleGrant.getGrantorPrincipal());
        }
        return builder.toString();
    }

    static String writeRolesInfo(Set<TSentryRole> roles) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (TSentryRole roleGrant : roles) {
            SentryGrantRevokeTask.appendNonNull(builder, roleGrant.getRoleName(), true);
        }
        return builder.toString();
    }

    static String writeActiveRolesInfo(Set<String> roles) {
        if (roles == null || roles.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String role : roles) {
            SentryGrantRevokeTask.appendNonNull(builder, role, true);
        }
        return builder.toString();
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value) {
        return SentryGrantRevokeTask.appendNonNull(builder, value, false);
    }

    static StringBuilder appendNonNull(StringBuilder builder, Object value, boolean firstColumn) {
        if (!firstColumn) {
            builder.append('\t');
        } else if (builder.length() > 0) {
            builder.append('\n');
        }
        if (value != null) {
            builder.append(value);
        }
        return builder;
    }

    private static int processGrantRevokeDDL(SessionState.LogHelper console, SentryPolicyServiceClient sentryClient, String subject, String server, boolean isGrant, List<PrincipalDesc> principals, List<PrivilegeDesc> privileges, PrivilegeObjectDesc privSubjectObjDesc) throws SentryUserException {
        if (privileges == null || privileges.size() == 0) {
            console.printError("No privilege found.");
            return 1;
        }
        String dbName = null;
        String tableName = null;
        String uriPath = null;
        String serverName = null;
        try {
            SentryHivePrivilegeObjectDesc privSubjectDesc = SentryGrantRevokeTask.toSentryHivePrivilegeObjectDesc(privSubjectObjDesc);
            if (privSubjectDesc == null) {
                throw new HiveException("Privilege subject cannot be null");
            }
            if (privSubjectDesc.getPartSpec() != null) {
                throw new HiveException("Sentry does not support partition level authorization");
            }
            String obj = privSubjectDesc.getObject();
            if (privSubjectDesc.getTable()) {
                DatabaseTable dbTable = SentryGrantRevokeTask.parseDBTable(obj);
                dbName = dbTable.getDatabase();
                tableName = dbTable.getTable();
            } else if (privSubjectDesc.getUri()) {
                uriPath = privSubjectDesc.getObject();
            } else if (privSubjectDesc.getServer()) {
                serverName = privSubjectDesc.getObject();
            } else {
                dbName = privSubjectDesc.getObject();
            }
            for (PrivilegeDesc privDesc : privileges) {
                List columns = privDesc.getColumns();
                if (columns != null && !columns.isEmpty()) {
                    throw new HiveException("Sentry users should use views to grant privileges on columns");
                }
                if (SentryHiveConstants.ALLOWED_PRIVS.contains(privDesc.getPrivilege().getPriv())) continue;
                String msg = "Sentry does not support privilege: " + privDesc.getPrivilege().getPriv();
                throw new HiveException(msg);
            }
            for (PrincipalDesc princ : principals) {
                if (princ.getType() != PrincipalType.ROLE) {
                    String msg = "Sentry does not allow privileges to be granted/revoked to/from: " + princ.getType();
                    throw new HiveException(msg);
                }
                for (PrivilegeDesc privDesc : privileges) {
                    if (isGrant) {
                        if (serverName != null) {
                            sentryClient.grantServerPrivilege(subject, princ.getName(), serverName);
                            continue;
                        }
                        if (uriPath != null) {
                            sentryClient.grantURIPrivilege(subject, princ.getName(), server, uriPath);
                            continue;
                        }
                        if (tableName == null) {
                            sentryClient.grantDatabasePrivilege(subject, princ.getName(), server, dbName, SentryGrantRevokeTask.toDbSentryAction(privDesc.getPrivilege().getPriv()));
                            continue;
                        }
                        sentryClient.grantTablePrivilege(subject, princ.getName(), server, dbName, tableName, SentryGrantRevokeTask.toSentryAction(privDesc.getPrivilege().getPriv()));
                        continue;
                    }
                    if (serverName != null) {
                        sentryClient.revokeServerPrivilege(subject, princ.getName(), serverName);
                        continue;
                    }
                    if (uriPath != null) {
                        sentryClient.revokeURIPrivilege(subject, princ.getName(), server, uriPath);
                        continue;
                    }
                    if (tableName == null) {
                        sentryClient.revokeDatabasePrivilege(subject, princ.getName(), server, dbName, SentryGrantRevokeTask.toDbSentryAction(privDesc.getPrivilege().getPriv()));
                        continue;
                    }
                    sentryClient.revokeTablePrivilege(subject, princ.getName(), server, dbName, tableName, SentryGrantRevokeTask.toSentryAction(privDesc.getPrivilege().getPriv()));
                }
            }
            return 0;
        }
        catch (HiveException e) {
            String msg = "Error in grant/revoke operation, error message " + e.getMessage();
            LOG.warn(msg, (Throwable)e);
            console.printError(msg);
            return 1;
        }
    }

    private static String toDbSentryAction(PrivilegeType privilegeType) {
        if (PrivilegeType.ALL.equals((Object)privilegeType)) {
            return "*";
        }
        if (PrivilegeType.SELECT.equals((Object)privilegeType)) {
            return "select";
        }
        if (PrivilegeType.INSERT.equals((Object)privilegeType)) {
            return "insert";
        }
        return "*";
    }

    private static SentryHivePrivilegeObjectDesc toSentryHivePrivilegeObjectDesc(PrivilegeObjectDesc privSubjectObjDesc) throws HiveException {
        if (!(privSubjectObjDesc instanceof SentryHivePrivilegeObjectDesc)) {
            throw new HiveException("Privilege subject not parsed correctly by Sentry");
        }
        return (SentryHivePrivilegeObjectDesc)privSubjectObjDesc;
    }

    private static String toSentryAction(PrivilegeType privilegeType) {
        if (PrivilegeType.ALL.equals((Object)privilegeType)) {
            return "*";
        }
        return privilegeType.name();
    }

    private static DatabaseTable parseDBTable(String obj) throws HiveException {
        String[] dbTab = (String[])Iterables.toArray((Iterable)DB_TBL_SPLITTER.split((CharSequence)obj), String.class);
        if (dbTab.length == 2) {
            return new DatabaseTable(dbTab[0], dbTab[1]);
        }
        if (dbTab.length == 1) {
            return new DatabaseTable(SessionState.get().getCurrentDatabase(), obj);
        }
        String msg = "Malformed database.table '" + obj + "'";
        throw new HiveException(msg);
    }

    private static DataOutputStream close(DataOutputStream out) throws IOException {
        if (out != null) {
            out.close();
        }
        return null;
    }

    private static void closeQuiet(DataOutputStream out) {
        try {
            SentryGrantRevokeTask.close(out);
        }
        catch (IOException e) {
            LOG.warn("Error closing output stream", (Throwable)e);
        }
    }

    public boolean requireLock() {
        return false;
    }

    public StageType getType() {
        return StageType.DDL;
    }

    public String getName() {
        return "SENTRY";
    }

    private static class DatabaseTable {
        private final String database;
        private final String table;

        public DatabaseTable(String database, String table) {
            this.database = database;
            this.table = table;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getTable() {
            return this.table;
        }
    }
}

