/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.policy.common.PrivilegeValidator;
import org.apache.sentry.policy.db.DBModelAuthorizables;
import org.apache.sentry.provider.file.PolicyFileConstants;
import org.apache.shiro.config.ConfigurationException;

public abstract class AbstractDBPrivilegeValidator
implements PrivilegeValidator {
    @VisibleForTesting
    public static Iterable<DBModelAuthorizable> parsePrivilege(String string) {
        ArrayList result = Lists.newArrayList();
        for (String section : PolicyFileConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)string)) {
            if (section.toLowerCase().startsWith(PolicyFileConstants.PRIVILEGE_PREFIX)) continue;
            DBModelAuthorizable authorizable = DBModelAuthorizables.from(section);
            if (authorizable == null) {
                String msg = "No authorizable found for " + section;
                throw new ConfigurationException(msg);
            }
            result.add(authorizable);
        }
        return result;
    }
}

