/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.solr.authz;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.binding.solr.authz.SentrySolrAuthorizationException;
import org.apache.sentry.binding.solr.conf.SolrAuthzConf;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.SearchModelAction;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.ProviderBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAuthzBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SolrAuthzBinding.class);
    private static final String[] HADOOP_CONF_FILES = new String[]{"core-site.xml", "hdfs-site.xml", "mapred-site.xml", "yarn-site.xml", "hadoop-site.xml"};
    public static final String KERBEROS_ENABLED = "solr.hdfs.security.kerberos.enabled";
    public static final String KERBEROS_KEYTAB = "solr.hdfs.security.kerberos.keytabfile";
    public static final String KERBEROS_PRINCIPAL = "solr.hdfs.security.kerberos.principal";
    private static final String kerberosEnabledProp = Strings.nullToEmpty((String)System.getProperty("solr.hdfs.security.kerberos.enabled")).trim();
    private static final String keytabProp = Strings.nullToEmpty((String)System.getProperty("solr.hdfs.security.kerberos.keytabfile")).trim();
    private static final String principalProp = Strings.nullToEmpty((String)System.getProperty("solr.hdfs.security.kerberos.principal")).trim();
    private static Boolean kerberosInit;
    private final SolrAuthzConf authzConf;
    private final AuthorizationProvider authProvider;
    private final GroupMappingService groupMapping;
    private ProviderBackend providerBackend;

    public SolrAuthzBinding(SolrAuthzConf authzConf) throws Exception {
        this.authzConf = authzConf;
        this.authProvider = this.getAuthProvider();
        this.groupMapping = this.authProvider.getGroupMapping();
    }

    private AuthorizationProvider getAuthProvider() throws Exception {
        String authProviderName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER.getVar());
        String resourceName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_RESOURCE.getVar());
        String providerBackendName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_PROVIDER_BACKEND.getVar());
        String policyEngineName = this.authzConf.get(SolrAuthzConf.AuthzConfVars.AUTHZ_POLICY_ENGINE.getVar());
        LOG.debug("Using authorization provider " + authProviderName + " with resource " + resourceName + ", policy engine " + policyEngineName + ", provider backend " + providerBackendName);
        Constructor<?> providerBackendConstructor = Class.forName(providerBackendName).getDeclaredConstructor(Configuration.class, String.class);
        providerBackendConstructor.setAccessible(true);
        if (kerberosEnabledProp.equalsIgnoreCase("true")) {
            this.initKerberos(keytabProp, principalProp);
        }
        Configuration conf = this.getConf();
        this.providerBackend = (ProviderBackend)providerBackendConstructor.newInstance(conf, resourceName);
        Constructor<?> policyConstructor = Class.forName(policyEngineName).getDeclaredConstructor(ProviderBackend.class);
        policyConstructor.setAccessible(true);
        PolicyEngine policyEngine = (PolicyEngine)policyConstructor.newInstance(this.providerBackend);
        Constructor<?> constrctor = Class.forName(authProviderName).getDeclaredConstructor(String.class, PolicyEngine.class);
        constrctor.setAccessible(true);
        return (AuthorizationProvider)constrctor.newInstance(resourceName, policyEngine);
    }

    public void authorizeCollection(Subject subject, Collection collection, Set<SearchModelAction> actions) throws SentrySolrAuthorizationException {
        boolean isDebug = LOG.isDebugEnabled();
        if (isDebug) {
            LOG.debug("Going to authorize collection " + collection.getName() + " for subject " + subject.getName());
            LOG.debug("Actions: " + actions);
        }
        if (!this.authProvider.hasAccess(subject, Arrays.asList(collection), actions, ActiveRoleSet.ALL)) {
            throw new SentrySolrAuthorizationException("User " + subject.getName() + " does not have privileges for " + collection.getName());
        }
    }

    @Deprecated
    public Set<String> getGroups(String user) {
        return this.groupMapping.getGroups(user);
    }

    public Set<String> getRoles(String user) {
        return this.providerBackend.getRoles(this.getGroups(user), ActiveRoleSet.ALL);
    }

    private Configuration getConf() throws IOException {
        Configuration conf = new Configuration();
        String confDir = System.getProperty("solr.hdfs.confdir");
        if (confDir != null && confDir.length() > 0) {
            File confDirFile = new File(confDir);
            if (!confDirFile.exists()) {
                throw new IOException("Resource directory does not exist: " + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.isDirectory()) {
                throw new IOException("Specified resource directory is not a directory" + confDirFile.getAbsolutePath());
            }
            if (!confDirFile.canRead()) {
                throw new IOException("Resource directory must be readable by the Solr process: " + confDirFile.getAbsolutePath());
            }
            for (String file : HADOOP_CONF_FILES) {
                if (!new File(confDirFile, file).exists()) continue;
                conf.addResource(new Path(confDir, file));
            }
        }
        return conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initKerberos(String keytabFile, String principal) {
        if (keytabFile == null || keytabFile.length() == 0) {
            throw new IllegalArgumentException("keytabFile required because kerberos is enabled");
        }
        if (principal == null || principal.length() == 0) {
            throw new IllegalArgumentException("principal required because kerberos is enabled");
        }
        Class<SolrAuthzBinding> clazz = SolrAuthzBinding.class;
        synchronized (SolrAuthzBinding.class) {
            if (kerberosInit == null) {
                kerberosInit = new Boolean(true);
                String authVal = this.authzConf.get("hadoop.security.authentication");
                String kerberos = "kerberos";
                if (authVal != null && !authVal.equals("kerberos")) {
                    throw new IllegalArgumentException("hadoop.security.authentication set to: " + authVal + ", not kerberos, but attempting to " + " connect to HDFS via kerberos");
                }
                Configuration ugiConf = new Configuration((Configuration)this.authzConf);
                ugiConf.set("hadoop.security.authentication", "kerberos");
                UserGroupInformation.setConfiguration((Configuration)ugiConf);
                LOG.info("Attempting to acquire kerberos ticket with keytab: {}, principal: {} ", (Object)keytabFile, (Object)principal);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabFile);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                LOG.info("Got Kerberos ticket");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

