/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.binding.hive.SentryPolicyFileFormatter;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.file.SimpleFileProviderBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryIniPolicyFileFormatter
implements SentryPolicyFileFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryIniPolicyFileFormatter.class);
    private static final String NL = System.getProperty("line.separator", "\n");

    @Override
    public void write(String resourcePath, Map<String, Map<String, Set<String>>> sentryMappingData) throws Exception {
        File destFile = new File(resourcePath);
        if (destFile.exists() && !destFile.delete()) {
            throw new IllegalStateException("Unable to delete " + destFile);
        }
        String contents = Joiner.on((String)NL).join((Object)this.generateSection("groups", sentryMappingData.get("groups")), (Object)this.generateSection("roles", sentryMappingData.get("roles")), new Object[]{""});
        LOGGER.info("Writing policy file to " + destFile + ":\n" + contents);
        Files.write((CharSequence)contents, (File)destFile, (Charset)Charsets.UTF_8);
    }

    @Override
    public Map<String, Map<String, Set<String>>> parse(String resourcePath, Configuration conf) throws Exception {
        HashMap resultMap = Maps.newHashMap();
        SimpleFileProviderBackend policyFileBackend = new SimpleFileProviderBackend(conf, resourcePath);
        ProviderBackendContext context = new ProviderBackendContext();
        context.setAllowPerDatabase(true);
        policyFileBackend.initialize(context);
        Table groupRolePrivilegeTable = policyFileBackend.getGroupRolePrivilegeTable();
        HashMap groupRolesMap = Maps.newHashMap();
        HashMap rolePrivilegesMap = Maps.newHashMap();
        for (String groupName : groupRolePrivilegeTable.rowKeySet()) {
            for (String roleName : groupRolePrivilegeTable.columnKeySet()) {
                Set privileges;
                Set tempRoles = (Set)groupRolesMap.get(groupName);
                if (tempRoles == null) {
                    tempRoles = Sets.newHashSet();
                }
                if ((privileges = (Set)groupRolePrivilegeTable.get((Object)groupName, (Object)roleName)) == null) continue;
                tempRoles.add(roleName);
                groupRolesMap.put(groupName, tempRoles);
                rolePrivilegesMap.put(roleName, privileges);
            }
        }
        resultMap.put("groups", groupRolesMap);
        resultMap.put("roles", rolePrivilegesMap);
        return resultMap;
    }

    private String generateSection(String name, Map<String, Set<String>> mappingData) {
        if (mappingData.isEmpty()) {
            return "";
        }
        ArrayList lines = Lists.newArrayList();
        lines.add("[" + name + "]");
        for (String key : mappingData.keySet()) {
            lines.add(ProviderConstants.KV_JOINER.join((Object)key, (Object)ProviderConstants.ROLE_JOINER.join((Iterable)mappingData.get(key)), new Object[0]));
        }
        return Joiner.on((String)NL).join((Iterable)lines);
    }
}

