/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Joiner;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessController;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationValidator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerImpl;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContext;
import org.apache.sentry.binding.hive.HiveAuthzBindingHook;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;

public class HiveAuthzBindingSessionHook
implements HiveSessionHook {
    public static final String SEMANTIC_HOOK = "org.apache.sentry.binding.hive.HiveAuthzBindingHook";
    public static final String FILTER_HOOK = "org.apache.sentry.binding.hive.HiveAuthzBindingHook";
    public static final String SCRATCH_DIR_PERMISSIONS = "700";
    public static final String ACCESS_RESTRICT_LIST = Joiner.on((String)",").join((Object)HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, (Object)HiveConf.ConfVars.PREEXECHOOKS.varname, new Object[]{HiveConf.ConfVars.SCRATCHDIR.varname, HiveConf.ConfVars.LOCALSCRATCHDIR.varname, HiveConf.ConfVars.METASTOREURIS.varname, HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, HiveConf.ConfVars.HADOOPBIN.varname, HiveConf.ConfVars.HIVESESSIONID.varname, HiveConf.ConfVars.HIVEAUXJARS.varname, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING.varname, HiveConf.ConfVars.SCRATCHDIRPERMISSION.varname, HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.varname, HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY.varname, HiveConf.ConfVars.HIVERELOADABLEJARS.varname, "hive.access.conf.url", "hive.sentry.conf.url", "hive.access.subject.name", "hive.sentry.subject.name", "hive.sentry.active.role.set"});

    public void run(HiveSessionHookContext sessionHookContext) throws HiveSQLException {
        HiveConf sessionConf = sessionHookContext.getSessionConf();
        this.appendConfVar(sessionConf, HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, "org.apache.sentry.binding.hive.HiveAuthzBindingHook");
        HiveAuthzConf authzConf = HiveAuthzBindingHook.loadAuthzConf(sessionConf);
        String commandWhitelist = authzConf.get("hive.sentry.security.command.whitelist", "set,reset,reload");
        sessionConf.setVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST, commandWhitelist);
        sessionConf.setVar(HiveConf.ConfVars.SCRATCHDIRPERMISSION, SCRATCH_DIR_PERMISSIONS);
        sessionConf.setBoolVar(HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY, true);
        sessionConf.set("hive.access.subject.name", sessionHookContext.getSessionUser());
        sessionConf.set("hive.sentry.subject.name", sessionHookContext.getSessionUser());
        sessionConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.sentry.binding.hive.HiveAuthzBindingSessionHook$SentryHiveAuthorizerFactory");
        this.appendConfVar(sessionConf, "mapreduce.job.acl-view-job", sessionHookContext.getSessionUser());
        this.appendConfVar(sessionConf, "mapreduce.job.acl-modify-job", sessionHookContext.getSessionUser());
        sessionConf.addToRestrictList(ACCESS_RESTRICT_LIST);
    }

    private void appendConfVar(HiveConf sessionConf, String confVar, String sentryConfVal) {
        String currentValue = sessionConf.get(confVar, "").trim();
        currentValue = currentValue.isEmpty() ? sentryConfVal : sentryConfVal + "," + currentValue;
        sessionConf.set(confVar, currentValue);
    }

    public static class SentryHiveAuthorizerImpl
    extends HiveAuthorizerImpl {
        public SentryHiveAuthorizerImpl(HiveAccessController accessController, HiveAuthorizationValidator authValidator) {
            super(accessController, authValidator);
        }

        public void applyAuthorizationConfigPolicy(HiveConf conf) {
        }
    }

    public static class SentryHiveAuthorizerFactory
    implements HiveAuthorizerFactory {
        public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext ctx) throws HiveAuthzPluginException {
            return new SentryHiveAuthorizerImpl(null, null);
        }
    }
}

