/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.SentryFilterDDLTask;
import org.apache.hadoop.hive.ql.exec.SentryGrantRevokeTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.SentryOnFailureHook;
import org.apache.sentry.binding.hive.SentryOnFailureHookContext;
import org.apache.sentry.binding.hive.SentryOnFailureHookContextImpl;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.Column;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzBindingHook
extends AbstractSemanticAnalyzerHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBindingHook.class);
    private final HiveAuthzBinding hiveAuthzBinding;
    private final HiveAuthzConf authzConf;
    private Database currDB = Database.ALL;
    private Table currTab;
    private AccessURI udfURI;
    private AccessURI partitionURI;
    private Table currOutTab = null;
    private Database currOutDB = null;

    public HiveAuthzBindingHook() throws Exception {
        SessionState session = SessionState.get();
        if (session == null) {
            throw new IllegalStateException("Session has not been started");
        }
        SessionState.get().setAuthorizer(null);
        HiveConf hiveConf = session.getConf();
        if (hiveConf == null) {
            throw new IllegalStateException("Session HiveConf is null");
        }
        this.authzConf = HiveAuthzBindingHook.loadAuthzConf(hiveConf);
        this.hiveAuthzBinding = new HiveAuthzBinding(hiveConf, this.authzConf);
    }

    public static HiveAuthzConf loadAuthzConf(HiveConf hiveConf) {
        boolean depreicatedConfigFile = false;
        HiveAuthzConf newAuthzConf = null;
        String hiveAuthzConf = hiveConf.get("hive.sentry.conf.url");
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            hiveAuthzConf = hiveConf.get("hive.access.conf.url");
            depreicatedConfigFile = true;
        }
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            newAuthzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            if (depreicatedConfigFile) {
                throw new IllegalArgumentException("Configuration key hive.access.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
            }
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
        return newAuthzConf;
    }

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 608: 
            case 657: 
            case 679: 
            case 687: 
            case 868: {
                this.currDB = new Database(BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText()));
                break;
            }
            case 663: 
            case 664: {
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 633: 
            case 640: 
            case 641: 
            case 643: 
            case 644: 
            case 659: 
            case 689: 
            case 692: 
            case 693: 
            case 756: 
            case 843: 
            case 916: {
                this.currTab = this.extractTable((ASTNode)ast.getFirstChildWithType(897));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 610: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 849: {
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                int children = ast.getChildCount();
                for (int i = 1; i < children; ++i) {
                    ASTNode child = (ASTNode)ast.getChild(i);
                    if (child.getToken().getType() != 26) continue;
                    this.currDB = new Database(child.getText());
                    break;
                }
                this.currTab = Table.ALL;
                break;
            }
            case 612: 
            case 619: 
            case 626: 
            case 628: 
            case 629: 
            case 631: 
            case 838: 
            case 840: 
            case 850: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 760: {
                this.currOutTab = this.extractTable((ASTNode)ast.getChild(1));
                this.currOutDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 613: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                this.partitionURI = HiveAuthzBindingHook.extractPartition(ast);
                break;
            }
            case 658: {
                String udfClassName = BaseSemanticAnalyzer.unescapeSQLString((String)ast.getChild(1).getText());
                try {
                    CodeSource udfSrc = Class.forName(udfClassName).getProtectionDomain().getCodeSource();
                    if (udfSrc == null) {
                        throw new SemanticException("Could not resolve the jar for UDF class " + udfClassName);
                    }
                    String udfJar = udfSrc.getLocation().getPath();
                    if (udfJar == null || udfJar.isEmpty()) {
                        throw new SemanticException("Could not find the jar for UDF class " + udfClassName + "to validate privileges");
                    }
                    this.udfURI = HiveAuthzBindingHook.parseURI(udfSrc.getLocation().toString(), true);
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException("Error retrieving udf class", (Throwable)e);
                }
                this.currDB = Database.ALL;
                break;
            }
            case 688: {
                this.currDB = Database.ALL;
                break;
            }
            case 754: {
                String dbName = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(1).getChild(0).getChild(0).getText());
                this.currDB = new Database(dbName);
                break;
            }
            default: {
                this.currDB = this.getCanonicalDb();
            }
        }
        return ast;
    }

    private Database getCanonicalDb() {
        return new Database(SessionState.get().getCurrentDatabase());
    }

    private Database extractDatabase(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Database(tableName.split("\\.")[0]);
        }
        return this.getCanonicalDb();
    }

    private Table extractTable(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Table(tableName.split("\\.")[1]);
        }
        return new Table(tableName);
    }

    @VisibleForTesting
    protected static AccessURI extractPartition(ASTNode ast) throws SemanticException {
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() != 788 || child.getChildCount() != 1) continue;
            return HiveAuthzBindingHook.parseURI(BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(0).getText()));
        }
        return null;
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri) throws SemanticException {
        return HiveAuthzBindingHook.parseURI(uri, false);
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri, boolean isLocal) throws SemanticException {
        try {
            HiveConf conf = SessionState.get().getConf();
            String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
            return new AccessURI(PathUtils.parseURI((String)warehouseDir, (String)uri, (boolean)isLocal));
        }
        catch (Exception e) {
            throw new SemanticException("Error parsing URI " + uri + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        HiveOperation stmtOperation = this.getCurrentHiveStmtOp();
        HiveAuthzPrivileges stmtAuthObject = HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(stmtOperation);
        Subject subject = this.getCurrentSubject(context);
        Set<String> subjectGroups = this.hiveAuthzBinding.getGroups(subject);
        for (Task<? extends Serializable> task : rootTasks) {
            if (!(task instanceof SentryGrantRevokeTask)) continue;
            SentryGrantRevokeTask sentryTask = (SentryGrantRevokeTask)task;
            sentryTask.setHiveAuthzBinding(this.hiveAuthzBinding);
            sentryTask.setAuthzConf(this.authzConf);
            sentryTask.setSubject(subject);
            sentryTask.setSubjectGroups(subjectGroups);
            sentryTask.setIpAddress(context.getIpAddress());
            sentryTask.setOperation(stmtOperation);
        }
        try {
            if (stmtAuthObject == null) {
                return;
            }
            for (int i = 0; i < rootTasks.size(); ++i) {
                Task<? extends Serializable> task;
                task = rootTasks.get(i);
                if (!(task instanceof DDLTask)) continue;
                SentryFilterDDLTask filterTask = new SentryFilterDDLTask(this.hiveAuthzBinding, subject, stmtOperation);
                filterTask.setWork((Serializable)((DDLWork)task.getWork()));
                rootTasks.set(i, (Task<? extends Serializable>)filterTask);
            }
            this.authorizeWithHiveBindings(context, stmtAuthObject, stmtOperation);
        }
        catch (AuthorizationException e) {
            this.executeOnFailureHooks(context, stmtOperation, e);
            String permsRequired = "";
            for (String perm : this.hiveAuthzBinding.getLastQueryPrivilegeErrors()) {
                permsRequired = permsRequired + perm + ";";
            }
            SessionState.get().getConf().set("sentry.hive.authorization.errors", permsRequired);
            String msgForLog = "No valid privileges\n Required privileges for this query: " + permsRequired;
            String msgForConsole = "No valid privileges\n " + e.getMessage();
            LOG.info(msgForLog);
            throw new SemanticException(msgForConsole, (Throwable)e);
        }
        finally {
            this.hiveAuthzBinding.close();
        }
        if ("true".equalsIgnoreCase(context.getConf().get("sentry.hive.mock.compilation"))) {
            throw new SemanticException("sentry.hive.mock.error Mock query compilation aborted. Set sentry.hive.mock.compilation to 'false' for normal query processing");
        }
    }

    private void executeOnFailureHooks(HiveSemanticAnalyzerHookContext context, HiveOperation hiveOp, AuthorizationException e) {
        SentryOnFailureHookContextImpl hookCtx = new SentryOnFailureHookContextImpl(context.getCommand(), context.getInputs(), context.getOutputs(), hiveOp, this.currDB, this.currTab, this.udfURI, null, context.getUserName(), context.getIpAddress(), e, context.getConf());
        String csHooks = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), "").trim();
        try {
            for (Hook aofh : HiveAuthzBindingHook.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookCtx);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    public static void runFailureHook(SentryOnFailureHookContext hookContext, String csHooks) {
        try {
            for (Hook aofh : HiveAuthzBindingHook.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookContext);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    private void authorizeWithHiveBindings(HiveSemanticAnalyzerHookContext context, HiveAuthzPrivileges stmtAuthObject, HiveOperation stmtOperation) throws AuthorizationException {
        Set inputs = context.getInputs();
        Set outputs = context.getOutputs();
        ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stmtAuthObject.getOperationScope() = " + (Object)((Object)stmtAuthObject.getOperationScope()));
            LOG.debug("context.getInputs() = " + context.getInputs());
            LOG.debug("context.getOutputs() = " + context.getOutputs());
        }
        switch (stmtAuthObject.getOperationScope()) {
            case SERVER: {
                ArrayList<Server> serverHierarchy = new ArrayList<Server>();
                serverHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                inputHierarchy.add(serverHierarchy);
                break;
            }
            case DATABASE: {
                ArrayList<Object> dbHierarchy = new ArrayList<Object>();
                dbHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                dbHierarchy.add(this.currDB);
                inputHierarchy.add(dbHierarchy);
                outputHierarchy.add(dbHierarchy);
                this.getInputHierarchyFromInputs(inputHierarchy, inputs);
                break;
            }
            case TABLE: {
                ArrayList<Object> externalAuthorizableHierarchy;
                if (this.partitionURI != null) {
                    inputHierarchy.add((List<DBModelAuthorizable>)ImmutableList.of((Object)this.hiveAuthzBinding.getAuthServer(), (Object)this.partitionURI));
                }
                this.getInputHierarchyFromInputs(inputHierarchy, inputs);
                for (WriteEntity writeEntity : outputs) {
                    if (this.filterWriteEntity(writeEntity)) continue;
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)writeEntity));
                    outputHierarchy.add(entityHierarchy);
                }
                if (this.currTab != null) {
                    externalAuthorizableHierarchy = new ArrayList<Object>();
                    externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    externalAuthorizableHierarchy.add(this.currDB);
                    externalAuthorizableHierarchy.add(this.currTab);
                    inputHierarchy.add(externalAuthorizableHierarchy);
                }
                if (this.currOutTab == null) break;
                externalAuthorizableHierarchy = new ArrayList();
                externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(this.currOutDB);
                externalAuthorizableHierarchy.add(this.currOutTab);
                outputHierarchy.add(externalAuthorizableHierarchy);
                break;
            }
            case FUNCTION: {
                if (this.udfURI == null) break;
                ArrayList<Object> udfUriHierarchy = new ArrayList<Object>();
                udfUriHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                udfUriHierarchy.add(this.udfURI);
                inputHierarchy.add(udfUriHierarchy);
                for (WriteEntity writeEntity : outputs) {
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)writeEntity));
                    outputHierarchy.add(entityHierarchy);
                }
                break;
            }
            case CONNECT: {
                ArrayList<Object> connectHierarchy = new ArrayList<Object>();
                connectHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                Table currTbl = Table.ALL;
                Column currCol = Column.ALL;
                if ("default".equalsIgnoreCase(this.currDB.getName()) && "false".equalsIgnoreCase(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                    this.currDB = Database.ALL;
                    currTbl = Table.SOME;
                }
                connectHierarchy.add(this.currDB);
                connectHierarchy.add(currTbl);
                connectHierarchy.add(currCol);
                inputHierarchy.add(connectHierarchy);
                outputHierarchy.add(connectHierarchy);
                break;
            }
            case COLUMN: {
                for (ReadEntity readEntity : inputs) {
                    if (readEntity.getAccessedColumns() != null && !readEntity.getAccessedColumns().isEmpty()) {
                        this.addColumnHierarchy(inputHierarchy, readEntity);
                        continue;
                    }
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
                    entityHierarchy.add(Column.ALL);
                    inputHierarchy.add(entityHierarchy);
                }
                break;
            }
            default: {
                throw new AuthorizationException("Unknown operation scope type " + stmtAuthObject.getOperationScope().toString());
            }
        }
        this.hiveAuthzBinding.authorize(stmtOperation, stmtAuthObject, this.getCurrentSubject(context), inputHierarchy, outputHierarchy);
    }

    private HiveOperation getCurrentHiveStmtOp() {
        SessionState sessState = SessionState.get();
        if (sessState == null) {
            return null;
        }
        return sessState.getHiveOperation();
    }

    private Subject getCurrentSubject(HiveSemanticAnalyzerHookContext context) {
        return new Subject(context.getUserName());
    }

    private List<DBModelAuthorizable> getAuthzHierarchyFromEntity(Entity entity) {
        ArrayList<DBModelAuthorizable> objectHierarchy = new ArrayList<DBModelAuthorizable>();
        switch (entity.getType()) {
            case TABLE: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getTable().getTableName()));
                break;
            }
            case PARTITION: 
            case DUMMYPARTITION: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getPartition().getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getPartition().getTable().getTableName()));
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                try {
                    objectHierarchy.add((DBModelAuthorizable)HiveAuthzBindingHook.parseURI(entity.toString(), entity.getType().equals((Object)Entity.Type.LOCAL_DIR)));
                    break;
                }
                catch (Exception e) {
                    throw new AuthorizationException("Failed to get File URI", (Throwable)e);
                }
            }
            case DATABASE: 
            case FUNCTION: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported entity type " + entity.getType().name());
            }
        }
        return objectHierarchy;
    }

    private void addColumnHierarchy(List<List<DBModelAuthorizable>> inputHierarchy, ReadEntity entity) {
        ArrayList<Object> entityHierarchy = new ArrayList<Object>();
        entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
        entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)entity));
        switch (entity.getType()) {
            case TABLE: 
            case PARTITION: {
                List cols = entity.getAccessedColumns();
                for (String col : cols) {
                    ArrayList<Column> colHierarchy = new ArrayList<Column>(entityHierarchy);
                    colHierarchy.add(new Column(col));
                    inputHierarchy.add(colHierarchy);
                }
                break;
            }
            default: {
                inputHierarchy.add(entityHierarchy);
            }
        }
    }

    private void getInputHierarchyFromInputs(List<List<DBModelAuthorizable>> inputHierarchy, Set<ReadEntity> inputs) {
        for (ReadEntity readEntity : inputs) {
            if (this.isChildTabForView(readEntity) || this.isDummyEntity((Entity)readEntity)) continue;
            if (readEntity.getAccessedColumns() != null && !readEntity.getAccessedColumns().isEmpty()) {
                this.addColumnHierarchy(inputHierarchy, readEntity);
                continue;
            }
            ArrayList<Object> entityHierarchy = new ArrayList<Object>();
            entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
            entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
            inputHierarchy.add(entityHierarchy);
        }
    }

    private boolean filterWriteEntity(WriteEntity writeEntity) throws AuthorizationException {
        if (writeEntity.isTempURI()) {
            return true;
        }
        try {
            if (writeEntity.getTyp().equals((Object)Entity.Type.DFS_DIR) || writeEntity.getTyp().equals((Object)Entity.Type.LOCAL_DIR)) {
                HiveConf conf = SessionState.get().getConf();
                String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
                URI scratchURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)conf.getVar(HiveConf.ConfVars.SCRATCHDIR)));
                URI requestURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)writeEntity.getLocation().getPath()));
                LOG.debug("scratchURI = " + scratchURI + ", requestURI = " + requestURI);
                if (PathUtils.impliesURI((URI)scratchURI, (URI)requestURI)) {
                    return true;
                }
                URI localScratchURI = new URI(PathUtils.parseLocalURI((String)conf.getVar(HiveConf.ConfVars.LOCALSCRATCHDIR)));
                URI localRequestURI = new URI(PathUtils.parseLocalURI((String)writeEntity.getLocation().getPath()));
                LOG.debug("localScratchURI = " + localScratchURI + ", localRequestURI = " + localRequestURI);
                if (PathUtils.impliesURI((URI)localScratchURI, (URI)localRequestURI)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to extract uri details", (Throwable)e);
        }
        return false;
    }

    public static List<String> filterShowTables(HiveAuthzBinding hiveAuthzBinding, List<String> queryResult, HiveOperation operation, String userName, String dbName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges tableMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        for (String tableName : queryResult) {
            Table table = new Table(tableName);
            Database database = new Database(dbName);
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(table);
            externalAuthorizableHierarchy.add(Column.ALL);
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveAuthzBinding.authorize(operation, tableMetaDataPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(table.getName());
            }
            catch (AuthorizationException e) {}
        }
        return filteredResult;
    }

    public static List<FieldSchema> filterShowColumns(HiveAuthzBinding hiveAuthzBinding, List<FieldSchema> cols, HiveOperation operation, String userName, String tableName, String dbName) throws SemanticException {
        ArrayList<FieldSchema> filteredResult = new ArrayList<FieldSchema>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges ColumnMetaDataPrivilege = HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(HiveOperation.SHOWCOLUMNS);
        Database database = new Database(dbName);
        Table table = new Table(tableName);
        for (FieldSchema col : cols) {
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(table);
            externalAuthorizableHierarchy.add(new Column(col.getName()));
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveAuthzBinding.authorize(operation, ColumnMetaDataPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(col);
            }
            catch (AuthorizationException e) {}
        }
        return filteredResult;
    }

    public static List<String> filterShowDatabases(HiveAuthzBinding hiveAuthzBinding, List<String> queryResult, HiveOperation operation, String userName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges anyPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Column, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        for (String dbName : queryResult) {
            Database database = null;
            if ("default".equalsIgnoreCase(dbName) && "false".equalsIgnoreCase(hiveAuthzBinding.getAuthzConf().get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                filteredResult.add("default");
                continue;
            }
            database = new Database(dbName);
            ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
            ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
            externalAuthorizableHierarchy.add(hiveAuthzBinding.getAuthServer());
            externalAuthorizableHierarchy.add(database);
            externalAuthorizableHierarchy.add(Table.ALL);
            externalAuthorizableHierarchy.add(Column.ALL);
            inputHierarchy.add(externalAuthorizableHierarchy);
            try {
                hiveAuthzBinding.authorize(operation, anyPrivilege, subject, inputHierarchy, outputHierarchy);
                filteredResult.add(database.getName());
            }
            catch (AuthorizationException e) {}
        }
        return filteredResult;
    }

    private boolean isChildTabForView(ReadEntity readEntity) {
        if (!readEntity.getType().equals((Object)Entity.Type.TABLE) && !readEntity.getType().equals((Object)Entity.Type.PARTITION)) {
            return false;
        }
        if (readEntity.getParents() != null && readEntity.getParents().size() > 0) {
            for (ReadEntity parentEntity : readEntity.getParents()) {
                if (parentEntity.getType().equals((Object)Entity.Type.TABLE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Hook> getHooks(String csHooks) throws Exception {
        return HiveAuthzBindingHook.getHooks(csHooks, Hook.class);
    }

    private static <T extends Hook> List<T> getHooks(String csHooks, Class<T> clazz) throws Exception {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (csHooks.isEmpty()) {
            return hooks;
        }
        for (String hookClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)csHooks)) {
            try {
                Hook hook = (Hook)Class.forName(hookClass, true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error(hookClass + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }

    private boolean isDummyEntity(Entity entity) {
        return entity.isDummy();
    }
}

