/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.base.Joiner;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSessionHook;
import org.apache.hive.service.cli.session.HiveSessionHookContext;

public class HiveAuthzBindingSessionHook
implements HiveSessionHook {
    public static final String SEMANTIC_HOOK = "org.apache.sentry.binding.hive.HiveAuthzBindingHook";
    public static final String PRE_EXEC_HOOK = "org.apache.sentry.binding.hive.HiveAuthzBindingPreExecHook";
    public static final String FILTER_HOOK = "org.apache.sentry.binding.hive.HiveAuthzBindingHook";
    public static final String SCRATCH_DIR_PERMISSIONS = "700";
    public static final String ACCESS_RESTRICT_LIST = Joiner.on((String)",").join((Object)HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, (Object)HiveConf.ConfVars.PREEXECHOOKS.varname, new Object[]{HiveConf.ConfVars.HIVE_EXEC_FILTER_HOOK.varname, HiveConf.ConfVars.HIVE_EXTENDED_ENITITY_CAPTURE.varname, HiveConf.ConfVars.SCRATCHDIR.varname, HiveConf.ConfVars.LOCALSCRATCHDIR.varname, HiveConf.ConfVars.METASTOREURIS.varname, HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, HiveConf.ConfVars.HADOOPBIN.varname, HiveConf.ConfVars.HIVESESSIONID.varname, HiveConf.ConfVars.HIVEAUXJARS.varname, HiveConf.ConfVars.HIVESTATSDBCONNECTIONSTRING.varname, HiveConf.ConfVars.SCRATCHDIRPERMISSION.varname, HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST.varname, HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, "hive.access.conf.url", "hive.sentry.conf.url", "hive.access.subject.name", "hive.sentry.subject.name", "hive.sentry.active.role.set"});

    public void run(HiveSessionHookContext sessionHookContext) throws HiveSQLException {
        HiveConf sessionConf = sessionHookContext.getSessionConf();
        this.appendConfVar(sessionConf, HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK.varname, "org.apache.sentry.binding.hive.HiveAuthzBindingHook");
        this.appendConfVar(sessionConf, HiveConf.ConfVars.PREEXECHOOKS.varname, PRE_EXEC_HOOK);
        this.appendConfVar(sessionConf, HiveConf.ConfVars.HIVE_EXEC_FILTER_HOOK.varname, "org.apache.sentry.binding.hive.HiveAuthzBindingHook");
        sessionConf.setBoolVar(HiveConf.ConfVars.HIVE_EXTENDED_ENITITY_CAPTURE, true);
        sessionConf.setVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST, "set");
        sessionConf.setVar(HiveConf.ConfVars.SCRATCHDIRPERMISSION, SCRATCH_DIR_PERMISSIONS);
        sessionConf.set("hive.access.subject.name", sessionHookContext.getSessionUser());
        sessionConf.set("hive.sentry.subject.name", sessionHookContext.getSessionUser());
        this.appendConfVar(sessionConf, "mapreduce.job.acl-view-job", sessionHookContext.getSessionUser());
        this.appendConfVar(sessionConf, "mapreduce.job.acl-modify-job", sessionHookContext.getSessionUser());
        sessionConf.addToRestrictList(ACCESS_RESTRICT_LIST);
    }

    private void appendConfVar(HiveConf sessionConf, String confVar, String sentryConfVal) {
        String currentValue = sessionConf.get(confVar, "").trim();
        currentValue = currentValue.isEmpty() ? sentryConfVal : sentryConfVal + "," + currentValue;
        sessionConf.set(confVar, currentValue);
    }
}

