/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.binding.hive;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.HiveDriverFilterHook;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookContext;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookResult;
import org.apache.hadoop.hive.ql.HiveDriverFilterHookResultImpl;
import org.apache.hadoop.hive.ql.exec.SentryGrantRevokeTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.Hook;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.sentry.binding.hive.SentryOnFailureHook;
import org.apache.sentry.binding.hive.SentryOnFailureHookContext;
import org.apache.sentry.binding.hive.SentryOnFailureHookContextImpl;
import org.apache.sentry.binding.hive.authz.HiveAuthzBinding;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivileges;
import org.apache.sentry.binding.hive.authz.HiveAuthzPrivilegesMap;
import org.apache.sentry.binding.hive.conf.HiveAuthzConf;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.DBModelAction;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthzBindingHook
extends AbstractSemanticAnalyzerHook
implements HiveDriverFilterHook {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthzBindingHook.class);
    private final HiveAuthzBinding hiveAuthzBinding;
    private final HiveAuthzConf authzConf;
    private Database currDB = Database.ALL;
    private Table currTab;
    private AccessURI udfURI;
    private AccessURI partitionURI;

    public HiveAuthzBindingHook() throws Exception {
        SessionState session = SessionState.get();
        if (session == null) {
            throw new IllegalStateException("Session has not been started");
        }
        HiveConf hiveConf = session.getConf();
        if (hiveConf == null) {
            throw new IllegalStateException("Session HiveConf is null");
        }
        this.authzConf = HiveAuthzBindingHook.loadAuthzConf(hiveConf);
        this.hiveAuthzBinding = new HiveAuthzBinding(hiveConf, this.authzConf);
    }

    public static HiveAuthzConf loadAuthzConf(HiveConf hiveConf) {
        boolean depreicatedConfigFile = false;
        HiveAuthzConf newAuthzConf = null;
        String hiveAuthzConf = hiveConf.get("hive.sentry.conf.url");
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            hiveAuthzConf = hiveConf.get("hive.access.conf.url");
            depreicatedConfigFile = true;
        }
        if (hiveAuthzConf == null || (hiveAuthzConf = hiveAuthzConf.trim()).isEmpty()) {
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url value '" + hiveAuthzConf + "' is invalid.");
        }
        try {
            newAuthzConf = new HiveAuthzConf(new URL(hiveAuthzConf));
        }
        catch (MalformedURLException e) {
            if (depreicatedConfigFile) {
                throw new IllegalArgumentException("Configuration key hive.access.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
            }
            throw new IllegalArgumentException("Configuration key hive.sentry.conf.url specifies a malformed URL '" + hiveAuthzConf + "'", e);
        }
        return newAuthzConf;
    }

    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        switch (ast.getToken().getType()) {
            case 587: 
            case 629: 
            case 650: 
            case 658: 
            case 826: {
                this.currDB = new Database(BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(0).getText()));
                break;
            }
            case 635: 
            case 636: {
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 608: 
            case 613: 
            case 615: 
            case 616: 
            case 617: 
            case 631: 
            case 660: 
            case 663: 
            case 665: 
            case 801: 
            case 807: {
                this.currTab = this.extractTable((ASTNode)ast.getFirstChildWithType(856));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 590: 
            case 595: 
            case 601: 
            case 603: 
            case 604: 
            case 606: 
            case 796: 
            case 798: 
            case 808: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                break;
            }
            case 591: {
                this.currTab = this.extractTable((ASTNode)ast.getChild(0));
                this.currDB = this.extractDatabase((ASTNode)ast.getChild(0));
                this.partitionURI = HiveAuthzBindingHook.extractPartition(ast);
                break;
            }
            case 630: {
                String udfClassName = BaseSemanticAnalyzer.unescapeSQLString((String)ast.getChild(1).getText());
                try {
                    CodeSource udfSrc = Class.forName(udfClassName).getProtectionDomain().getCodeSource();
                    if (udfSrc == null) {
                        throw new SemanticException("Could not resolve the jar for UDF class " + udfClassName);
                    }
                    String udfJar = udfSrc.getLocation().getPath();
                    if (udfJar == null || udfJar.isEmpty()) {
                        throw new SemanticException("Could not find the jar for UDF class " + udfClassName + "to validate privileges");
                    }
                    this.udfURI = HiveAuthzBindingHook.parseURI(udfSrc.getLocation().toString(), true);
                }
                catch (ClassNotFoundException e) {
                    throw new SemanticException("Error retrieving udf class", (Throwable)e);
                }
                this.currDB = Database.ALL;
                break;
            }
            case 659: {
                this.currDB = Database.ALL;
                break;
            }
            case 716: {
                String dbName = BaseSemanticAnalyzer.unescapeIdentifier((String)ast.getChild(1).getChild(0).getChild(0).getText());
                this.currDB = new Database(dbName);
                break;
            }
            default: {
                this.currDB = this.getCanonicalDb();
            }
        }
        return ast;
    }

    private Database getCanonicalDb() {
        return new Database(SessionState.get().getCurrentDatabase());
    }

    private Database extractDatabase(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Database(tableName.split("\\.")[0]);
        }
        return this.getCanonicalDb();
    }

    private Table extractTable(ASTNode ast) throws SemanticException {
        String tableName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast);
        if (tableName.contains(".")) {
            return new Table(tableName.split("\\.")[1]);
        }
        return new Table(tableName);
    }

    @VisibleForTesting
    protected static AccessURI extractPartition(ASTNode ast) throws SemanticException {
        for (int i = 0; i < ast.getChildCount(); ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            if (child.getToken().getType() != 750 || child.getChildCount() != 1) continue;
            return HiveAuthzBindingHook.parseURI(BaseSemanticAnalyzer.unescapeSQLString((String)child.getChild(0).getText()));
        }
        return null;
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri) throws SemanticException {
        return HiveAuthzBindingHook.parseURI(uri, false);
    }

    @VisibleForTesting
    protected static AccessURI parseURI(String uri, boolean isLocal) throws SemanticException {
        try {
            HiveConf conf = SessionState.get().getConf();
            String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
            return new AccessURI(PathUtils.parseDFSURI((String)warehouseDir, (String)uri, (boolean)isLocal));
        }
        catch (Exception e) {
            throw new SemanticException("Error parsing URI " + uri + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        HiveOperation stmtOperation = this.getCurrentHiveStmtOp();
        HiveAuthzPrivileges stmtAuthObject = HiveAuthzPrivilegesMap.getHiveAuthzPrivileges(stmtOperation);
        Subject subject = this.getCurrentSubject(context);
        Set<String> subjectGroups = this.hiveAuthzBinding.getGroups(subject);
        for (Task<? extends Serializable> task : rootTasks) {
            if (!(task instanceof SentryGrantRevokeTask)) continue;
            SentryGrantRevokeTask sentryTask = (SentryGrantRevokeTask)task;
            sentryTask.setHiveAuthzBinding(this.hiveAuthzBinding);
            sentryTask.setAuthzConf(this.authzConf);
            sentryTask.setSubject(subject);
            sentryTask.setSubjectGroups(subjectGroups);
            sentryTask.setIpAddress(context.getIpAddress());
            sentryTask.setOperation(stmtOperation);
        }
        if (stmtAuthObject == null) {
            return;
        }
        try {
            this.authorizeWithHiveBindings(context, stmtAuthObject, stmtOperation);
        }
        catch (AuthorizationException e) {
            this.executeOnFailureHooks(context, stmtOperation, e);
            String permsRequired = "";
            for (String perm : this.hiveAuthzBinding.getLastQueryPrivilegeErrors()) {
                permsRequired = permsRequired + perm + ";";
            }
            context.getConf().set("sentry.hive.authorization.errors", permsRequired);
            throw new SemanticException("No valid privileges", (Throwable)e);
        }
        if ("true".equalsIgnoreCase(context.getConf().get("hive.sentry.mock.compilation"))) {
            throw new SemanticException("hive.sentry.mock.error Mock query compilation aborted. Set hive.sentry.mock.compilation to 'false' for normal query processing");
        }
        this.hiveAuthzBinding.set(context.getConf());
    }

    private void executeOnFailureHooks(HiveSemanticAnalyzerHookContext context, HiveOperation hiveOp, AuthorizationException e) {
        SentryOnFailureHookContextImpl hookCtx = new SentryOnFailureHookContextImpl(context.getCommand(), context.getInputs(), context.getOutputs(), hiveOp, this.currDB, this.currTab, this.udfURI, this.partitionURI, context.getUserName(), context.getIpAddress(), e, context.getConf());
        String csHooks = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_ONFAILURE_HOOKS.getVar(), "").trim();
        try {
            for (Hook aofh : HiveAuthzBindingHook.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookCtx);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    public static void runFailureHook(SentryOnFailureHookContext hookContext, String csHooks) {
        try {
            for (Hook aofh : HiveAuthzBindingHook.getHooks(csHooks)) {
                ((SentryOnFailureHook)aofh).run(hookContext);
            }
        }
        catch (Exception ex) {
            LOG.error("Error executing hook:", (Throwable)ex);
        }
    }

    private void authorizeWithHiveBindings(HiveSemanticAnalyzerHookContext context, HiveAuthzPrivileges stmtAuthObject, HiveOperation stmtOperation) throws AuthorizationException {
        Set inputs = context.getInputs();
        Set outputs = context.getOutputs();
        ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stmtAuthObject.getOperationScope() = " + (Object)((Object)stmtAuthObject.getOperationScope()));
            LOG.debug("context.getInputs() = " + context.getInputs());
            LOG.debug("context.getOutputs() = " + context.getOutputs());
        }
        switch (stmtAuthObject.getOperationScope()) {
            case SERVER: {
                ArrayList<Server> serverHierarchy = new ArrayList<Server>();
                serverHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                inputHierarchy.add(serverHierarchy);
                break;
            }
            case DATABASE: {
                ArrayList<Object> dbHierarchy = new ArrayList<Object>();
                dbHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                dbHierarchy.add(this.currDB);
                inputHierarchy.add(dbHierarchy);
                outputHierarchy.add(dbHierarchy);
                for (ReadEntity readEntity : inputs) {
                    if (this.isChildTabForView(readEntity)) continue;
                    if (this.isUDF(readEntity)) {
                        if (!this.isBuiltinUDF(readEntity)) continue;
                        this.checkUDFWhiteList(readEntity.getUDF().getDisplayName());
                        continue;
                    }
                    ArrayList<Object> entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
                    inputHierarchy.add(entityHierarchy);
                }
                break;
            }
            case TABLE: {
                ArrayList<Object> entityHierarchy;
                if (this.partitionURI != null) {
                    inputHierarchy.add((List<DBModelAuthorizable>)ImmutableList.of((Object)this.hiveAuthzBinding.getAuthServer(), (Object)this.partitionURI));
                }
                for (ReadEntity readEntity : inputs) {
                    if (this.isChildTabForView(readEntity)) continue;
                    if (this.isUDF(readEntity)) {
                        if (!this.isBuiltinUDF(readEntity)) continue;
                        this.checkUDFWhiteList(readEntity.getUDF().getDisplayName());
                        continue;
                    }
                    entityHierarchy = new ArrayList<Object>();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)readEntity));
                    inputHierarchy.add(entityHierarchy);
                }
                for (WriteEntity writeEntity : outputs) {
                    if (this.filterWriteEntity(writeEntity)) continue;
                    entityHierarchy = new ArrayList();
                    entityHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    entityHierarchy.addAll(this.getAuthzHierarchyFromEntity((Entity)writeEntity));
                    outputHierarchy.add(entityHierarchy);
                }
                if (this.currTab == null) break;
                ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
                externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(this.currDB);
                externalAuthorizableHierarchy.add(this.currTab);
                inputHierarchy.add(externalAuthorizableHierarchy);
                break;
            }
            case CONNECT: {
                ArrayList<Object> connectHierarchy = new ArrayList<Object>();
                connectHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                Table currTbl = Table.ALL;
                if ("default".equalsIgnoreCase(this.currDB.getName()) && "false".equalsIgnoreCase(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false")) || stmtOperation.equals((Object)HiveOperation.CREATEFUNCTION) || stmtOperation.equals((Object)HiveOperation.DROPFUNCTION)) {
                    this.currDB = Database.ALL;
                    currTbl = Table.SOME;
                }
                connectHierarchy.add(this.currDB);
                connectHierarchy.add(currTbl);
                inputHierarchy.add(connectHierarchy);
                if (this.udfURI != null) {
                    ArrayList<Object> udfUriHierarchy = new ArrayList<Object>();
                    udfUriHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                    udfUriHierarchy.add(this.udfURI);
                    inputHierarchy.add(udfUriHierarchy);
                }
                outputHierarchy.add(connectHierarchy);
                break;
            }
            default: {
                throw new AuthorizationException("Unknown operation scope type " + stmtAuthObject.getOperationScope().toString());
            }
        }
        this.hiveAuthzBinding.authorize(stmtOperation, stmtAuthObject, this.getCurrentSubject(context), inputHierarchy, outputHierarchy);
        this.hiveAuthzBinding.set(context.getConf());
    }

    private boolean isUDF(ReadEntity readEntity) {
        return readEntity.getType().equals((Object)Entity.Type.UDF);
    }

    private boolean isBuiltinUDF(ReadEntity readEntity) {
        return readEntity.getType().equals((Object)Entity.Type.UDF) && readEntity.getUDF().isNative();
    }

    private void checkUDFWhiteList(String queryUDF) throws AuthorizationException {
        String whiteList = this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_UDF_WHITELIST.getVar());
        if (whiteList == null) {
            return;
        }
        for (String hiveUDF : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)whiteList)) {
            if (!queryUDF.equalsIgnoreCase(hiveUDF)) continue;
            return;
        }
        throw new AuthorizationException("The UDF " + queryUDF + " is not found in the list of allowed UDFs");
    }

    private HiveOperation getCurrentHiveStmtOp() {
        SessionState sessState = SessionState.get();
        if (sessState == null) {
            return null;
        }
        return sessState.getHiveOperation();
    }

    private Subject getCurrentSubject(HiveSemanticAnalyzerHookContext context) {
        return new Subject(context.getUserName());
    }

    private List<DBModelAuthorizable> getAuthzHierarchyFromEntity(Entity entity) {
        ArrayList<DBModelAuthorizable> objectHierarchy = new ArrayList<DBModelAuthorizable>();
        switch (entity.getType()) {
            case TABLE: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getTable().getTableName()));
                break;
            }
            case PARTITION: {
                objectHierarchy.add((DBModelAuthorizable)new Database(entity.getPartition().getTable().getDbName()));
                objectHierarchy.add((DBModelAuthorizable)new Table(entity.getPartition().getTable().getTableName()));
                break;
            }
            case DFS_DIR: 
            case LOCAL_DIR: {
                try {
                    objectHierarchy.add((DBModelAuthorizable)HiveAuthzBindingHook.parseURI(entity.toString()));
                    break;
                }
                catch (Exception e) {
                    throw new AuthorizationException("Failed to get File URI", (Throwable)e);
                }
            }
            case DATABASE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported entity type " + entity.getType().name());
            }
        }
        return objectHierarchy;
    }

    private boolean filterWriteEntity(WriteEntity writeEntity) throws AuthorizationException {
        try {
            if (writeEntity.getTyp().equals((Object)Entity.Type.DFS_DIR) || writeEntity.getTyp().equals((Object)Entity.Type.LOCAL_DIR)) {
                HiveConf conf = SessionState.get().getConf();
                String warehouseDir = conf.getVar(HiveConf.ConfVars.METASTOREWAREHOUSE);
                URI scratchURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)conf.getVar(HiveConf.ConfVars.SCRATCHDIR)));
                URI requestURI = new URI(PathUtils.parseDFSURI((String)warehouseDir, (String)writeEntity.getLocation().getPath()));
                LOG.debug("scratchURI = " + scratchURI + ", requestURI = " + requestURI);
                if (PathUtils.impliesURI((URI)scratchURI, (URI)requestURI)) {
                    return true;
                }
                URI localScratchURI = new URI(PathUtils.parseLocalURI((String)conf.getVar(HiveConf.ConfVars.LOCALSCRATCHDIR)));
                URI localRequestURI = new URI(PathUtils.parseLocalURI((String)writeEntity.getLocation().getPath()));
                LOG.debug("localScratchURI = " + localScratchURI + ", localRequestURI = " + localRequestURI);
                if (PathUtils.impliesURI((URI)localScratchURI, (URI)localRequestURI)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new AuthorizationException("Failed to extract uri details", (Throwable)e);
        }
        return false;
    }

    private List<String> filterShowTables(List<String> queryResult, HiveOperation operation, String userName, String dbName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges tableMetaDataPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.TABLE).setOperationType(HiveAuthzPrivileges.HiveOperationType.INFO).build();
        for (String queryResultItem : queryResult) {
            Object[] tableNameArray;
            for (Object tableName : tableNameArray = (Object[])queryResultItem) {
                Table table = new Table((String)tableName);
                Database database = new Database(dbName);
                ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
                externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(database);
                externalAuthorizableHierarchy.add(table);
                inputHierarchy.add(externalAuthorizableHierarchy);
                try {
                    this.hiveAuthzBinding.authorize(operation, tableMetaDataPrivilege, subject, inputHierarchy, outputHierarchy);
                    filteredResult.add(table.getName());
                }
                catch (AuthorizationException e) {
                    // empty catch block
                }
            }
        }
        return filteredResult;
    }

    private List<String> filterShowDatabases(List<String> queryResult, HiveOperation operation, String userName) throws SemanticException {
        ArrayList<String> filteredResult = new ArrayList<String>();
        Subject subject = new Subject(userName);
        HiveAuthzPrivileges anyPrivilege = new HiveAuthzPrivileges.AuthzPrivilegeBuilder().addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.Table, EnumSet.of(DBModelAction.SELECT, DBModelAction.INSERT)).addInputObjectPriviledge(DBModelAuthorizable.AuthorizableType.URI, EnumSet.of(DBModelAction.SELECT)).setOperationScope(HiveAuthzPrivileges.HiveOperationScope.CONNECT).setOperationType(HiveAuthzPrivileges.HiveOperationType.QUERY).build();
        for (String queryResultItem : queryResult) {
            Object[] dbNameArray;
            for (Object dbName : dbNameArray = (Object[])queryResultItem) {
                Database database = null;
                if ("default".equalsIgnoreCase((String)dbName) && "false".equalsIgnoreCase(this.authzConf.get(HiveAuthzConf.AuthzConfVars.AUTHZ_RESTRICT_DEFAULT_DB.getVar(), "false"))) {
                    filteredResult.add("default");
                    continue;
                }
                database = new Database((String)dbName);
                ArrayList<List<DBModelAuthorizable>> inputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<List<DBModelAuthorizable>> outputHierarchy = new ArrayList<List<DBModelAuthorizable>>();
                ArrayList<Object> externalAuthorizableHierarchy = new ArrayList<Object>();
                externalAuthorizableHierarchy.add(this.hiveAuthzBinding.getAuthServer());
                externalAuthorizableHierarchy.add(database);
                externalAuthorizableHierarchy.add(Table.ALL);
                inputHierarchy.add(externalAuthorizableHierarchy);
                try {
                    this.hiveAuthzBinding.authorize(operation, anyPrivilege, subject, inputHierarchy, outputHierarchy);
                    filteredResult.add(database.getName());
                }
                catch (AuthorizationException e) {
                    // empty catch block
                }
            }
        }
        return filteredResult;
    }

    public HiveDriverFilterHookResult postDriverFetch(HiveDriverFilterHookContext hookContext) throws Exception {
        HiveDriverFilterHookResultImpl hookResult = new HiveDriverFilterHookResultImpl();
        HiveOperation hiveOperation = hookContext.getHiveOperation();
        ArrayList<String> queryResult = new ArrayList();
        queryResult = hookContext.getResult();
        List<String> filteredResult = null;
        String userName = hookContext.getUserName();
        String operationName = hiveOperation.getOperationName();
        if ("SHOWTABLES".equalsIgnoreCase(operationName)) {
            filteredResult = this.filterShowTables(queryResult, hiveOperation, userName, hookContext.getDbName());
        } else if ("SHOWDATABASES".equalsIgnoreCase(operationName)) {
            filteredResult = this.filterShowDatabases(queryResult, hiveOperation, userName);
        }
        hookResult.setHiveOperation(hiveOperation);
        hookResult.setResult(filteredResult);
        hookResult.setUserName(userName);
        hookResult.setConf(hookContext.getConf());
        return hookResult;
    }

    private boolean isChildTabForView(ReadEntity readEntity) {
        if (!readEntity.getType().equals((Object)Entity.Type.TABLE) && !readEntity.getType().equals((Object)Entity.Type.PARTITION)) {
            return false;
        }
        if (readEntity.getParents() != null && readEntity.getParents().size() > 0) {
            for (ReadEntity parentEntity : readEntity.getParents()) {
                if (parentEntity.getType().equals((Object)Entity.Type.TABLE)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<Hook> getHooks(String csHooks) throws Exception {
        return HiveAuthzBindingHook.getHooks(csHooks, Hook.class);
    }

    private static <T extends Hook> List<T> getHooks(String csHooks, Class<T> clazz) throws Exception {
        ArrayList<Hook> hooks = new ArrayList<Hook>();
        if (csHooks.isEmpty()) {
            return hooks;
        }
        for (String hookClass : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)csHooks)) {
            try {
                Hook hook = (Hook)Class.forName(hookClass, true, JavaUtils.getClassLoader()).newInstance();
                hooks.add(hook);
            }
            catch (ClassNotFoundException e) {
                LOG.error(hookClass + " Class not found:" + e.getMessage());
                throw e;
            }
        }
        return hooks;
    }
}

