/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.pigunit;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.impl.PigContext;
import org.apache.pig.test.Util;

public class Cluster {
    private final Configuration configuration;

    public Cluster(PigContext context) {
        this.configuration = ConfigurationUtil.toConfiguration((Properties)context.getProperties());
    }

    public boolean exists(Path destination) throws IOException {
        FileSystem fs = destination.getFileSystem(this.configuration);
        return fs.exists(destination);
    }

    public void update(Path local, Path destination) throws IOException {
        if (!this.exists(destination) || !this.sameSize(local, destination)) {
            this.copyFromLocalFile(local, destination, true);
        }
    }

    public void copyFromLocalFile(Path local, Path destination) throws IOException {
        this.copyFromLocalFile(local, destination, true);
    }

    public void copyFromLocalFile(Path local, Path destination, boolean overwrite) throws IOException {
        FileSystem fs = local.getFileSystem(this.configuration);
        fs.copyFromLocalFile(false, overwrite, local, destination);
    }

    public void copyFromLocalFile(String[] content, String destination) throws IOException {
        this.copyFromLocalFile(content, destination, true);
    }

    public void copyFromLocalFile(String[] content, String destination, boolean overwrite) throws IOException {
        Path file = new Path(destination);
        FileSystem fs = file.getFileSystem(this.configuration);
        if (overwrite && fs.exists(file)) {
            fs.delete(file, true);
        }
        Util.createInputFile(fs, destination, content);
    }

    public void copyFromLocalFile(String[][] data) throws IOException {
        this.copyFromLocalFile(data, false);
    }

    public void copyFromLocalFile(String[][] data, boolean overwrite) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.copyFromLocalFile(new Path(data[i][0]), new Path(data[i][1]), overwrite);
        }
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.configuration);
        return fs.listStatus(path);
    }

    public boolean delete(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(this.configuration);
        return fs.delete(path, true);
    }

    private boolean sameSize(Path local, Path destination) throws IOException {
        LocalFileSystem fs1 = FileSystem.getLocal((Configuration)this.configuration);
        FileSystem fs2 = destination.getFileSystem(this.configuration);
        return fs1.getFileStatus(local).getLen() == fs2.getFileStatus(destination).getLen();
    }
}

