/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.test;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.util.VersionInfo;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.pig.ExecType;
import org.apache.pig.ExecTypeProvider;
import org.apache.pig.PigException;
import org.apache.pig.PigServer;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.HExecutionEngine;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MRCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceLauncher;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.builtin.Utf8StorageConverter;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DefaultBagFactory;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.LogUtils;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanOptimizer;
import org.apache.pig.newplan.logical.optimizer.LogicalPlanPrinter;
import org.apache.pig.newplan.logical.optimizer.SchemaResetter;
import org.apache.pig.newplan.logical.optimizer.UidResetter;
import org.apache.pig.newplan.logical.relational.LogToPhyTranslationVisitor;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalSchema;
import org.apache.pig.newplan.logical.visitor.DanglingNestedNodeRemover;
import org.apache.pig.newplan.logical.visitor.SortInfoSetter;
import org.apache.pig.newplan.logical.visitor.StoreAliasSetter;
import org.apache.pig.parser.ParserException;
import org.apache.pig.parser.QueryParserDriver;
import org.apache.pig.test.MiniGenericCluster;
import org.apache.pig.test.Util;
import org.apache.pig.tools.grunt.GruntParser;
import org.apache.pig.tools.pigscript.parser.ParseException;
import org.apache.pig.tools.pigstats.ScriptState;
import org.junit.Assert;

public class Util {
    private static BagFactory mBagFactory = BagFactory.getInstance();
    private static TupleFactory mTupleFactory = TupleFactory.getInstance();
    public static final boolean WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final String TEST_DIR = System.getProperty("test.build.dir", "build/test");

    public static Tuple loadFlatTuple(Tuple t, int[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)new Integer(input[i]));
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, String[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)input[i]);
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, DataByteArray[] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            t.set(i, (Object)input[i]);
        }
        return t;
    }

    public static Tuple loadNestTuple(Tuple t, int[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, (Object)input[i]);
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static Tuple loadNestTuple(Tuple t, long[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, (Object)new Long(input[i]));
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static <T> Tuple loadNestTuple(Tuple t, T[] input) throws ExecException {
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple f = TupleFactory.getInstance().newTuple(1);
            f.set(0, input[i]);
            bag.add(f);
        }
        t.set(0, (Object)bag);
        return t;
    }

    public static <T> Tuple[] splitCreateBagOfTuples(T[] input, int bagSize) throws ExecException {
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        for (int from = 0; from < input.length; from += bagSize) {
            Tuple t = TupleFactory.getInstance().newTuple(1);
            int to = from + bagSize < input.length ? from + bagSize : input.length;
            T[] array = Arrays.copyOfRange(input, from, to);
            result.add(Util.loadNestTuple(t, array));
        }
        return result.toArray(new Tuple[0]);
    }

    public static <T> void addToTuple(Tuple t, T[] b) {
        for (int i = 0; i < b.length; ++i) {
            t.append(b[i]);
        }
    }

    public static Tuple buildTuple(Object ... args) throws ExecException {
        return TupleFactory.getInstance().newTupleNoCopy((List)Lists.newArrayList((Object[])args));
    }

    public static Tuple buildBinTuple(Object ... args) throws IOException {
        return TupleFactory.getInstance().newTuple(Lists.transform((List)Lists.newArrayList((Object[])args), (Function)new /* Unavailable Anonymous Inner Class!! */));
    }

    public static <T> Tuple createTuple(T[] s) {
        Tuple t = mTupleFactory.newTuple();
        Util.addToTuple(t, s);
        return t;
    }

    public static DataBag createBag(Tuple[] t) {
        DataBag b = mBagFactory.newDefaultBag();
        for (int i = 0; i < t.length; ++i) {
            b.add(t[i]);
        }
        return b;
    }

    public static <T> DataBag createBagOfOneColumn(T[] input) throws ExecException {
        DataBag result = mBagFactory.newDefaultBag();
        for (int i = 0; i < input.length; ++i) {
            Tuple t = mTupleFactory.newTuple(1);
            t.set(0, input[i]);
            result.add(t);
        }
        return result;
    }

    public static Map<String, Object> createMap(String[] contents) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        for (int i = 0; i < contents.length; i += 2) {
            m.put(contents[i], contents[i + 1]);
        }
        return m;
    }

    public static <T> DataByteArray[] toDataByteArrays(T[] input) {
        DataByteArray[] dbas = new DataByteArray[input.length];
        for (int i = 0; i < input.length; ++i) {
            dbas[i] = input[i] == null ? null : new DataByteArray(input[i].toString().getBytes());
        }
        return dbas;
    }

    public static Tuple loadNestTuple(Tuple t, int[][] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            Tuple f = Util.loadFlatTuple(TupleFactory.getInstance().newTuple(input[i].length), input[i]);
            bag.add(f);
            t.set(i, (Object)bag);
        }
        return t;
    }

    public static Tuple loadTuple(Tuple t, String[][] input) throws ExecException {
        for (int i = 0; i < input.length; ++i) {
            DataBag bag = BagFactory.getInstance().newDefaultBag();
            Tuple f = Util.loadTuple(TupleFactory.getInstance().newTuple(input[i].length), input[i]);
            bag.add(f);
            t.set(i, (Object)bag);
        }
        return t;
    }

    public static String removeColon(String origPath) {
        return origPath.replaceAll(":", "");
    }

    public static String standardizeNewline(String origPath) {
        return origPath.replaceAll("\r\n", "\n");
    }

    public static File createInputFile(String tmpFilenamePrefix, String tmpFilenameSuffix, String[] inputData) throws IOException {
        File f = File.createTempFile(tmpFilenamePrefix, tmpFilenameSuffix);
        f.deleteOnExit();
        Util.writeToFile(f, inputData);
        return f;
    }

    public static File createLocalInputFile(String filename, String[] inputData) throws IOException {
        File f = new File(filename);
        f.deleteOnExit();
        Util.writeToFile(f, inputData);
        return f;
    }

    public static void writeToFile(File f, String[] inputData) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8"));
        for (int i = 0; i < inputData.length; ++i) {
            pw.print(inputData[i]);
            pw.print("\n");
        }
        pw.close();
    }

    public static void createInputFile(MiniGenericCluster miniCluster, String fileName, String[] inputData) throws IOException {
        FileSystem fs = miniCluster.getFileSystem();
        Util.createInputFile(fs, fileName, inputData);
    }

    public static void createInputFile(FileSystem fs, String fileName, String[] inputData) throws IOException {
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        if (fs.exists(new Path(fileName))) {
            throw new IOException("File " + fileName + " already exists on the FileSystem");
        }
        FSDataOutputStream stream = fs.create(new Path(fileName));
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
        for (int i = 0; i < inputData.length; ++i) {
            pw.print(inputData[i]);
            pw.print("\n");
        }
        pw.close();
    }

    public static String[] readOutput(FileSystem fs, String fileName) throws IOException {
        Path path;
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        if (!fs.exists(path = new Path(fileName))) {
            throw new IOException("Path " + fileName + " does not exist on the FileSystem");
        }
        FileStatus fileStatus = fs.getFileStatus(path);
        FileStatus[] files = fileStatus.isDir() ? fs.listStatus(path, (PathFilter)new /* Unavailable Anonymous Inner Class!! */) : new FileStatus[]{fileStatus};
        ArrayList<String> result = new ArrayList<String>();
        for (FileStatus f : files) {
            String line;
            FSDataInputStream stream = fs.open(f.getPath());
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            br.close();
        }
        return result.toArray(new String[result.size()]);
    }

    public static OutputStream createInputFile(MiniGenericCluster cluster, String fileName) throws IOException {
        FileSystem fs = cluster.getFileSystem();
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        if (fs.exists(new Path(fileName))) {
            throw new IOException("File " + fileName + " already exists on the minicluster");
        }
        return fs.create(new Path(fileName));
    }

    public static File createTempFileDelOnExit(String prefix, String suffix) throws IOException {
        File tmpFile = File.createTempFile(prefix, suffix);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static void deleteFile(MiniGenericCluster miniCluster, String fileName) throws IOException {
        FileSystem fs = miniCluster.getFileSystem();
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        fs.delete(new Path(fileName), true);
    }

    public static void deleteFile(PigContext pigContext, String fileName) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        fs.delete(new Path(fileName), true);
    }

    public static boolean exists(PigContext pigContext, String fileName) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (WINDOWS) {
            fileName = fileName.replace('\\', '/');
        }
        return fs.exists(new Path(fileName));
    }

    public static void checkQueryOutputs(Iterator<Tuple> actualResults, Tuple[] expectedResults) {
        Util.checkQueryOutputs(actualResults, Arrays.asList(expectedResults));
    }

    public static void checkQueryOutputs(Iterator<Tuple> actualResults, List<Tuple> expectedResults) {
        int count = 0;
        for (Tuple expected : expectedResults) {
            Tuple actual = actualResults.next();
            ++count;
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
        }
        Assert.assertEquals((long)expectedResults.size(), (long)count);
    }

    public static void checkQueryOutputs(Iterator<Tuple> actualResults, Iterator<Tuple> expectedResults, Integer expectedRows) {
        int count = 0;
        while (expectedResults.hasNext()) {
            Tuple expected = expectedResults.next();
            Assert.assertTrue((String)"Actual result has less records than expected results", (boolean)actualResults.hasNext());
            Tuple actual = actualResults.next();
            Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
            ++count;
        }
        Assert.assertFalse((String)"Actual result has more records than expected results", (boolean)actualResults.hasNext());
        if (expectedRows != null) {
            Assert.assertEquals((long)expectedRows.intValue(), (long)count);
        }
    }

    public static void checkQueryOutputsAfterSort(Iterator<Tuple> actualResultsIt, List<Tuple> expectedResList) {
        ArrayList<Tuple> actualResList = new ArrayList<Tuple>();
        while (actualResultsIt.hasNext()) {
            actualResList.add(actualResultsIt.next());
        }
        Util.checkQueryOutputsAfterSort(actualResList, expectedResList);
    }

    public static void checkQueryOutputsAfterSort(List<Tuple> actualResList, List<Tuple> expectedResList) {
        Collections.sort(actualResList);
        Collections.sort(expectedResList);
        Assert.assertEquals((String)"Comparing actual and expected results. ", expectedResList, actualResList);
    }

    public static void checkStrContainsSubStr(String str, String subStr) {
        if (!str.contains(subStr)) {
            Assert.fail((String)("String '" + subStr + "' is not a substring of '" + str + "'"));
        }
    }

    public static void checkExceptionMessage(String query, String alias, String expectedErr) throws IOException {
        PigServer pig = new PigServer(ExecType.LOCAL);
        boolean foundEx = false;
        try {
            Util.registerMultiLineQuery(pig, query);
            pig.explain(alias, System.out);
        }
        catch (FrontendException e) {
            foundEx = true;
            Util.checkMessageInException(e, expectedErr);
        }
        if (!foundEx) {
            Assert.fail((String)"No exception thrown. Exception is expected.");
        }
    }

    public static void checkMessageInException(FrontendException e, String expectedErr) {
        PigException pigEx = LogUtils.getPigException((Throwable)e);
        String message = pigEx.getMessage();
        Util.checkErrorMessageContainsExpected(message, expectedErr);
    }

    public static void checkErrorMessageContainsExpected(String message, String expectedMessage) {
        if (!message.contains(expectedMessage)) {
            String msg = "Expected error message containing '" + expectedMessage + "' but got '" + message + "'";
            Assert.fail((String)msg);
        }
    }

    private static String getMkDirCommandForHadoop2_0(String fileName) {
        if (Utils.isHadoop23() || Utils.isHadoop2()) {
            Path parentDir = new Path(fileName).getParent();
            String mkdirCommand = parentDir.getName().isEmpty() ? "" : "fs -mkdir -p " + parentDir + "\n";
            return mkdirCommand;
        }
        return "";
    }

    public static void copyFromLocalToCluster(MiniGenericCluster cluster, String localFileName, String fileNameOnCluster) throws IOException {
        if (WINDOWS) {
            localFileName = !localFileName.contains(":") ? localFileName.replace('\\', '/') : localFileName.replace('/', '\\');
            fileNameOnCluster = fileNameOnCluster.replace('\\', '/');
        }
        PigServer ps = new PigServer(cluster.getExecType(), cluster.getProperties());
        String script = Util.getMkDirCommandForHadoop2_0(fileNameOnCluster) + "fs -put " + localFileName + " " + fileNameOnCluster;
        GruntParser parser = new GruntParser((Reader)new StringReader(script), ps);
        parser.setInteractive(false);
        try {
            parser.parseStopOnError();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    public static void copyFromLocalToLocal(String fromLocalFileName, String toLocalFileName) throws IOException {
        FileUtils.copyFile((File)new File(fromLocalFileName), (File)new File(toLocalFileName));
    }

    public static void copyFromClusterToLocal(MiniGenericCluster cluster, String fileNameOnCluster, String localFileName) throws IOException {
        File parent;
        if (WINDOWS) {
            fileNameOnCluster = fileNameOnCluster.replace('\\', '/');
            localFileName = localFileName.replace('\\', '/');
        }
        if (!(parent = new File(localFileName).getParentFile()).exists()) {
            parent.mkdirs();
        }
        PrintWriter writer = new PrintWriter(new FileWriter(localFileName));
        FileSystem fs = FileSystem.get((Configuration)ConfigurationUtil.toConfiguration((Properties)cluster.getProperties()));
        if (!fs.exists(new Path(fileNameOnCluster))) {
            throw new IOException("File " + fileNameOnCluster + " does not exists on the minicluster");
        }
        String line = null;
        FileStatus fst = fs.getFileStatus(new Path(fileNameOnCluster));
        if (fst.isDir()) {
            throw new IOException("Only files from cluster can be copied locally, " + fileNameOnCluster + " is a directory");
        }
        FSDataInputStream stream = fs.open(new Path(fileNameOnCluster));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream));
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
        reader.close();
        writer.close();
    }

    public static void printQueryOutput(Iterator<Tuple> actualResults, Tuple[] expectedResults) {
        System.out.println("Expected :");
        for (Tuple expected : expectedResults) {
            System.out.println(expected.toString());
        }
        System.out.println("---End----");
        System.out.println("Actual :");
        while (actualResults.hasNext()) {
            System.out.println(actualResults.next().toString());
        }
        System.out.println("---End----");
    }

    public static String encodeEscape(String str) {
        String regex = "\\\\";
        String replacement = Matcher.quoteReplacement("\\\\");
        return str.replaceAll(regex, replacement);
    }

    public static String generateURI(String filename, PigContext context) throws IOException {
        if (WINDOWS) {
            filename = filename.replace('\\', '/');
        }
        if (context.getExecType() == ExecType.MAPREDUCE || context.getExecType().name().equals("TEZ")) {
            return FileLocalizer.hadoopify((String)filename, (PigContext)context);
        }
        if (context.getExecType().isLocal()) {
            return filename;
        }
        throw new IllegalStateException("ExecType: " + context.getExecType());
    }

    public static Object getPigConstant(String pigConstantAsString) throws ParserException {
        QueryParserDriver queryParser = new QueryParserDriver(new PigContext(), "util", new HashMap());
        return queryParser.parseConstant(pigConstantAsString);
    }

    public static List<Tuple> getTuplesFromConstantTupleStrings(String[] tupleConstants) throws ParserException {
        ArrayList<Tuple> result = new ArrayList<Tuple>(tupleConstants.length);
        for (int i = 0; i < tupleConstants.length; ++i) {
            result.add((Tuple)Util.getPigConstant(tupleConstants[i]));
        }
        return result;
    }

    public static List<Tuple> getTuplesFromConstantTupleStringAsByteArray(String[] tupleConstants) throws ParserException, ExecException {
        List<Tuple> tuples = Util.getTuplesFromConstantTupleStrings(tupleConstants);
        for (Tuple t : tuples) {
            Util.convertStringToDataByteArray(t);
        }
        return tuples;
    }

    private static void convertStringToDataByteArray(Tuple t) throws ExecException {
        if (t == null) {
            return;
        }
        for (int i = 0; i < t.size(); ++i) {
            Object col = t.get(i);
            if (col == null) continue;
            if (col instanceof String) {
                DataByteArray dba = col == null ? null : new DataByteArray((String)col);
                t.set(i, (Object)dba);
                continue;
            }
            if (col instanceof Tuple) {
                Util.convertStringToDataByteArray((Tuple)col);
                continue;
            }
            if (!(col instanceof DataBag)) continue;
            Iterator it = ((DataBag)col).iterator();
            while (it.hasNext()) {
                Util.convertStringToDataByteArray((Tuple)it.next());
            }
        }
    }

    public static File createFile(String[] data) throws Exception {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        for (int i = 0; i < data.length; ++i) {
            pw.println(data[i]);
        }
        pw.close();
        return f;
    }

    public static LogicalPlan optimizeNewLP(LogicalPlan lp) throws FrontendException {
        DanglingNestedNodeRemover DanglingNestedNodeRemover2 = new DanglingNestedNodeRemover((OperatorPlan)lp);
        DanglingNestedNodeRemover2.visit();
        UidResetter uidResetter = new UidResetter((OperatorPlan)lp);
        uidResetter.visit();
        SchemaResetter schemaResetter = new SchemaResetter((OperatorPlan)lp, true);
        schemaResetter.visit();
        StoreAliasSetter storeAliasSetter = new StoreAliasSetter((OperatorPlan)lp);
        storeAliasSetter.visit();
        LogicalPlanOptimizer optimizer = new LogicalPlanOptimizer((OperatorPlan)lp, 100, null);
        optimizer.optimize();
        SortInfoSetter sortInfoSetter = new SortInfoSetter((OperatorPlan)lp);
        sortInfoSetter.visit();
        return lp;
    }

    public static PhysicalPlan buildPhysicalPlanFromNewLP(LogicalPlan lp, PigContext pc) throws Exception {
        LogToPhyTranslationVisitor visitor = new LogToPhyTranslationVisitor((OperatorPlan)lp);
        visitor.setPigContext(pc);
        visitor.visit();
        return visitor.getPhysicalPlan();
    }

    public static MROperPlan buildMRPlan(PhysicalPlan pp, PigContext pc) throws Exception {
        MRCompiler comp = new MRCompiler(pp, pc);
        comp.compile();
        comp.aggregateScalarsFiles();
        comp.connectSoftLink();
        return comp.getMRPlan();
    }

    public static MROperPlan buildMRPlanWithOptimizer(PhysicalPlan pp, PigContext pc) throws Exception {
        MapRedUtil.checkLeafIsStore((PhysicalPlan)pp, (PigContext)pc);
        MapReduceLauncher launcher = new MapReduceLauncher();
        Method compile = launcher.getClass().getDeclaredMethod("compile", PhysicalPlan.class, PigContext.class);
        compile.setAccessible(true);
        return (MROperPlan)compile.invoke((Object)launcher, pp, pc);
    }

    public static MROperPlan buildMRPlan(String query, PigContext pc) throws Exception {
        LogicalPlan lp = Util.parse(query, pc);
        Util.optimizeNewLP(lp);
        PhysicalPlan pp = Util.buildPhysicalPlanFromNewLP(lp, pc);
        MROperPlan mrp = Util.buildMRPlanWithOptimizer(pp, pc);
        return mrp;
    }

    public static void registerMultiLineQuery(PigServer pigServer, String query) throws IOException {
        File f = File.createTempFile("tmp", "");
        PrintWriter pw = new PrintWriter(f);
        pw.println(query);
        pw.close();
        pigServer.registerScript(f.getCanonicalPath());
    }

    public static int executeJavaCommand(String cmd) throws Exception {
        return Util.executeJavaCommandAndReturnInfo((String)cmd).exitCode;
    }

    public static ProcessReturnInfo executeJavaCommandAndReturnInfo(String cmd) throws Exception {
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null) {
            String fileSeparator = System.getProperty("file.separator");
            cmd = javaHome + fileSeparator + "bin" + fileSeparator + cmd;
        }
        Process cmdProc = Runtime.getRuntime().exec(cmd);
        ProcessReturnInfo pri = new ProcessReturnInfo();
        ReadStream stdoutStream = new ReadStream(cmdProc.getInputStream());
        ReadStream stderrStream = new ReadStream(cmdProc.getErrorStream());
        stdoutStream.start();
        stderrStream.start();
        cmdProc.waitFor();
        pri.exitCode = cmdProc.exitValue();
        pri.stdoutContents = stdoutStream.getMessage();
        pri.stderrContents = stderrStream.getMessage();
        return pri;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    Util.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public static void createInputFile(PigContext pigContext, String fileName, String[] input) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        Util.createInputFile(FileSystem.get((Configuration)conf), fileName, input);
    }

    public static String[] readOutput(PigContext pigContext, String fileName) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration((Properties)pigContext.getProperties());
        return Util.readOutput(FileSystem.get((Configuration)conf), fileName);
    }

    public static void printPlan(LogicalPlan logicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        LogicalPlanPrinter pp = new LogicalPlanPrinter((OperatorPlan)logicalPlan, ps);
        pp.visit();
        System.err.println(out.toString());
    }

    public static void printPlan(PhysicalPlan physicalPlan) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(out);
        physicalPlan.explain(ps, "text", true);
        System.err.println(out.toString());
    }

    public static List<Tuple> readFile2TupleList(String file, String delimiter) throws IOException {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        String line = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((line = reader.readLine()) != null) {
            String[] tokens = line.split(delimiter);
            Tuple tuple = TupleFactory.getInstance().newTuple(Arrays.asList(tokens));
            tuples.add(tuple);
        }
        reader.close();
        return tuples;
    }

    public static File resetLog(Class<?> clazz, File logFile) throws Exception {
        if (logFile != null) {
            logFile.delete();
        }
        Logger logger = Logger.getLogger(clazz);
        logger.removeAllAppenders();
        logger.setLevel(Level.DEBUG);
        SimpleLayout layout = new SimpleLayout();
        File newLogFile = File.createTempFile("log", "");
        FileAppender appender = new FileAppender((Layout)layout, newLogFile.toString(), false, false, 0);
        logger.addAppender((Appender)appender);
        return newLogFile;
    }

    public static void checkLogFileMessage(File logFile, String[] messages, boolean expected) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(logFile));
            String logMessage = "";
            while ((line = reader.readLine()) != null) {
                logMessage = logMessage + line + "\n";
            }
            reader.close();
            for (int i = 0; i < messages.length; ++i) {
                boolean present = logMessage.contains(messages[i]);
                if (expected) {
                    if (present) continue;
                    Assert.fail((String)("The message " + messages[i] + " is not present in" + "log file contents: " + logMessage));
                    continue;
                }
                if (!present) continue;
                Assert.fail((String)("The message " + messages[i] + " is present in" + "log file contents: " + logMessage));
            }
            return;
        }
        catch (IOException e) {
            Assert.fail((String)("caught exception while checking log message :" + e));
            return;
        }
    }

    public static LogicalPlan buildLp(PigServer pigServer, String query) throws Exception {
        pigServer.setBatchOn();
        pigServer.registerQuery(query);
        Method buildLp = pigServer.getClass().getDeclaredMethod("buildLp", new Class[0]);
        buildLp.setAccessible(true);
        return (LogicalPlan)buildLp.invoke((Object)pigServer, new Object[0]);
    }

    public static PhysicalPlan buildPp(PigServer pigServer, String query) throws Exception {
        LogicalPlan lp = Util.buildLp(pigServer, query);
        lp.optimize(pigServer.getPigContext());
        return ((HExecutionEngine)pigServer.getPigContext().getExecutionEngine()).compile(lp, pigServer.getPigContext().getProperties());
    }

    public static LogicalPlan parse(String query, PigContext pc) throws FrontendException {
        HashMap fileNameMap = new HashMap();
        QueryParserDriver parserDriver = new QueryParserDriver(pc, "test", fileNameMap);
        LogicalPlan lp = parserDriver.parse(query);
        lp.validate(pc, "test", false);
        return lp;
    }

    public static LogicalPlan parseAndPreprocess(String query, PigContext pc) throws FrontendException {
        HashMap fileNameMap = new HashMap();
        QueryParserDriver parserDriver = new QueryParserDriver(pc, "test", fileNameMap);
        LogicalPlan lp = parserDriver.parse(query);
        lp.validate(pc, "test", false);
        return lp;
    }

    public static void schemaReplaceNullAlias(Schema sch) {
        if (sch == null) {
            return;
        }
        for (Schema.FieldSchema fs : sch.getFields()) {
            if (fs.alias != null && fs.alias.toLowerCase().startsWith("nullalias")) {
                fs.alias = null;
            }
            Util.schemaReplaceNullAlias(fs.schema);
        }
    }

    public static void checkQueryOutputsAfterSort(Iterator<Tuple> actualResultsIt, Tuple[] expectedResArray) {
        ArrayList<Tuple> list = new ArrayList<Tuple>();
        Collections.addAll(list, expectedResArray);
        Util.checkQueryOutputsAfterSort(actualResultsIt, list);
    }

    private static void convertBagToSortedBag(Tuple t) {
        for (int i = 0; i < t.size(); ++i) {
            Object obj = null;
            try {
                obj = t.get(i);
            }
            catch (ExecException e) {
                // empty catch block
            }
            if (!(obj instanceof DataBag)) continue;
            DataBag bag = (DataBag)obj;
            Iterator iter = bag.iterator();
            DataBag sortedBag = DefaultBagFactory.getInstance().newSortedBag(null);
            while (iter.hasNext()) {
                Tuple t2 = (Tuple)iter.next();
                sortedBag.add(t2);
                Util.convertBagToSortedBag(t2);
            }
            try {
                t.set(i, (Object)sortedBag);
                continue;
            }
            catch (ExecException e) {
                // empty catch block
            }
        }
    }

    public static void checkQueryOutputsAfterSortRecursive(Iterator<Tuple> actualResultsIt, String[] expectedResArray, String schemaString) throws IOException {
        LogicalSchema resultSchema = Utils.parseSchema((String)schemaString);
        Util.checkQueryOutputsAfterSortRecursive(actualResultsIt, expectedResArray, resultSchema);
    }

    public static void checkQueryOutputsAfterSortRecursive(Iterator<Tuple> actualResultsIt, String[] expectedResArray, LogicalSchema schema) throws IOException {
        LogicalSchema.LogicalFieldSchema fs = new LogicalSchema.LogicalFieldSchema("tuple", schema, 110);
        ResourceSchema.ResourceFieldSchema rfs = new ResourceSchema.ResourceFieldSchema(fs);
        Utf8StorageConverter caster = new Utf8StorageConverter();
        ArrayList<Tuple> actualResList = new ArrayList<Tuple>();
        while (actualResultsIt.hasNext()) {
            actualResList.add(actualResultsIt.next());
        }
        ArrayList<Tuple> expectedResList = new ArrayList<Tuple>();
        for (String str : expectedResArray) {
            Tuple newTuple = caster.bytesToTuple(str.getBytes(), rfs);
            expectedResList.add(newTuple);
        }
        for (Tuple t : actualResList) {
            Util.convertBagToSortedBag(t);
        }
        for (Tuple t : expectedResList) {
            Util.convertBagToSortedBag(t);
        }
        Collections.sort(actualResList);
        Collections.sort(expectedResList);
        Assert.assertEquals((String)"Comparing actual and expected results. ", expectedResList, actualResList);
    }

    public static String readFile(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String result = "";
        while ((line = reader.readLine()) != null) {
            result = result + line;
            result = result + "\n";
        }
        reader.close();
        return result;
    }

    public static String removeSignature(String plan) {
        return plan.replaceAll("','','[^']*','scope','true'\\)\\)", "','','','scope','true'))");
    }

    public static boolean isHadoop203plus() {
        String version = VersionInfo.getVersion();
        return !version.matches("\\b0\\.20\\.2\\b");
    }

    public static boolean isHadoop205() {
        String version = VersionInfo.getVersion();
        return version.matches("\\b0\\.20\\.205\\..+");
    }

    public static boolean isHadoop1_x() {
        String version = VersionInfo.getVersion();
        return version.matches("\\b1\\.*\\..+");
    }

    public static void assertParallelValues(long defaultParallel, long requestedParallel, long estimatedParallel, long runtimeParallel, Configuration conf) {
        Util.assertConfLong(conf, "pig.info.reducers.default.parallel", defaultParallel);
        Util.assertConfLong(conf, "pig.info.reducers.requested.parallel", requestedParallel);
        Util.assertConfLong(conf, "pig.info.reducers.estimated.parallel", estimatedParallel);
        Util.assertConfLong(conf, "mapred.reduce.tasks", runtimeParallel);
    }

    public static void assertConfLong(Configuration conf, String param, long expected) {
        Assert.assertEquals((String)("Unexpected value found in configs for " + param), (long)expected, (long)conf.getLong(param, -1L));
    }

    public static PathFilter getSuccessMarkerPathFilter() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static void assertExceptionAndMessage(Class<?> expected, Exception found, String message) {
        Assert.assertEquals(expected, found.getClass());
        Assert.assertEquals((Object)found.getMessage(), (Object)message);
    }

    public static void resetStateForExecModeSwitch() {
        FileLocalizer.setInitialized((boolean)false);
        ScriptState.start(null);
    }

    public static boolean isMapredExecType(ExecType execType) {
        return execType == ExecType.MAPREDUCE;
    }

    public static String findPigJarName() {
        File baseDir = new File(".");
        String suffix = System.getProperty("hadoopversion").equals("20") ? "1" : "2";
        String[] jarNames = baseDir.list((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        if (jarNames == null || jarNames.length != 1) {
            throw new RuntimeException("Cannot find pig.jar");
        }
        return jarNames[0];
    }

    public static ExecType getLocalTestMode() throws Exception {
        String execType = System.getProperty("test.exec.type");
        if (execType != null && execType.equals("tez")) {
            return ExecTypeProvider.fromString((String)"tez_local");
        }
        return ExecTypeProvider.fromString((String)"local");
    }

    public static void createLogAppender(String appenderName, Writer writer, Class ... clazzes) {
        for (Class clazz : clazzes) {
            Logger logger = Logger.getLogger((Class)clazz);
            WriterAppender writerAppender = new WriterAppender((Layout)new PatternLayout("%d [%t] %-5p %c %x - %m%n"), writer);
            writerAppender.setName(appenderName);
            logger.addAppender((Appender)writerAppender);
        }
    }

    public static void removeLogAppender(Class clazz, String appenderName) {
        Logger logger = Logger.getLogger((Class)clazz);
        Appender appender = logger.getAppender(appenderName);
        appender.close();
        logger.removeAppender(appenderName);
    }

    public static Path getFirstPartFile(Path path) throws Exception {
        FileStatus[] parts = FileSystem.get((URI)path.toUri(), (Configuration)new Configuration()).listStatus(path, (PathFilter)new /* Unavailable Anonymous Inner Class!! */);
        return parts[0].getPath();
    }

    public static File getFirstPartFile(File dir) throws Exception {
        File[] parts = dir.listFiles((FilenameFilter)new /* Unavailable Anonymous Inner Class!! */);
        return parts[0];
    }

    public static String getTestDirectory(Class testClass) {
        return TEST_DIR + "/" + "testdata" + "/" + testClass.getSimpleName();
    }
}

